/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.logic.util;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.datatype.ERETime;
import com.ericsson.ere.datatype.ERETimeFactory;
import com.ericsson.ere.selectiontree.conditions.logic.util.AbstractField;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.Time;
import java.util.Calendar;
import java.util.Comparator;

public class TimeField
extends AbstractField<ERETime> {
    private static AbstractField.Operator[] operators = new AbstractField.Operator[]{AbstractField.Operator.EQUALS, AbstractField.Operator.LESS_THAN, AbstractField.Operator.GREATER_THAN, AbstractField.Operator.LESS_THAN_EQUALS, AbstractField.Operator.GREATER_THAN_EQUALS};

    public TimeField(String value) {
        super(ERETimeFactory.parseTimeString(value), DataType.TIME, new TimeComparator());
    }

    public TimeField(Object value) {
        super(value, DataType.TIME, new TimeComparator());
    }

    public TimeField(String name, boolean useTag, int tag, FieldIndexKeyContainer keyContainer) {
        super(name, useTag, tag, keyContainer, DataType.TIME, new TimeComparator());
    }

    public static String[] getOperatorArray() {
        return AbstractField.Operator.toStringArray(operators);
    }

    @Override
    public ERETime getValue(DataSet data) {
        Object retObject = super.getValue(data);
        if (retObject instanceof ERETime) {
            return (ERETime)retObject;
        }
        if (retObject instanceof Calendar) {
            retObject = ERETimeFactory.createFromCalendar((Calendar)retObject);
        } else if (retObject instanceof Time) {
            retObject = ERETimeFactory.createFromTime((Time)retObject);
        }
        return (ERETime)retObject;
    }

    @Override
    protected AbstractField.Operator[] getOrderedOperators() {
        return operators;
    }

    private static class TimeComparator
    implements Comparator<ERETime> {
        private TimeComparator() {
        }

        @Override
        public int compare(ERETime o1, ERETime o2) {
            return o1.compareTo(o2);
        }
    }
}

