/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.logic.util;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.dataset.DefaultDataDescriber;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.datatype.LazyEvaluatedValue;
import com.ericsson.ere.selectiontree.conditions.logic.util.Field;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import com.ericsson.ere.selectiontree.util.OperatorUtil;
import com.ericsson.ere.trace.PluginTraceHelper;
import com.ericsson.ere.trace.TracePoint;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepositoryUtil;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.management.Service;
import java.util.Comparator;

public abstract class AbstractField<T>
implements Field<T> {
    private final Object myValue;
    private final FieldIndexKeyContainer myKeyContainer;
    private final DataSetField myDataSetField;
    private final transient DataType myDataType;
    private final transient Comparator<? super T> myComparator;
    private static final String FIELD_NAME_VALUE = "value";

    protected AbstractField(Object value, DataType dataType, Comparator<? super T> comparator) {
        if (value != null && dataType != DataType.OBJECT) {
            this.checkValue(value, dataType.getMainTypeClass());
        }
        this.myValue = value;
        this.myKeyContainer = null;
        this.myDataSetField = null;
        this.myDataType = dataType;
        this.myComparator = comparator;
    }

    private void checkValue(Object value, Class<?> clazz) {
        if (!clazz.isInstance(value) && !(value instanceof LazyEvaluatedValue)) {
            throw new IllegalArgumentException(String.format("Invalid value type for %s, expected %s or %s.", String.valueOf(value), clazz.getName(), LazyEvaluatedValue.class.getName()));
        }
    }

    protected AbstractField(String fieldName, boolean useTag, int tag, FieldIndexKeyContainer keyContainer, DataType dataType, Comparator<? super T> comparator) {
        this.myValue = null;
        this.myKeyContainer = keyContainer;
        this.myDataSetField = new DataSetField(fieldName, tag, useTag, dataType);
        this.myDataType = dataType;
        this.myComparator = comparator;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myDataSetField == null ? 0 : this.myDataSetField.hashCode());
        result = 31 * result + (this.myKeyContainer == null ? 0 : this.myKeyContainer.hashCode());
        result = 31 * result + (this.myValue == null ? 0 : this.myValue.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractField other = (AbstractField)obj;
        if (this.myDataSetField == null ? other.myDataSetField != null : !this.myDataSetField.equals(other.myDataSetField)) {
            return false;
        }
        if (this.myValue == null ? other.myValue != null : !this.myValue.equals(other.myValue)) {
            return false;
        }
        return !(this.myKeyContainer == null ? other.myKeyContainer != null : !this.myKeyContainer.equals(other.myKeyContainer));
    }

    public boolean haveValueSet() {
        return this.myDataSetField == null;
    }

    protected boolean useTag() {
        return this.myDataSetField.usesTag();
    }

    protected int getTag() {
        return this.myDataSetField.getTag();
    }

    @Override
    public String getFieldName() {
        if (this.haveValueSet()) {
            return FIELD_NAME_VALUE;
        }
        return this.myDataSetField.getFieldName();
    }

    @Override
    public FieldIndexKeyContainer getFieldKeyContainer() {
        return this.myKeyContainer;
    }

    protected boolean useKey() {
        return this.myKeyContainer != null;
    }

    public String getOperatorString(int operator) {
        Operator[] ops = this.getOrderedOperators();
        if (operator < 0 || operator >= ops.length) {
            return "[UNKNOWN]";
        }
        return ops[operator].toString();
    }

    @Override
    public int getOperatorInt(String str) {
        Operator[] ops = this.getOrderedOperators();
        int idx = -1;
        for (int i = 0; i < ops.length; ++i) {
            if (!ops[i].toString().equals(str)) continue;
            idx = i;
            break;
        }
        return idx;
    }

    @Override
    public String getValueAsString(DataSet data) {
        return this.myDataType.makeDisplayString(this.getValue(data));
    }

    private String getTraceValue(Field<T> field, DataSet data) {
        T value;
        try {
            value = field.getValue(data);
        }
        catch (DataSetValueNotFoundException e) {
            return "[VALUE NOT FOUND]";
        }
        boolean fieldUsesField = !((AbstractField)field).haveValueSet();
        boolean thisUsesField = !this.haveValueSet();
        DefaultDataDescriber desc = new DefaultDataDescriber();
        if (thisUsesField || fieldUsesField) {
            String fieldToUse = fieldUsesField ? field.getFieldName() : this.getFieldName();
            Service service = data.getService();
            assert (service != null);
            FieldDefinition fd = service.getClassRepository(ClassRepositoryUtil.getCurrentFieldContext(data)).getFieldDefinitionByName(fieldToUse);
            if (fd != null) {
                return desc.describeObject(value, fd);
            }
        }
        return desc.describeObject(value, this.myDataType);
    }

    @Override
    public String describeTrace(int operator, Field<T> fieldToCompare, DataSet data) {
        String secondFieldName = FieldOrientedPluginUtil.formatFieldNameWithKeyInformation(fieldToCompare.getFieldName(), fieldToCompare.getFieldKeyContainer(), data);
        String secondFieldValue = this.getTraceValue(fieldToCompare, data);
        StringBuilder buf = new StringBuilder(FieldOrientedPluginUtil.formatFieldNameWithKeyInformation(this.getFieldName(), this.myKeyContainer, data)).append("(").append(this.getTraceValue(this, data)).append(") ").append(this.getOperatorString(operator)).append(" ");
        if (FIELD_NAME_VALUE.equals(secondFieldName)) {
            buf.append(secondFieldValue);
        } else {
            buf.append(secondFieldName).append("(").append(secondFieldValue).append(")");
        }
        return buf.toString();
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        if (this.myDataSetField != null) {
            PluginTraceHelper.addFieldValueAsPreDataInTracePoint(this.myDataSetField, this.myKeyContainer, tp);
        }
    }

    @Override
    public T getValue(DataSet data) {
        if (this.haveValueSet()) {
            if (this.myValue instanceof LazyEvaluatedValue) {
                return ((LazyEvaluatedValue)this.myValue).evaluate(data);
            }
            return (T)this.myValue;
        }
        if (this.useKey()) {
            return (T)this.getValueForKey(data);
        }
        return (T)this.myDataSetField.getValueFromDataSet(data);
    }

    protected Object getValueForKey(DataSet theData) {
        if (this.myKeyContainer != null) {
            Key[] keySet = this.myKeyContainer.getKeySet(theData);
            return this.myDataSetField.getValueFromDataSet(theData, keySet[0]);
        }
        return null;
    }

    @Override
    public boolean compare(int operator, Field<T> fieldToCompare, DataSet data) {
        Operator[] ops = this.getOrderedOperators();
        if (operator < 0 || operator >= ops.length) {
            return false;
        }
        T value = this.getValue(data);
        T other = fieldToCompare.getValue(data);
        return this.compare(ops[operator], value, other);
    }

    protected boolean compare(Operator op, T value, T other) {
        boolean ret = this.myComparator != null ? op.compare(this.myComparator, value, other) : (value instanceof Comparable ? op.compare((Comparable)value, other) : (op == Operator.EQUALS ? value.equals(other) : false));
        return ret;
    }

    protected Operator[] getOrderedOperators() {
        return Operator.values();
    }

    protected static enum Operator {
        EQUALS("=", OperatorUtil.Operator.EQ),
        GREATER_THAN(">", OperatorUtil.Operator.GT),
        LESS_THAN("<", OperatorUtil.Operator.LT),
        GREATER_THAN_EQUALS(">=", OperatorUtil.Operator.GTE),
        LESS_THAN_EQUALS("<=", OperatorUtil.Operator.LTE);

        private String myRep;
        private OperatorUtil.Operator myOperator;

        private Operator(String rep, OperatorUtil.Operator operator) {
            this.myRep = rep;
            this.myOperator = operator;
        }

        public String toString() {
            return this.myRep;
        }

        protected boolean compare(Comparable value, Object other) {
            int cval = value.compareTo(other);
            return this.myOperator.test(cval, 0L);
        }

        protected boolean compare(Comparator comp, Object value, Object other) {
            int cval = comp.compare(value, other);
            return this.myOperator.test(cval, 0L);
        }

        protected static String[] toStringArray(Operator[] operators) {
            String[] arr = new String[operators.length];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = operators[i].toString();
            }
            return arr;
        }
    }
}

