/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.logic;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.exception.InitializationException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.AbstractCondition;
import com.ericsson.ere.selectiontree.interfaces.Condition;
import com.ericsson.ere.selectiontree.interfaces.Conditionality;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.xml.XMLUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CompoundBooleanCondition
extends AbstractCondition
implements TraceableV2 {
    public static final String OP_AND = OperationType.AND.toString();
    @Deprecated
    public static final int OP_TYPE_AND = 0;
    public static final String OP_OR = OperationType.OR.toString();
    public static final String OP_XOR = OperationType.XOR.toString();
    @Deprecated
    public static final int OP_TYPE_OR = 1;
    public static final String OP_NOT = OperationType.NOT.toString();
    @Deprecated
    public static final int OP_TYPE_NOT = 2;
    private OperationType myOperationType;

    public static CompoundBooleanCondition create(ParseContext ctx, TariffStructureNode[] children) {
        return new CompoundBooleanCondition(ctx, children);
    }

    protected CompoundBooleanCondition(ParseContext ctx, TariffStructureNode[] children) {
        super.replaceWithImmutableConditionSuper(ctx);
        Element node = XMLUtil.getNamedElement("Operation", ctx.getXMLNode().getChildNodes());
        if (node == null) {
            throw new IllegalArgumentException("Missing tag: Operation");
        }
        String operation = XMLUtil.getFirstTextContent(node);
        try {
            this.myOperationType = OperationType.valueOf(operation);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unrecognized boolean operator: " + operation);
        }
        if (this.myOperationType == OperationType.NOT && children.length > 1) {
            throw new IllegalArgumentException("Boolean NOT operation requires single argument");
        }
        for (TariffStructureNode n : children) {
            n.setParent(this);
            if (n instanceof Conditionality) continue;
            throw new IllegalArgumentException("Not a Conditionality: " + n);
        }
        this.myConditions = Arrays.asList((Object[])children);
    }

    public CompoundBooleanCondition() {
        this.myOperationType = OperationType.AND;
    }

    public CompoundBooleanCondition(String operation, List<Conditionality> conditions) {
        try {
            this.myOperationType = OperationType.valueOf(operation);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unrecognized boolean operator: " + operation);
        }
        if (this.myOperationType == OperationType.NOT && conditions.size() != 1) {
            throw new IllegalArgumentException("Boolean NOT operation requires single argument");
        }
        if (conditions.isEmpty()) {
            throw new IllegalArgumentException("No conditions given");
        }
        this.myConditions = new ArrayList<Conditionality>(conditions);
    }

    public void addCondition(Condition cond) {
        if (this.myOperationType == OperationType.NOT && this.myConditions.size() == 1) {
            throw new IllegalArgumentException("CompoundBooleanCondition: Boolean NOT operation requires single argument");
        }
        this.myConditions.add(cond);
        ((DAGNode)((Object)cond)).setParent(this);
    }

    @Override
    public void add(Condition child) {
        this.addCondition(child);
    }

    public void printNode(Node node, int ident) {
        String name = node.getNodeName();
        String value = node.getNodeValue();
        if (name == null) {
            name = "nul";
        }
        if (value == null) {
            value = "nul";
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            this.printNode(children.item(i), ident + 1);
        }
    }

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        super.init(iterator);
        String operator = null;
        NodeList children = iterator.getChildNodes();
        if (children.getLength() > 0) {
            this.setConditionName(iterator.getChildNodes().item(0).getNodeValue().trim());
        }
        int ncond = 0;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeName().toLowerCase().equals("operation")) {
                if (!child.hasChildNodes()) continue;
                operator = child.getChildNodes().item(0).getNodeValue().trim();
                continue;
            }
            if (!child.getNodeName().toLowerCase().equals("condition")) continue;
            ++ncond;
        }
        try {
            this.myOperationType = OperationType.valueOf(operator);
        }
        catch (IllegalArgumentException e) {
            throw new InitializationException("Erroneous operator: " + operator, iterator);
        }
        this.myConditions = new ArrayList(ncond);
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + this.myOperationType.ordinal();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompoundBooleanCondition other = (CompoundBooleanCondition)obj;
        return this.myOperationType == other.myOperationType;
    }

    @Override
    public void setFieldName(String fieldName) {
        this.setKey(fieldName);
    }

    @Override
    public boolean test(DataSet theData) {
        return this.myOperationType.test(this, theData);
    }

    private boolean testAND(DataSet theData) {
        Conditionality tc;
        boolean condRes;
        int ncond = this.myConditions.size();
        boolean match = true;
        for (int i = 0; i < ncond && (match &= (condRes = this.testConditionUsingExecutor(tc = (Conditionality)this.myConditions.get(i), theData))); ++i) {
        }
        return match;
    }

    private boolean testOR(DataSet theData) {
        int ncond = this.myConditions.size();
        boolean match = false;
        for (int i = 0; i < ncond; ++i) {
            Conditionality tc = (Conditionality)this.myConditions.get(i);
            boolean condRes = this.testConditionUsingExecutor(tc, theData);
            if (condRes) {
                return true;
            }
            match |= condRes;
        }
        return match;
    }

    private boolean testXOR(DataSet theData) {
        boolean match = false;
        for (Object condition : this.myConditions) {
            match ^= this.testConditionUsingExecutor((Conditionality)condition, theData);
        }
        return match;
    }

    private boolean testNOT(DataSet theData) {
        Conditionality tc = (Conditionality)this.myConditions.get(0);
        boolean condRes = this.testConditionUsingExecutor(tc, theData);
        boolean match = !condRes;
        return match;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public long getConditionSatisfiedDuration(DataSet theData) {
        return Long.MAX_VALUE;
    }

    @Override
    public long getConditionUnsatisfiedDuration(DataSet theData) {
        return Long.MAX_VALUE;
    }

    @Override
    public String describeTrace(TracePoint tp) {
        StringBuilder traceDescription = new StringBuilder();
        traceDescription.append("CompoundBoolean : Using ").append((Object)this.myOperationType).append(" on the result from");
        traceDescription.append(this.myConditions.size() > 1 ? " all children" : " the child");
        return traceDescription.toString();
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    public static enum OperationType {
        AND{

            @Override
            public boolean test(CompoundBooleanCondition cond, DataSet dataSet) {
                return cond.testAND(dataSet);
            }
        }
        ,
        OR{

            @Override
            public boolean test(CompoundBooleanCondition cond, DataSet dataSet) {
                return cond.testOR(dataSet);
            }
        }
        ,
        XOR{

            @Override
            public boolean test(CompoundBooleanCondition cond, DataSet dataSet) {
                return cond.testXOR(dataSet);
            }
        }
        ,
        NOT{

            @Override
            public boolean test(CompoundBooleanCondition cond, DataSet dataSet) {
                return cond.testNOT(dataSet);
            }
        };


        public abstract boolean test(CompoundBooleanCondition var1, DataSet var2);
    }
}

