/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.logic;

import com.ericsson.ere.constraint.ConstraintService;
import com.ericsson.ere.constraint.LegacyAutoConditionMapProfile;
import com.ericsson.ere.constraint.contract.Constrainable;
import com.ericsson.ere.constraint.entity.ConstraintContext;
import com.ericsson.ere.constraint.entity.ConstraintContextItemType;
import com.ericsson.ere.constraint.entity.ConstraintTargetType;
import com.ericsson.ere.gui.simulator.SimulationPanelHelper;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationConditionInterface;
import com.ericsson.ere.selectiontree.FieldFilter;
import com.ericsson.ere.selectiontree.ParseContextAdapter;
import com.ericsson.ere.selectiontree.conditions.AbstractFieldOrientedConditionProfile;
import com.ericsson.ere.selectiontree.conditions.logic.BooleanFieldConditionProfile;
import com.ericsson.ere.selectiontree.conditions.logic.CompareField;
import com.ericsson.ere.selectiontree.conditions.logic.CompareFieldConfiguration;
import com.ericsson.ere.selectiontree.conditions.logic.CompareFieldProfileContract;
import com.ericsson.ere.selectiontree.conditions.number.IntegerConditionProfile;
import com.ericsson.ere.selectiontree.conditions.number.LongConditionProfile;
import com.ericsson.ere.selectiontree.conditions.number.ShortConditionProfile;
import com.ericsson.ere.selectiontree.conditions.number.UIntegerConditionProfile;
import com.ericsson.ere.selectiontree.conditions.number.ULongConditionProfile;
import com.ericsson.ere.selectiontree.conditions.number.UShortConditionProfile;
import com.ericsson.ere.selectiontree.conditions.number.UnsignedInt16ConditionProfile;
import com.ericsson.ere.selectiontree.conditions.number.UnsignedInt32ConditionProfile;
import com.ericsson.ere.selectiontree.conditions.number.UnsignedInt8ConditionProfile;
import com.ericsson.ere.selectiontree.conditions.string.BcdStringConditionProfile;
import com.ericsson.ere.selectiontree.conditions.string.OctetStringConditionProfile;
import com.ericsson.ere.selectiontree.conditions.string.StringConditionProfile;
import com.ericsson.ere.selectiontree.util.AvailableFieldListBuilder;
import com.ericsson.ere.selectiontree.util.ClassRepositoryHelper;
import com.ericsson.ere.selectiontree.util.CombinedFieldFilter;
import com.ericsson.ere.selectiontree.util.DateTimeInteroperabilityFieldFilter;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginProfileUtil;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import com.ericsson.ere.selectiontree.util.NonComplexFieldFilter;
import com.ericsson.ere.selectiontree.util.OperatorUtil;
import com.ericsson.ere.selectiontree.util.PluginConfigurationHelper;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import com.ericsson.ere.util.FieldDefinitionUtil;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldDefinitionHelper;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.gui.util.IndexVariableFactory;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.BoolVariable;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.InfoVariable;
import ericsson.vareditor.variable.LazyFieldDropDownVariable;
import ericsson.vareditor.variable.NotAllowedVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Constrainable(contractClass=CompareFieldProfileContract.class)
@LegacyAutoConditionMapProfile
public class CompareFieldProfile
extends AbstractFieldOrientedConditionProfile
implements TestCaseGenerationConditionInterface {
    private static final String LBL_USEFIELD = "Compare to field";
    private static final String LBL_FIELD1 = "Field 1";
    private static final String LBL_FIELD2 = "Field 2";
    private static final String LBL_INDEX_FOR_FIELD1 = "Index for field 1";
    private static final String LBL_INDEX_FOR_FIELD2 = "Index for field 2";
    private static final String LBL_VALUE = "Value";
    private static final String LBL_OPERATOR = "Operator";
    private static final String MSG_NO_FIELDS_EXIST = "No available fields found";
    private static final String MSG_NO_OPERATORS_EXIST = "No available operators found";
    private static final String ARRAY_MAP_SUPPORT_FEATURE = "Array_Map_Support";
    private static final String DATE_TIME_INTEROPERABILITY_FEATURE = "Date_Time_Interoperability_Support";
    private boolean mySupportArrayMap = false;
    protected boolean mySupportDateTimeInteroperability = false;

    private String[] operatortokensToDisplayableOperators(String[] operators) {
        if (operators == null) {
            return null;
        }
        String[] result = new String[operators.length];
        for (int i = 0; i < operators.length; ++i) {
            result[i] = operators[i].replace('_', ' ').toLowerCase();
        }
        return result;
    }

    private String operatortokenToDisplayableOperator(String operator) {
        if (operator == null) {
            return null;
        }
        String[] operatorArray = new String[]{operator};
        return this.operatortokensToDisplayableOperators(operatorArray)[0];
    }

    @Override
    public List<Variable> getVariables() {
        CompareFieldConfiguration conf = new CompareFieldConfiguration();
        return this.createVariables(conf, true);
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        FieldDefinition firstField;
        CompareFieldConfiguration conf = new CompareFieldConfiguration(new ParseContextAdapter(null, iterator, null));
        ArrayList<Variable> varList = new ArrayList<Variable>();
        String selectedFirstOperandField = conf.getFirstOperandField();
        AvailableFieldListBuilder firstBuilder = this.getFirstFieldListBuilder();
        if (!firstBuilder.filtersAllow(firstField = firstBuilder.getClassRepository().getFieldDefinitionByName(selectedFirstOperandField))) {
            List<FieldDefinition> list = firstBuilder.buildFieldDefinitionList();
            if (list.isEmpty()) {
                varList.add(new NotAllowedVariable(LBL_FIELD1, MSG_NO_FIELDS_EXIST));
                return varList;
            }
            varList.add(FieldOrientedPluginProfileUtil.createFilterableFieldListVariable(LBL_FIELD1, LBL_FIELD1, list, selectedFirstOperandField));
        } else {
            varList.add(new LazyFieldDropDownVariable(LBL_FIELD1, firstBuilder, selectedFirstOperandField));
        }
        this.addIndexVariable(LBL_INDEX_FOR_FIELD1, LBL_INDEX_FOR_FIELD1, selectedFirstOperandField, conf.getFirstOperandIndexConfiguration(), varList, this.createIndexVariableFactory());
        String selectedOperator = this.getSelectedOperator(selectedFirstOperandField, conf.getOperator());
        if (this.createAndAddOperatorVariable(varList, selectedFirstOperandField, selectedOperator)) {
            String secondOperandFieldName = conf.getSecondOperandField();
            boolean useField = secondOperandFieldName != null;
            varList.add(new BoolVariable(LBL_USEFIELD, useField));
            if (useField) {
                FieldDefinition secondField;
                AvailableFieldListBuilder secondBuilder = this.createBuilderForSecondField(selectedFirstOperandField, selectedOperator);
                if (!secondBuilder.filtersAllow(secondField = firstBuilder.getClassRepository().getFieldDefinitionByName(secondOperandFieldName))) {
                    List<FieldHierarchyNode> possibleSecondFieldList = secondBuilder.buildList();
                    if (possibleSecondFieldList.isEmpty()) {
                        varList.add(new NotAllowedVariable(LBL_FIELD2, MSG_NO_FIELDS_EXIST));
                        return varList;
                    }
                    varList.add(FieldOrientedPluginProfileUtil.createFilterableFieldListVariable(LBL_FIELD2, LBL_FIELD2, possibleSecondFieldList, selectedFirstOperandField));
                } else {
                    LazyFieldDropDownVariable secondFieldVariable = new LazyFieldDropDownVariable(LBL_FIELD2, secondBuilder, secondOperandFieldName);
                    varList.add(secondFieldVariable);
                }
                this.addIndexVariable(LBL_INDEX_FOR_FIELD2, LBL_INDEX_FOR_FIELD2, secondOperandFieldName, conf.getSecondOperandIndexConfiguration(), varList, this.createIndexVariableFactory());
            } else {
                this.createAndAddValueVariable(varList, selectedFirstOperandField, selectedOperator, conf.getFieldValue());
            }
        }
        return varList;
    }

    private List<Variable> createVariables(CompareFieldConfiguration conf, boolean useSameValueForBothFields) {
        String selectedOperator;
        ArrayList<Variable> varList = new ArrayList<Variable>();
        String selectedFirstOperandField = this.getSelectedFirstOperandField(conf.getFirstOperandField());
        if (this.createAndAddFirstFieldVariable(varList, selectedFirstOperandField, conf.getFirstOperandIndexConfiguration()) && this.createAndAddOperatorVariable(varList, selectedFirstOperandField, selectedOperator = this.getSelectedOperator(selectedFirstOperandField, conf.getOperator()))) {
            String secondOperandField = useSameValueForBothFields ? selectedFirstOperandField : conf.getSecondOperandField();
            boolean useField = secondOperandField != null;
            varList.add(new BoolVariable(LBL_USEFIELD, useField));
            if (useField) {
                this.createAndAddSecondFieldVariable(varList, selectedFirstOperandField, selectedOperator, secondOperandField, conf.getSecondOperandIndexConfiguration());
            } else {
                this.createAndAddValueVariable(varList, selectedFirstOperandField, selectedOperator, conf.getFieldValue());
            }
        }
        return varList;
    }

    private String getSelectedFirstOperandField(String configuredField) {
        String field = null;
        List<String> allFields = FieldDefinitionHelper.extractFieldNameList(this.extractFieldsForFirstOperand());
        if (!allFields.isEmpty() && StringUtil.isEmptyString(field = configuredField)) {
            field = allFields.get(0);
        }
        return field;
    }

    private boolean createAndAddFirstFieldVariable(List<Variable> varList, String selectedField, Element firstOperandIndex) {
        boolean wasAdded = false;
        if (selectedField == null) {
            varList.add(new NotAllowedVariable(LBL_FIELD1, MSG_NO_FIELDS_EXIST));
        } else {
            varList.add(FieldOrientedPluginProfileUtil.createFilterableFieldListVariable(LBL_FIELD1, LBL_FIELD1, this.extractFieldsForFirstOperand(), selectedField));
            this.addIndexVariable(LBL_INDEX_FOR_FIELD1, LBL_INDEX_FOR_FIELD1, selectedField, firstOperandIndex, varList, this.createIndexVariableFactory());
            wasAdded = true;
        }
        return wasAdded;
    }

    private String getSelectedOperator(String selectedFirstOperandField, String configuredOperator) {
        String[] operators;
        String operator = null;
        if (selectedFirstOperandField != null && (operators = this.extractOperatorNames(selectedFirstOperandField)).length > 0 && (operator = configuredOperator) == null) {
            operator = operators[0];
        }
        return operator;
    }

    private boolean createAndAddOperatorVariable(List<Variable> varList, String selectedFirstOperandField, String selectedOperator) {
        boolean wasAdded = false;
        if (selectedOperator == null) {
            varList.add(new NotAllowedVariable(LBL_OPERATOR, MSG_NO_OPERATORS_EXIST));
        } else {
            String displayableOperator = this.operatortokenToDisplayableOperator(selectedOperator);
            Object[] operators = this.extractOperatorNames(selectedFirstOperandField);
            Object[] displayableOperators = this.operatortokensToDisplayableOperators((String[])operators);
            varList.add(new DropDownVariable(LBL_OPERATOR, displayableOperators, operators, (Object)displayableOperator));
            wasAdded = true;
        }
        return wasAdded;
    }

    private void createAndAddSecondFieldVariable(List<Variable> varList, String selectedFirstOperandField, String selectedOperator, String selectedSecondOperandField, Element secondOperandIndex) {
        List<FieldDefinition> possibleFields = this.extractFieldsForSecondOperand(selectedFirstOperandField, selectedOperator);
        if (possibleFields.isEmpty()) {
            varList.add(new NotAllowedVariable(LBL_FIELD2, MSG_NO_FIELDS_EXIST));
        } else {
            varList.add(FieldOrientedPluginProfileUtil.createFilterableFieldListVariable(LBL_FIELD2, LBL_FIELD2, possibleFields, selectedSecondOperandField));
            this.addIndexVariable(LBL_INDEX_FOR_FIELD2, LBL_INDEX_FOR_FIELD2, selectedSecondOperandField, secondOperandIndex, varList, this.createIndexVariableFactory());
        }
    }

    private void createAndAddValueVariable(List<Variable> varList, String selectedFirstOperandField, String selectedOperator, String selectedFieldValue) {
        try {
            varList.add(this.produceInputVariableForField(selectedFirstOperandField, selectedFieldValue, selectedOperator));
        }
        catch (Exception e) {
            varList.add(new NotAllowedVariable(LBL_VALUE, e.getMessage()));
        }
    }

    private Variable produceInputVariableForField(String fieldName, String value, String operationName) throws Exception {
        FieldDefinition fieldDef = this.myClassRepository.getFieldDefinitionByName(fieldName);
        if (fieldDef == null) {
            return new StringVariable(LBL_VALUE, "");
        }
        ArrayList<String> fieldNameList = new ArrayList();
        String restriction = fieldDef.getUtilClass("InputRestriction");
        if ("RelativeDate".equals(restriction) || "RelativeTime".equals(restriction)) {
            fieldNameList = FieldDefinitionHelper.extractFieldNameList(this.extractFieldsForSecondOperand(fieldName, operationName));
        }
        Variable retVar = this.createVariableForField(LBL_VALUE, null, fieldDef, value, fieldNameList);
        return retVar;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean parameterChanged(String reference, Variable value, List<Variable> vars) {
        if (!this.isParameterCandidateForChange(reference)) return false;
        String firstOperandFieldName = VarListUtil.getValueStringForName(vars, LBL_FIELD1);
        String operator = VarListUtil.getVariableForName(vars, LBL_OPERATOR) != null ? VarListUtil.getStringValueForName(vars, LBL_OPERATOR) : null;
        Boolean useField = VarListUtil.getVariableForName(vars, LBL_USEFIELD) != null ? VarListUtil.getBooleanValueForName(vars, LBL_USEFIELD) : null;
        boolean hasChanged = false;
        if (LBL_FIELD1.equals(reference)) {
            CompareFieldProfile.removeVariablesAfter(value, vars);
            operator = null;
            hasChanged = true;
            this.addIndexVariable(LBL_INDEX_FOR_FIELD1, LBL_INDEX_FOR_FIELD1, firstOperandFieldName, null, vars, this.createIndexVariableFactory());
            Object[] operators = this.extractOperatorNames(firstOperandFieldName);
            if (operators.length > 0) {
                operator = operators[0];
                vars.add(new DropDownVariable(LBL_OPERATOR, (Object)operators[0], operators));
            } else {
                vars.add(new NotAllowedVariable(LBL_OPERATOR, MSG_NO_OPERATORS_EXIST));
                return true;
            }
        }
        if (LBL_OPERATOR.equals(reference) || VarListUtil.getVariableForName(vars, LBL_USEFIELD) == null) {
            if (!hasChanged) {
                CompareFieldProfile.removeVariablesAfter(value, vars);
                hasChanged = true;
            }
            if (useField == null) {
                useField = true;
            }
            vars.add(new BoolVariable(LBL_USEFIELD, useField));
        }
        if (LBL_FIELD2.equals(reference)) {
            if (!hasChanged) {
                CompareFieldProfile.removeVariablesAfter(value, vars);
                hasChanged = true;
            }
            if (value == null) return hasChanged;
            this.addIndexVariable(LBL_INDEX_FOR_FIELD2, LBL_INDEX_FOR_FIELD2, value.getValueString(), null, vars, this.createIndexVariableFactory());
            return hasChanged;
        }
        if (!LBL_USEFIELD.equals(reference) && (VarListUtil.getVariableForName(vars, LBL_FIELD2) != null || VarListUtil.getVariableForName(vars, LBL_VALUE) != null)) return hasChanged;
        if (!hasChanged) {
            CompareFieldProfile.removeVariablesAfter(value, vars);
            hasChanged = true;
        }
        if (useField.booleanValue()) {
            List<FieldDefinition> possibleFields = this.extractFieldsForSecondOperand(firstOperandFieldName, operator);
            if (!possibleFields.isEmpty()) {
                String defaultFieldName = possibleFields.get(0).getCanonicalName();
                vars.add(FieldOrientedPluginProfileUtil.createFilterableFieldListVariable(LBL_FIELD2, null, possibleFields, defaultFieldName));
                this.addIndexVariable(LBL_INDEX_FOR_FIELD2, LBL_INDEX_FOR_FIELD2, defaultFieldName, null, vars, this.createIndexVariableFactory());
                return hasChanged;
            }
            vars.add(new NotAllowedVariable(LBL_FIELD2, MSG_NO_FIELDS_EXIST));
            return true;
        }
        try {
            vars.add(this.produceInputVariableForField(firstOperandFieldName, null, operator));
            return hasChanged;
        }
        catch (Exception e) {
            vars.add(new InfoVariable(LBL_VALUE, e.getMessage()));
        }
        return hasChanged;
    }

    private IndexVariableFactory createIndexVariableFactory() {
        return IndexVariableFactory.buildFactory().withDateTimeInteroperability(this.mySupportDateTimeInteroperability).withFilterableFieldVariable(true).withRepository(this.myClassRepository);
    }

    private boolean isParameterCandidateForChange(String parameterLabel) {
        return LBL_FIELD1.equals(parameterLabel) || LBL_OPERATOR.equals(parameterLabel) || LBL_USEFIELD.equals(parameterLabel) || LBL_FIELD2.equals(parameterLabel) || LBL_INDEX_FOR_FIELD1.equals(parameterLabel) || LBL_INDEX_FOR_FIELD2.equals(parameterLabel);
    }

    private static void removeVariablesAfter(Variable value, List<Variable> varList) {
        while (varList.get(varList.size() - 1) != value) {
            varList.remove(varList.size() - 1);
        }
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> vars) {
        Variable firstOperandVariable = VarListUtil.getVariableForName(vars, LBL_FIELD1);
        Variable operationVariable = VarListUtil.getVariableForName(vars, LBL_OPERATOR);
        Variable secondOperandVariable = VarListUtil.getVariableForName(vars, LBL_FIELD2);
        Variable valueVariable = VarListUtil.getVariableForName(vars, LBL_VALUE);
        CompareFieldConfiguration conf = new CompareFieldConfiguration();
        if (this.isUsableVariable(firstOperandVariable)) {
            conf.setFirstOperandField(firstOperandVariable.getValueString());
            Variable indexVariable1 = VarListUtil.getVariableForKey(vars, LBL_INDEX_FOR_FIELD1);
            conf.setFirstOperandIndex(FieldOrientedPluginProfileUtil.createValueFieldCompositeObjectForVariable(indexVariable1));
        }
        if (this.isUsableVariable(operationVariable)) {
            conf.setOperator(operationVariable.getValueString());
        }
        if (this.isUsableVariable(secondOperandVariable)) {
            conf.setSecondOperandField(secondOperandVariable.getValueString());
            Variable indexVariable2 = VarListUtil.getVariableForKey(vars, LBL_INDEX_FOR_FIELD2);
            conf.setSecondOperandIndex(FieldOrientedPluginProfileUtil.createValueFieldCompositeObjectForVariable(indexVariable2));
        } else if (this.isUsableVariable(valueVariable)) {
            conf.setFieldValue(valueVariable.getValueString());
        }
        PluginConfigurationHelper.writeXML(conf, out, indentLevel, indentMarker);
    }

    private boolean isUsableVariable(Variable var) {
        return var != null && !(var instanceof NotAllowedVariable);
    }

    private List<FieldDefinition> extractFieldsForFirstOperand() {
        AvailableFieldListBuilder builder = this.getFirstFieldListBuilder();
        return builder.buildFieldDefinitionList();
    }

    private AvailableFieldListBuilder getFirstFieldListBuilder() {
        AvailableFieldListBuilder builder = AvailableFieldListBuilder.createAvailableFieldListBuilder(this.myClassRepository).withConstraints(this, null);
        for (FieldFilter filter : this.getSupportedFilters()) {
            builder.withFilter(filter);
        }
        return builder;
    }

    private List<FieldDefinition> extractFieldsForSecondOperand(String firstOperandFieldName, String operationName) {
        List<FieldDefinition> supportedFieldNamesList = this.getSupportedSecondOperandFieldList(this.myClassRepository, firstOperandFieldName);
        ConstraintContext context = new ConstraintContext.Builder().addContext(ConstraintContextItemType.FIELD, firstOperandFieldName).addContext(ConstraintContextItemType.OPERATION, operationName).build();
        List<FieldDefinition> constrainedFieldNameList = this.getConstrainedFields(supportedFieldNamesList, context);
        FieldFilter filter = this.createFieldFilterForFeatureContraining(firstOperandFieldName);
        List<FieldDefinition> featureConstrainedFieldList = FieldOrientedPluginProfileUtil.getSupportedFields(constrainedFieldNameList, filter);
        return featureConstrainedFieldList;
    }

    private FieldFilter createFieldFilterForFeatureContraining(String firstOperandFieldName) {
        ArrayList<FieldFilter> filters = new ArrayList<FieldFilter>();
        if (!this.mySupportArrayMap) {
            filters.add(new NonComplexFieldFilter());
        }
        if (!this.mySupportDateTimeInteroperability) {
            filters.add(new DateTimeInteroperabilityFieldFilter(this.myClassRepository.getFieldDefinitionByName(firstOperandFieldName)));
        }
        return new CombinedFieldFilter(filters.toArray(new FieldFilter[filters.size()]));
    }

    private String[] extractOperatorNames(String firstOperandFieldName) {
        List<String> supportedOperationNameList = this.getSupportedOperationList(this.myClassRepository, firstOperandFieldName);
        ConstraintContext context = new ConstraintContext.Builder().addContext(ConstraintContextItemType.FIELD, firstOperandFieldName).build();
        List<String> constrainedOperationNameList = ConstraintService.constrainItems(this, context, ConstraintTargetType.OPERATION, this.myClassRepository, supportedOperationNameList);
        return constrainedOperationNameList.toArray(new String[constrainedOperationNameList.size()]);
    }

    protected List<FieldDefinition> getSupportedFirstOperandFieldList(ClassRepository repository) {
        return AvailableFieldListBuilder.createAvailableFieldListBuilder(repository).withFilter(new FirstFieldFilter()).buildFieldDefinitionList();
    }

    protected List<FieldFilter> getSupportedFilters() {
        ArrayList<FieldFilter> filters = new ArrayList<FieldFilter>();
        filters.add(new FeatureFieldFilter());
        filters.add(new FirstFieldFilter());
        return filters;
    }

    protected List<String> getSupportedOperationList(ClassRepository repository, String firstOperandFieldName) {
        if (firstOperandFieldName != null && repository.getFieldDefinitionByName(firstOperandFieldName) != null) {
            String[] supportedOperationArray = CompareField.getOperatorArrayForDataForField(firstOperandFieldName, repository);
            return Arrays.asList(supportedOperationArray);
        }
        String[] allOperatorsArray = CompareField.getAllOperatorsArray(repository);
        return Arrays.asList(allOperatorsArray);
    }

    protected List<FieldDefinition> getSupportedSecondOperandFieldList(ClassRepository repository, String firstOperandFieldName) {
        if (firstOperandFieldName != null) {
            return FieldOrientedPluginProfileUtil.getSupportedFields(ClassRepositoryHelper.extractVisibleFieldsForField(firstOperandFieldName, repository), new SecondFieldFilter(firstOperandFieldName, repository));
        }
        return ClassRepositoryHelper.extractVisibleFields(repository);
    }

    @Override
    public void setClassRepository(ClassRepository repository) {
        super.setClassRepository(repository);
        this.checkFeaturesViaClassRepository(repository);
    }

    @Override
    public List<Variable> getTestVariables(Node variableValueIterator, Node testSettingsIterator) {
        Variable var;
        Element field2Element = XMLUtil.getFirstElementNamed("Field2", (Element)variableValueIterator);
        ArrayList<Variable> testCaseVariables = new ArrayList<Variable>(2);
        if (field2Element != null) {
            String field2String = XMLUtil.getFirstTextContent(field2Element);
            FieldDefinition field2 = this.myClassRepository.getFieldDefinitionByName(field2String);
            testCaseVariables.add(new InfoVariable("Information", " Field2 must be set with a default value"));
            var = SimulationPanelHelper.produceVariable(this.myClassRepository, field2);
            if (testSettingsIterator != null) {
                String otherFieldValue = XMLUtil.getFirstTextContent(XMLUtil.getNamedElement("Settings", testSettingsIterator.getChildNodes()));
                var.setValue(otherFieldValue);
            }
        } else {
            return null;
        }
        testCaseVariables.add(var);
        return testCaseVariables;
    }

    @Override
    public void printTestVariables(PrintWriter out, List<Variable> vars) {
        if (vars.size() == 2) {
            out.print("<TestSettings><Settings>" + vars.get(1).getValueString() + "</Settings>" + "</TestSettings>");
        }
    }

    @Override
    public Map<String, Object> getTestSimulationFieldValues(Node variableValueIterator, Node testSettingsIterator) throws Exception {
        Element field1Element = XMLUtil.getFirstElementNamed("Field1", (Element)variableValueIterator);
        Element operatorElement = XMLUtil.getFirstElementNamed(LBL_OPERATOR, (Element)variableValueIterator);
        Element field2Element = XMLUtil.getFirstElementNamed("Field2", (Element)variableValueIterator);
        Element fieldValueElement = XMLUtil.getFirstElementNamed("FieldValue", (Element)variableValueIterator);
        Element testValueElement = XMLUtil.getFirstElementNamed("Settings", (Element)testSettingsIterator);
        HashMap<String, Object> fieldInformation = new HashMap<String, Object>();
        String fieldValueString = null;
        if (operatorElement != null && field1Element != null) {
            String operatorString = XMLUtil.getFirstTextContent(operatorElement);
            String field1String = XMLUtil.getFirstTextContent(field1Element);
            FieldDefinition field1Def = this.myClassRepository.getFieldDefinitionByName(field1String);
            if (field2Element != null && testValueElement != null) {
                String field2String = XMLUtil.getFirstTextContent(field2Element);
                fieldValueString = XMLUtil.getFirstTextContent(testValueElement);
                fieldInformation.put(field2String, new String[]{fieldValueString});
            } else if (fieldValueElement != null) {
                fieldValueString = XMLUtil.getFirstTextContent(fieldValueElement);
            }
            if (fieldValueString != null) {
                switch (field1Def.getTypedDataType()) {
                    case DATE: 
                    case TIME: {
                        fieldInformation.put(field1String, new String[]{fieldValueString});
                        break;
                    }
                    default: {
                        TestCaseGenerationConditionInterface conditionProfile = this.createProfile(field1Def.getTypedDataType());
                        if (conditionProfile == null) break;
                        conditionProfile.setTestFieldDefinition(field1Def);
                        fieldInformation.putAll(conditionProfile.getTestSimulationFieldValues(this.createValueXML(field1Def.getTypedDataType(), fieldValueString, operatorString), null));
                    }
                }
            }
        }
        return fieldInformation;
    }

    private Element createValueXML(DataType dataType, String fieldValueString, String operatorString) {
        try {
            switch (dataType) {
                case BOOLEAN: {
                    return XMLUtil.documentFromString("<Condition><CompFieldValue>" + fieldValueString + "</CompFieldValue></Condition>").getDocumentElement();
                }
                case STRING: 
                case BCDSTRING: 
                case OCTETSTRING: {
                    return XMLUtil.documentFromString("<Condition><Text>" + XMLUtil.escape(fieldValueString) + "</" + "Text" + "><" + "Comparation" + ">" + operatorString + "</" + "Comparation" + "></Condition>").getDocumentElement();
                }
                case LONG: 
                case UNSIGNEDLONG: 
                case INTEGER: 
                case UNSIGNEDINT: 
                case SHORT: 
                case UNSIGNEDSHORT: {
                    return XMLUtil.documentFromString("<Condition><IntValue>" + fieldValueString + "</IntValue><Operator>" + operatorString + "</Operator></Condition>").getDocumentElement();
                }
                case UNSIGNEDINT32: 
                case UNSIGNEDINT16: 
                case UNSIGNEDINT8: {
                    return XMLUtil.documentFromString("<Condition><LongValue>" + fieldValueString + "</LongValue><Operator>" + operatorString + "</Operator></Condition>").getDocumentElement();
                }
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private TestCaseGenerationConditionInterface createProfile(DataType dataType) {
        switch (dataType) {
            case BOOLEAN: {
                return new BooleanFieldConditionProfile();
            }
            case STRING: {
                return new StringConditionProfile();
            }
            case LONG: {
                return new LongConditionProfile();
            }
            case UNSIGNEDLONG: {
                return new ULongConditionProfile();
            }
            case INTEGER: {
                return new IntegerConditionProfile();
            }
            case UNSIGNEDINT: {
                return new UIntegerConditionProfile();
            }
            case SHORT: {
                return new ShortConditionProfile();
            }
            case UNSIGNEDSHORT: {
                return new UShortConditionProfile();
            }
            case UNSIGNEDINT32: {
                return new UnsignedInt32ConditionProfile();
            }
            case UNSIGNEDINT16: {
                return new UnsignedInt16ConditionProfile();
            }
            case UNSIGNEDINT8: {
                return new UnsignedInt8ConditionProfile();
            }
            case BCDSTRING: {
                return new BcdStringConditionProfile();
            }
            case OCTETSTRING: {
                return new OctetStringConditionProfile();
            }
        }
        return null;
    }

    @Override
    public void setTestFieldDefinition(FieldDefinition fieldDefinition) {
    }

    @Override
    public boolean testParameterChanged(String reference, Variable value, List<Variable> vars) {
        return false;
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String desc = this.getDescription(variables);
        return GuiUtil.descriptionToTooltip(desc, this.getName(), this.getComment(variables));
    }

    @Override
    public String getDescription(List<Variable> variables) {
        StringBuilder builder = new StringBuilder();
        builder.append(super.getDescription(variables));
        builder.append(" (");
        String fieldName1 = VarListUtil.getValueStringForName(variables, LBL_FIELD1);
        if (fieldName1 == null || fieldName1.equals(MSG_NO_FIELDS_EXIST)) {
            return builder.append(MSG_NO_FIELDS_EXIST).append(")").toString();
        }
        FieldDefinition field1 = this.myClassRepository.getFieldDefinitionByName(fieldName1);
        if (field1 == null) {
            return builder.append(fieldName1).append(")").toString();
        }
        String fieldDisplay1 = this.createFieldDisplayString(field1, variables, LBL_INDEX_FOR_FIELD1);
        builder.append(fieldDisplay1).append(" ");
        String operator = VarListUtil.getValueStringForName(variables, LBL_OPERATOR);
        if (operator == null || operator.equals(MSG_NO_OPERATORS_EXIST)) {
            return builder.append(MSG_NO_OPERATORS_EXIST).append(")").toString();
        }
        String displayableOperator = this.operatortokenToDisplayableOperator(operator);
        Boolean compareToField = VarListUtil.getBooleanValueForName(variables, LBL_USEFIELD);
        builder.append(displayableOperator).append(" ");
        builder.append(this.getSecondValue(compareToField, variables, field1, true).get(LBL_VALUE));
        return builder.append(")").toString();
    }

    private Map<String, String> getSecondValue(boolean isFieldComparison, List<Variable> variables, FieldDefinition referenceField, boolean isDescriptive) {
        String valueString;
        HashMap<String, String> map = new HashMap<String, String>();
        if (isFieldComparison) {
            String fieldName2 = VarListUtil.getValueStringForName(variables, LBL_FIELD2);
            if (isDescriptive && !fieldName2.equals(MSG_NO_FIELDS_EXIST)) {
                FieldDefinition field2 = this.myClassRepository.getFieldDefinitionByName(fieldName2);
                valueString = this.createFieldDisplayString(field2, variables, LBL_INDEX_FOR_FIELD2);
            } else {
                valueString = fieldName2;
            }
            map.put("Label", LBL_FIELD2);
        } else {
            Variable valueVar = VarListUtil.getVariableForName(variables, LBL_VALUE);
            valueString = FieldOrientedPluginProfileUtil.describeValueForField(valueVar, this.myClassRepository, referenceField, isDescriptive);
            map.put("Label", LBL_VALUE);
        }
        map.put(LBL_VALUE, valueString);
        return map;
    }

    private String createFieldDisplayString(FieldDefinition field, List<Variable> variables, String indexVariableKey) {
        Variable indexVar = VarListUtil.getVariableForKey(variables, indexVariableKey);
        ValueFieldCompositeObject indexObject = FieldOrientedPluginProfileUtil.createValueFieldCompositeObjectForVariable(indexVar);
        String valueString = FieldOrientedPluginProfileUtil.formatFieldNameStringWithIndexOrKeyIfPresent(field, indexObject, this.myClassRepository);
        return valueString;
    }

    private void checkFeaturesViaClassRepository(ClassRepository repository) {
        List<String> enabledFeatures = ConstraintService.constrainFeatures(this, repository, CompareFieldProfile.getSupportedFeatures());
        this.mySupportArrayMap = enabledFeatures.contains(ARRAY_MAP_SUPPORT_FEATURE);
        this.mySupportDateTimeInteroperability = enabledFeatures.contains(DATE_TIME_INTEROPERABILITY_FEATURE);
    }

    static List<String> getSupportedFeatures() {
        return Arrays.asList(ARRAY_MAP_SUPPORT_FEATURE, DATE_TIME_INTEROPERABILITY_FEATURE);
    }

    @Override
    public Map<String, Object> getDisplayValues(Node data, Map<String, Object> prev) {
        HashMap<String, Object> displayValuesMap = prev != null ? prev : new HashMap<String, Object>();
        Element root = (Element)data;
        Element field1Element = XMLUtil.getFirstElementNamed("Field1", root);
        String field1 = XMLUtil.getFirstTextContent(field1Element);
        FieldDefinition fd = this.myClassRepository.getFieldDefinitionByName(field1);
        displayValuesMap.put(LBL_FIELD1, field1);
        Element indexElement = XMLUtil.getFirstElementNamed("Index", field1Element);
        if (indexElement != null) {
            displayValuesMap.put(LBL_INDEX_FOR_FIELD1, indexElement.getTextContent());
        }
        if (fd != null) {
            Element operatorElement = XMLUtil.getFirstElementNamed(LBL_OPERATOR, root);
            String operator = operatorElement != null ? OperatorUtil.tokenToOperator(operatorElement.getTextContent()) : MSG_NO_OPERATORS_EXIST;
            displayValuesMap.put(LBL_OPERATOR, operator);
            Element field2Element = XMLUtil.getFirstElementNamed("Field2", root);
            if (field2Element != null) {
                displayValuesMap.put(LBL_USEFIELD, "true");
                String field2 = XMLUtil.getFirstTextContent(field2Element);
                displayValuesMap.put(LBL_FIELD2, field2);
                Element index2Element = XMLUtil.getFirstElementNamed("Index", field2Element);
                if (index2Element != null) {
                    displayValuesMap.put(LBL_INDEX_FOR_FIELD2, index2Element.getTextContent());
                }
            } else {
                Element valueElement = XMLUtil.getFirstElementNamed("FieldValue", root);
                String displayString = FieldOrientedPluginUtil.describeFieldValue(fd, valueElement.getTextContent());
                displayValuesMap.put(LBL_VALUE, displayString);
            }
        }
        return displayValuesMap;
    }

    @Override
    public Map<String, Object> getDisplayValues(List<Variable> variables, Map<String, Object> prev) {
        Map<String, Object> displayValuesMap = super.getDisplayValues(variables, prev);
        String field1 = VarListUtil.getValueStringForName(variables, LBL_FIELD1);
        String useField = VarListUtil.getValueStringForName(variables, LBL_USEFIELD);
        boolean shouldUseField = Boolean.valueOf(useField);
        if (!field1.equals(MSG_NO_FIELDS_EXIST)) {
            Map<String, String> secondValues = this.getSecondValue(shouldUseField, variables, this.myClassRepository.getFieldDefinitionByName(field1), false);
            displayValuesMap.put(secondValues.get("Label"), secondValues.get(LBL_VALUE));
        }
        return displayValuesMap;
    }

    @Override
    public String[] getTreeDefinedFieldInUse(List<Variable> profileState) {
        HashSet<String> usedTDFs = new HashSet<String>();
        usedTDFs.addAll(FieldOrientedPluginProfileUtil.extractReservedTreeDefinedFieldFromVariable(VarListUtil.getVariableForKey(profileState, LBL_FIELD1), this.myClassRepository, true));
        usedTDFs.addAll(FieldOrientedPluginProfileUtil.extractReservedTreeDefinedFieldFromVariable(VarListUtil.getVariableForKey(profileState, LBL_INDEX_FOR_FIELD1), this.myClassRepository, true));
        usedTDFs.addAll(FieldOrientedPluginProfileUtil.extractReservedTreeDefinedFieldFromVariable(VarListUtil.getVariableForKey(profileState, LBL_FIELD2), this.myClassRepository, true));
        usedTDFs.addAll(FieldOrientedPluginProfileUtil.extractReservedTreeDefinedFieldFromVariable(VarListUtil.getVariableForKey(profileState, LBL_INDEX_FOR_FIELD2), this.myClassRepository, true));
        usedTDFs.addAll(FieldOrientedPluginProfileUtil.extractReservedTreeDefinedFieldFromVariable(VarListUtil.getVariableForKey(profileState, LBL_VALUE), this.myClassRepository, false));
        return usedTDFs.toArray(new String[usedTDFs.size()]);
    }

    private AvailableFieldListBuilder createBuilderForSecondField(String firstField, String operationName) {
        AvailableFieldListBuilder builder = AvailableFieldListBuilder.createAvailableFieldListBuilder(this.myClassRepository);
        ConstraintContext context = new ConstraintContext.Builder().addContext(ConstraintContextItemType.FIELD, firstField).addContext(ConstraintContextItemType.OPERATION, operationName).build();
        builder.withConstraints(this, context);
        builder.withFilter(this.createFieldFilterForFeatureContraining(firstField));
        builder.withFilter(new SecondFieldFilter(firstField, this.myClassRepository));
        builder.withFilter(new ClassRepositoryHelper.VisibleFieldFilter(this.myClassRepository));
        builder.withFilter(new ContextFieldFilter(firstField));
        return builder;
    }

    private class ContextFieldFilter
    implements FieldFilter {
        private FieldDefinition myFirstField;

        public ContextFieldFilter(String firstField) {
            this.myFirstField = CompareFieldProfile.this.myClassRepository.getFieldDefinitionByName(firstField);
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            return !field.isContextField() || !this.myFirstField.isContextField() || !Collections.disjoint(field.getContextNames(), this.myFirstField.getContextNames());
        }
    }

    private static class SecondFieldFilter
    implements FieldFilter {
        private final FieldDefinition myFirstField;

        private SecondFieldFilter(String firstFieldName, ClassRepository repository) {
            this.myFirstField = repository.getFieldDefinitionByName(firstFieldName);
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            return field.isFieldOriented() && !field.isSet() && this.fieldsAreCompatible(this.myFirstField, field);
        }

        private boolean fieldsAreCompatible(FieldDefinition field1, FieldDefinition field2) {
            return field1 == null || FieldDefinitionUtil.areFieldsUsingSameValueClassAndDataType(field1, field2) || this.fieldsAreComparableDueToDateTimeInterop(field1, field2);
        }

        private boolean fieldsAreComparableDueToDateTimeInterop(FieldDefinition field1, FieldDefinition field2) {
            DataType type1 = field1.getTypedDataType();
            DataType type2 = field2.getTypedDataType();
            return !(type1 != DataType.TIME && type1 != DataType.DATE || type2 != DataType.TIME && type2 != DataType.DATE);
        }
    }

    private static class FirstFieldFilter
    implements FieldFilter {
        private FirstFieldFilter() {
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            return field.isFieldOriented() && !field.isSet();
        }
    }

    private class FeatureFieldFilter
    implements FieldFilter {
        private FeatureFieldFilter() {
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            return CompareFieldProfile.this.mySupportArrayMap ? true : !field.isComplexType();
        }
    }
}

