/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.logic;

import com.ericsson.ere.annotations.ConfigurationClass;
import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.exception.PluginCreationException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.ImmutableCondition;
import com.ericsson.ere.selectiontree.conditions.logic.CompareFieldConfiguration;
import com.ericsson.ere.selectiontree.conditions.logic.util.AbstractField;
import com.ericsson.ere.selectiontree.conditions.logic.util.AbstractNumericField;
import com.ericsson.ere.selectiontree.conditions.logic.util.AmountField;
import com.ericsson.ere.selectiontree.conditions.logic.util.BCDStringField;
import com.ericsson.ere.selectiontree.conditions.logic.util.BooleanField;
import com.ericsson.ere.selectiontree.conditions.logic.util.DateField;
import com.ericsson.ere.selectiontree.conditions.logic.util.Field;
import com.ericsson.ere.selectiontree.conditions.logic.util.FieldFactory;
import com.ericsson.ere.selectiontree.conditions.logic.util.MonetaryUnitsField;
import com.ericsson.ere.selectiontree.conditions.logic.util.ObjectField;
import com.ericsson.ere.selectiontree.conditions.logic.util.OctetStringField;
import com.ericsson.ere.selectiontree.conditions.logic.util.StringField;
import com.ericsson.ere.selectiontree.conditions.logic.util.TimeField;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

@Immutable
@ConfigurationClass(value=CompareFieldConfiguration.class)
public class CompareField
extends ImmutableCondition
implements TraceableV2 {
    private static final String[] DEFAULT_OPERATORS = new String[]{"="};
    final int myOperator;
    final DataType myFieldDataType;
    final boolean myFieldsAreCompatible;
    final Field myField1;
    final Field myField2;

    CompareField(ParseContext ctx) {
        super(ctx);
        ClassRepository classRepository = ctx.getClassRepository();
        CompareFieldConfiguration conf = new CompareFieldConfiguration(ctx);
        String field1 = conf.getFirstOperandField();
        FieldDefinition fieldDef1 = classRepository.getFieldDefinitionByName(field1);
        FieldIndexKeyContainer keyContainer = null;
        if (fieldDef1 == null) {
            throw new PluginCreationException("Referenced field " + field1 + " does not exist.");
        }
        this.myFieldDataType = fieldDef1.getTypedDataType();
        keyContainer = FieldOrientedPluginUtil.extractIndexKeyObjectFromIndexElement(conf.getFirstOperandIndex(), classRepository, fieldDef1);
        this.myField1 = FieldFactory.initField(this.myFieldDataType, field1, fieldDef1.usesTagNumber(), fieldDef1.getTagNumber(), keyContainer);
        this.myOperator = this.myField1.getOperatorInt(conf.getOperator());
        String field2 = conf.getSecondOperandField();
        String fieldValue = conf.getFieldValue();
        if (field2 != null) {
            FieldDefinition fieldDef2 = classRepository.getFieldDefinitionByName(field2);
            if (fieldDef2 == null) {
                throw new PluginCreationException("Referenced field " + field2 + " does not exist.");
            }
            FieldIndexKeyContainer key2Container = null;
            key2Container = FieldOrientedPluginUtil.extractIndexKeyObjectFromIndexElement(conf.getSecondOperandIndex(), classRepository, fieldDef2);
            this.myField2 = FieldFactory.initField(this.myFieldDataType, field2, fieldDef2.usesTagNumber(), fieldDef2.getTagNumber(), key2Container);
            this.myFieldsAreCompatible = this.myFieldDataType == fieldDef2.getTypedDataType() || this.isDateOrTime(this.myFieldDataType) && this.isDateOrTime(fieldDef2.getTypedDataType());
        } else if (fieldValue != null) {
            this.myField2 = FieldFactory.createFieldFor(fieldDef1, fieldValue, classRepository, keyContainer);
            this.myFieldsAreCompatible = true;
        } else {
            this.myField2 = null;
            this.myFieldsAreCompatible = false;
        }
        FieldOrientedPluginUtil.checkMissingFields(this, classRepository);
    }

    private boolean isDateOrTime(DataType aType) {
        return aType == DataType.TIME || aType == DataType.DATE;
    }

    public static CompareField create(ParseContext ctx, TariffStructureNode[] notused) {
        return new CompareField(ctx);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myField1 == null ? 0 : this.myField1.hashCode());
        result = 31 * result + (this.myField2 == null ? 0 : this.myField2.hashCode());
        result = 31 * result + (this.myFieldDataType == null ? 0 : this.myFieldDataType.hashCode());
        result = 31 * result + (this.myFieldsAreCompatible ? 1231 : 1237);
        result = 31 * result + this.myOperator;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompareField other = (CompareField)obj;
        if (this.myField1 == null ? other.myField1 != null : !this.myField1.equals(other.myField1)) {
            return false;
        }
        if (this.myField2 == null ? other.myField2 != null : !this.myField2.equals(other.myField2)) {
            return false;
        }
        if (this.myFieldDataType == null ? other.myFieldDataType != null : !this.myFieldDataType.equals(other.myFieldDataType)) {
            return false;
        }
        if (this.myFieldsAreCompatible != other.myFieldsAreCompatible) {
            return false;
        }
        return this.myOperator == other.myOperator;
    }

    @Override
    public boolean test(DataSet theData) {
        if (!this.myFieldsAreCompatible) {
            return false;
        }
        try {
            return this.myField1.compare(this.myOperator, this.myField2, theData);
        }
        catch (DataSetValueNotFoundException e) {
            return false;
        }
    }

    @Override
    public String describeTrace(TracePoint tp) {
        StringBuilder strBuilder = new StringBuilder("CompareField : ");
        if (!this.myFieldsAreCompatible) {
            strBuilder.append(this.myField1.getFieldName()).append(" is NOT of same data type as ").append(this.myField2.getFieldName());
        } else {
            strBuilder.append(this.myField1.describeTrace(this.myOperator, this.myField2, TraceDataSet.createPreDataSet(tp))).toString();
        }
        return strBuilder.toString();
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        if (this.myField1 != null) {
            this.myField1.setPreTracePointInfo(tp);
        }
        if (this.myField2 != null) {
            this.myField2.setPreTracePointInfo(tp);
        }
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    protected static String[] getOperatorArrayForDataForField(String fieldName, ClassRepository repository) {
        FieldDefinition field = repository.getFieldDefinitionByName(fieldName);
        return CompareField.getOperatorArrayForDataForField(field);
    }

    private static String[] getOperatorArrayForDataForField(FieldDefinition field) {
        DataType dataType = field.getTypedDataType();
        if (dataType.isNumeric()) {
            return AbstractNumericField.getOperatorArray();
        }
        switch (dataType) {
            case BOOLEAN: {
                return BooleanField.getOperatorArray();
            }
            case STRING: {
                return StringField.getOperatorArray();
            }
            case DATE: {
                return DateField.getOperatorArray();
            }
            case TIME: {
                return TimeField.getOperatorArray();
            }
            case MONETARYUNITS: {
                return MonetaryUnitsField.getOperatorArray();
            }
            case BCDSTRING: {
                return BCDStringField.getOperatorArray();
            }
            case OCTETSTRING: {
                return OctetStringField.getOperatorArray();
            }
            case AMOUNT: {
                return AmountField.getOperatorArray();
            }
            case OBJECT: {
                return ObjectField.getOperatorArray(field);
            }
        }
        return DEFAULT_OPERATORS;
    }

    protected static String[] getAllOperatorsArray(ClassRepository repository) {
        HashSet<String> operatorSet = new HashSet<String>();
        for (FieldDefinition field : repository.getFieldDefinitions()) {
            operatorSet.addAll(Arrays.asList(CompareField.getOperatorArrayForDataForField(field)));
        }
        return operatorSet.toArray(new String[operatorSet.size()]);
    }

    @Deprecated
    public static String getXMLOperator(String operator) {
        return XMLUtil.escape(operator);
    }

    @Override
    public Set<String> getUsedFields() {
        HashSet<String> set = new HashSet<String>();
        set.add(this.myField1.getFieldName());
        FieldIndexKeyContainer key1 = this.myField1.getFieldKeyContainer();
        if (key1 != null) {
            set.addAll(key1.getUsedFields());
        }
        if (!((AbstractField)this.myField2).haveValueSet()) {
            set.add(this.myField2.getFieldName());
            FieldIndexKeyContainer key2 = this.myField2.getFieldKeyContainer();
            if (key2 != null) {
                set.addAll(key2.getUsedFields());
            }
        }
        return set;
    }
}

