/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.datelist;

import com.ericsson.ere.datatype.ERETime;
import com.ericsson.ere.datatype.ERETimeFactory;
import com.ericsson.ere.datatype.ERETimeUtil;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.RequiresNonMapField;
import com.ericsson.ere.gui.simulator.testgenerator.GenerationDataModel;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationConditionExtendedInterface;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.datelist.DateList;
import com.ericsson.ere.selectiontree.conditions.datelist.SpecialDate;
import com.ericsson.ere.selectiontree.interfaces.FieldMappable;
import ericsson.ere.condition.AbstractConditionProfileV2;
import ericsson.ere.datatype.Time;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.documents.DateListDocument;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.MultilineStringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@RequiresNonMapField
public class DateListProfile
extends AbstractConditionProfileV2
implements FieldMappable,
TestCaseGenerationConditionExtendedInterface {
    private static final String BUILT_IN_FIELD_START_TIME = "Start time";
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final char[] ALLOWED_CHARS = new char[]{'-', '*'};
    public static final String LBL_DATELIST = "Dates";
    private ClassRepository myRepository;
    private FieldDefinition myFieldDefinition = null;

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>(2);
        DateListDocument doc = new DateListDocument(ALLOWED_CHARS);
        l.add(new MultilineStringVariable(LBL_DATELIST, "", doc));
        return l;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        ArrayList<Variable> l = new ArrayList<Variable>(2);
        String dateList = "";
        NodeList children = iterator.getChildNodes();
        Element dateNode = XMLUtil.getNamedElement("Date", children);
        dateList = XMLUtil.getFirstTextContent(dateNode);
        DateListDocument doc = new DateListDocument(ALLOWED_CHARS);
        l.add(new MultilineStringVariable(LBL_DATELIST, dateList, doc));
        return l;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String dateList = VarListUtil.getValueStringForName(variables, LBL_DATELIST);
        for (int i = 0; i < indentLevel + 1; ++i) {
            out.print(indentMarker);
        }
        out.println("<Date>" + dateList + "</" + "Date" + ">");
    }

    @Override
    public String getDescription(List<Variable> variables) {
        return VarListUtil.getValueStringForName(variables, "Name") + " = ...";
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String date = VarListUtil.getValueStringForName(variables, LBL_DATELIST);
        name = "<b>" + name + "</b>\n";
        name = name + "Dates = " + date.trim() + "<p>";
        name = name + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(name);
    }

    @Override
    public List<Variable> getTestVariables(Node variableValueIterator, Node testSettingsIterator) {
        Element settingElement = XMLUtil.getFirstElementNamed("Settings", (Element)testSettingsIterator);
        String defaultString = "Single values and boundaries";
        if (settingElement != null) {
            defaultString = XMLUtil.getFirstTextContent(settingElement);
        }
        DropDownVariable testSettingsDD = new DropDownVariable("Cases", (Object)defaultString, (Object[])new String[]{"Single case", "Single values and boundaries", "All cases"});
        ArrayList<Variable> l = new ArrayList<Variable>(2);
        l.add(testSettingsDD);
        return l;
    }

    @Override
    public void printTestVariables(PrintWriter out, List<Variable> vars) {
        out.print("<TestSettings>");
        out.print("<Settings>" + vars.get(0).getValueString() + "</Settings>");
        out.print("</TestSettings>");
    }

    @Override
    public Map<String, Object> getTestSimulationFieldValues(Node variableValueIterator, Node testSettingsIterator) throws Exception {
        Element dateElement = XMLUtil.getFirstElementNamed("Date", (Element)variableValueIterator);
        Element settingsElement = XMLUtil.getFirstElementNamed("Settings", (Element)testSettingsIterator);
        ArrayList<String> valueList = new ArrayList<String>();
        if (settingsElement != null && dateElement != null) {
            String settingsString = XMLUtil.getFirstTextContent(settingsElement);
            String dateString = XMLUtil.getFirstTextContent(dateElement);
            StringTokenizer tokenizer = new StringTokenizer(dateString, " ,\t\n\r");
            if (settingsString.equals("Single case")) {
                while (tokenizer.hasMoreTokens()) {
                    ArrayList<String> tempList;
                    String token = tokenizer.nextToken();
                    if (token.length() <= 0 || (tempList = this.getIncludedDates(token, true)).size() <= 0) continue;
                    valueList.add(tempList.get(0));
                    break;
                }
            } else if (settingsString.equals("Single values and boundaries")) {
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (token.length() <= 0) continue;
                    valueList.addAll(this.getIncludedDates(token, true));
                }
            } else {
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (token.length() <= 0) continue;
                    valueList.addAll(this.getIncludedDates(token, false));
                }
            }
        }
        if (valueList.size() == 0) {
            throw new Exception("Condition settings does not allow test case generation.");
        }
        HashMap<String, Object> fieldInformation = new HashMap<String, Object>();
        fieldInformation.put(this.getAffectedFieldName(), valueList.toArray(new String[0]));
        return fieldInformation;
    }

    @Override
    public void setTestFieldDefinition(FieldDefinition fieldDefinition) {
        this.myFieldDefinition = fieldDefinition;
    }

    private String createValidDate(String aDate) {
        String validDate = aDate.substring(0, 4) + "-" + aDate.substring(4, 6) + "-" + aDate.substring(6, 8) + " 00:00:00";
        return validDate;
    }

    private ArrayList<String> getIncludedDates(String date, boolean boundariesOnly) {
        ArrayList<String> testList = new ArrayList<String>();
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
        if (date.contains("-")) {
            StringTokenizer tokenizer = new StringTokenizer(date, "-");
            String fromDate = tokenizer.nextToken();
            String toDate = tokenizer.nextToken();
            GregorianCalendar toCal = new GregorianCalendar(Integer.parseInt(toDate.substring(0, 4)), Integer.parseInt(toDate.substring(4, 6)) - 1, Integer.parseInt(toDate.substring(6, 8)));
            GregorianCalendar fromCal = new GregorianCalendar(Integer.parseInt(fromDate.substring(0, 4)), Integer.parseInt(fromDate.substring(4, 6)) - 1, Integer.parseInt(fromDate.substring(6, 8)));
            if (boundariesOnly) {
                testList.add(formatter.format(fromCal.getTime()));
                testList.add(formatter.format(toCal.getTime()));
            } else {
                while (fromCal.before(toCal)) {
                    testList.add(formatter.format(fromCal.getTime()));
                    ((Calendar)fromCal).add(5, 1);
                }
                if (!testList.isEmpty()) {
                    testList.add(formatter.format(toCal.getTime()));
                }
            }
        } else if (date.contains("*")) {
            testList.add(this.createValidDate(this.getDateMatchingWildcards(date)));
        } else {
            testList.add(this.createValidDate(date));
        }
        return testList;
    }

    private String getDateMatchingWildcards(String aDate) {
        String value = "";
        int startIndex = 0;
        GregorianCalendar cal = new GregorianCalendar();
        if (aDate.substring(0, 1).equals("*")) {
            value = value + new SimpleDateFormat("yyyy").format(cal.getTime());
            startIndex = 1;
        } else {
            value = value + aDate.substring(0, 4);
            startIndex = 4;
        }
        if (aDate.substring(startIndex, startIndex + 1).equals("*")) {
            value = value + new SimpleDateFormat("MM").format(cal.getTime());
            ++startIndex;
        } else {
            value = value + aDate.substring(startIndex, startIndex + 2);
            startIndex += 2;
        }
        value = aDate.substring(startIndex, startIndex + 1).equals("*") ? value + new SimpleDateFormat("dd").format(cal.getTime()) : value + aDate.substring(startIndex, startIndex + 2);
        return value;
    }

    @Override
    public void combineFieldValues(GenerationDataModel model, Object theValue, int row, int fieldIndex) {
        ERETime currentVal;
        Object o = model.getValueAt(row, fieldIndex);
        if (this.myFieldDefinition != null) {
            currentVal = ERETimeFactory.parseTimeString(o.toString());
        } else {
            currentVal = model.getValueAt(row, fieldIndex) instanceof ERETime ? (ERETime)o : (model.getValueAt(row, fieldIndex) instanceof Time ? ERETimeUtil.convertToERETime(o) : ERETimeFactory.parseTimeString(o.toString()));
            ERETime thisTime = ERETimeFactory.parseTimeString((String)theValue);
            currentVal = ERETimeFactory.createFrom(thisTime.getFullYear(), thisTime.getMonthOfYear(), thisTime.getDayOfMonth(), currentVal.getHours(), currentVal.getMinutes(), currentVal.getSeconds(), 0);
        }
        model.setValueAt(currentVal, row, fieldIndex);
    }

    @Override
    public boolean testParameterChanged(String reference, Variable value, List<Variable> vars) {
        return false;
    }

    @Override
    public void setClassRepository(ClassRepository repository) {
        this.myRepository = repository;
    }

    @Override
    public boolean needsRepository() {
        return true;
    }

    @Override
    public Map<String, Object> getFaultyTestSimulationFieldValues(Node variableValueIterator, Node testSettingsIterator) throws Exception {
        Element dateElement = XMLUtil.getFirstElementNamed("Date", (Element)variableValueIterator);
        GregorianCalendar cal = new GregorianCalendar(1971, 0, 1, 0, 0, 0);
        String value = null;
        final Node variableNode = variableValueIterator;
        if (dateElement != null) {
            DateList dateList = (DateList)DateList.create(new ParseContext(){

                @Override
                public ClassRepository getClassRepository() {
                    return DateListProfile.this.myRepository;
                }

                @Override
                public String getRatingPlanName() {
                    return null;
                }

                @Override
                public Node getXMLNode() {
                    return variableNode;
                }
            }, null);
            for (int i = 0; i < 367; ++i) {
                if (!dateList.dateIsSpecial(new SpecialDate(cal.get(1), cal.get(2) + 1, cal.get(5)))) {
                    value = new SimpleDateFormat(DATE_FORMAT).format(cal.getTime());
                    break;
                }
                ((Calendar)cal).add(5, 1);
            }
        }
        if (value == null) {
            throw new Exception("Condition settings does not allow test case generation.");
        }
        HashMap<String, Object> fieldInformation = new HashMap<String, Object>();
        fieldInformation.put(this.getAffectedFieldName(), value);
        return fieldInformation;
    }

    private String getAffectedFieldName() {
        return this.myFieldDefinition == null ? BUILT_IN_FIELD_START_TIME : this.myFieldDefinition.getFieldName();
    }
}

