/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.date;

import com.ericsson.ere.datatype.ERETime;
import com.ericsson.ere.datatype.ERETimeFactory;
import com.ericsson.ere.datatype.ERETimeUtil;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.RequiresNonMapField;
import com.ericsson.ere.gui.simulator.testgenerator.GenerationDataModel;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationConditionExtendedInterface;
import com.ericsson.ere.selectiontree.conditions.date.DayOfWeek;
import com.ericsson.ere.selectiontree.interfaces.FieldMappable;
import com.ericsson.ere.selectiontree.util.TreeParseUtil;
import ericsson.ere.condition.AbstractConditionProfileV2;
import ericsson.ere.datatype.Time;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@RequiresNonMapField
public class DayOfWeekProfile
extends AbstractConditionProfileV2
implements FieldMappable,
TestCaseGenerationConditionExtendedInterface {
    private static final SimpleDateFormat DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String START_TIME = "Start time";
    public static final String[] DAYS_OF_WEEK = new String[]{"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"};
    private static String LBL_FROM = "From";
    private static String LBL_TO = "To";

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>();
        l.add(new DropDownVariable(LBL_FROM, DAYS_OF_WEEK, DayOfWeek.myPrintableDays, (Object)DayOfWeek.myPrintableDays[0]));
        l.add(new DropDownVariable(LBL_TO, DAYS_OF_WEEK, DayOfWeek.myPrintableDays, (Object)DayOfWeek.myPrintableDays[0]));
        return l;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        NodeList children = iterator.getChildNodes();
        Element fromDayNode = XMLUtil.getNamedElement("From", children);
        String fromStr = XMLUtil.getFirstTextContent(fromDayNode);
        String from = this.convertToWeekDay(fromStr);
        Element toDayNode = XMLUtil.getNamedElement("To", children);
        String toStr = XMLUtil.getFirstTextContent(toDayNode);
        String to = this.convertToWeekDay(toStr);
        ArrayList<Variable> l = new ArrayList<Variable>();
        l.add(new DropDownVariable(LBL_FROM, DAYS_OF_WEEK, DayOfWeek.myPrintableDays, (Object)from));
        l.add(new DropDownVariable(LBL_TO, DAYS_OF_WEEK, DayOfWeek.myPrintableDays, (Object)to));
        return l;
    }

    private String convertToFullName(String threeLetterDay) {
        if (threeLetterDay == null) {
            return null;
        }
        String upperCased = threeLetterDay.toUpperCase();
        int index = DayOfWeekProfile.getIndexOfString(DayOfWeek.myPrintableDays, upperCased);
        if (index > -1) {
            return DAYS_OF_WEEK[index];
        }
        return null;
    }

    private String convertToWeekDay(String day) {
        int toValue = 0;
        String dayToReturn = "";
        boolean found = false;
        for (int i = 0; i < DayOfWeek.myPrintableDays.length; ++i) {
            if (!day.equals(DayOfWeek.myPrintableDays[i])) continue;
            dayToReturn = day;
            found = true;
        }
        if (!found) {
            try {
                toValue = TreeParseUtil.parseInt(day.trim());
            }
            catch (NumberFormatException nfe) {
                System.out.println("NumberFormatException: " + nfe.getMessage());
            }
            switch (toValue) {
                case 0: {
                    dayToReturn = DayOfWeek.myPrintableDays[0];
                    break;
                }
                case 1: {
                    dayToReturn = DayOfWeek.myPrintableDays[1];
                    break;
                }
                case 2: {
                    dayToReturn = DayOfWeek.myPrintableDays[2];
                    break;
                }
                case 3: {
                    dayToReturn = DayOfWeek.myPrintableDays[3];
                    break;
                }
                case 4: {
                    dayToReturn = DayOfWeek.myPrintableDays[4];
                    break;
                }
                case 5: {
                    dayToReturn = DayOfWeek.myPrintableDays[5];
                    break;
                }
                case 6: {
                    dayToReturn = DayOfWeek.myPrintableDays[6];
                }
            }
        }
        return dayToReturn;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String fromIndex = VarListUtil.getValueStringForName(variables, LBL_FROM);
        String toIndex = VarListUtil.getValueStringForName(variables, LBL_TO);
        out.println("<From>" + fromIndex + "</" + "From" + ">");
        out.println("<To>" + toIndex + "</" + "To" + ">");
    }

    private static int getIndexOfString(String[] array, String key) {
        for (int ii = 0; ii < array.length; ++ii) {
            if (!key.equals(array[ii])) continue;
            return ii;
        }
        return -1;
    }

    @Override
    public String getDescription(List<Variable> variables) {
        String toDay;
        int toIndx;
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String fromDay = VarListUtil.getValueStringForName(variables, LBL_FROM);
        int fromIndx = DayOfWeekProfile.getIndexOfString(DayOfWeek.myPrintableDays, fromDay);
        if (fromIndx >= 0) {
            fromDay = DAYS_OF_WEEK[fromIndx];
        }
        if ((toIndx = DayOfWeekProfile.getIndexOfString(DayOfWeek.myPrintableDays, toDay = VarListUtil.getValueStringForName(variables, LBL_TO))) >= 0) {
            toDay = DAYS_OF_WEEK[toIndx];
        }
        if (fromIndx == toIndx) {
            return name + " = " + fromDay;
        }
        return name + " = " + fromDay + " - " + toDay;
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String toDay;
        int toIndx;
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String fromDay = VarListUtil.getValueStringForName(variables, LBL_FROM);
        int fromIndx = DayOfWeekProfile.getIndexOfString(DayOfWeek.myPrintableDays, fromDay);
        if (fromIndx >= 0) {
            fromDay = DAYS_OF_WEEK[fromIndx];
        }
        if ((toIndx = DayOfWeekProfile.getIndexOfString(DayOfWeek.myPrintableDays, toDay = VarListUtil.getValueStringForName(variables, LBL_TO))) >= 0) {
            toDay = DAYS_OF_WEEK[toIndx];
        }
        String days = "";
        days = fromIndx == toIndx ? fromDay : fromDay + "-" + toDay;
        String info = "<b>" + name + "</b>";
        info = info + " (" + days + ")";
        info = info + "\n" + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(info);
    }

    @Override
    public List<Variable> getTestVariables(Node variableValueIterator, Node testSettingsIterator) {
        Element settingElement = XMLUtil.getFirstElementNamed("Settings", (Element)testSettingsIterator);
        String defaultString = "First and last";
        if (settingElement != null) {
            defaultString = XMLUtil.getFirstTextContent(settingElement);
        }
        DropDownVariable testSettingsDD = new DropDownVariable("Cases", (Object)defaultString, (Object[])new String[]{"Single case", "First and last", "All cases"});
        ArrayList<Variable> l = new ArrayList<Variable>(2);
        l.add(testSettingsDD);
        return l;
    }

    @Override
    public void printTestVariables(PrintWriter out, List<Variable> vars) {
        out.print("<TestSettings>");
        out.print("<Settings>" + vars.get(0).getValueString() + "</Settings>");
        out.print("</TestSettings>");
    }

    @Override
    public Map<String, Object> getTestSimulationFieldValues(Node config, Node testConfig) throws Exception {
        ArrayList<String> testList;
        block4: {
            int todaysDayInt;
            Calendar cal;
            int stopDayInt;
            int startDayInt;
            block6: {
                block7: {
                    String settings;
                    block5: {
                        Element fromElement = XMLUtil.getFirstElementNamed("From", (Element)config);
                        Element toElement = XMLUtil.getFirstElementNamed("To", (Element)config);
                        Element settingsElement = XMLUtil.getFirstElementNamed("Settings", (Element)testConfig);
                        testList = new ArrayList<String>();
                        if (toElement == null || fromElement == null || settingsElement == null) break block4;
                        settings = XMLUtil.getFirstTextContent(settingsElement);
                        String fromString = XMLUtil.getFirstTextContent(fromElement);
                        String toString = XMLUtil.getFirstTextContent(toElement);
                        startDayInt = this.getCalendarDayIndex(fromString);
                        stopDayInt = this.getCalendarDayIndex(toString);
                        cal = GregorianCalendar.getInstance();
                        todaysDayInt = cal.get(7);
                        if (!settings.equals("Single case")) break block5;
                        if (startDayInt > 0) {
                            cal.add(5, startDayInt - todaysDayInt);
                            testList.add(DATE_TIME_FORMAT.format(cal.getTime()));
                        }
                        break block4;
                    }
                    if (!settings.equals("First and last")) break block6;
                    if (startDayInt <= 0 || stopDayInt <= 0) break block4;
                    cal.add(5, startDayInt - todaysDayInt);
                    testList.add(DATE_TIME_FORMAT.format(cal.getTime()));
                    if (startDayInt >= stopDayInt) break block7;
                    cal.add(5, stopDayInt - startDayInt);
                    testList.add(DATE_TIME_FORMAT.format(cal.getTime()));
                    break block4;
                }
                if (startDayInt <= stopDayInt) break block4;
                cal.add(5, stopDayInt + 7 - startDayInt);
                testList.add(DATE_TIME_FORMAT.format(cal.getTime()));
                break block4;
            }
            if (startDayInt > 0 && stopDayInt > 0) {
                cal.add(5, startDayInt - todaysDayInt);
                testList.add(DATE_TIME_FORMAT.format(cal.getTime()));
                int numOfValues = startDayInt <= stopDayInt ? stopDayInt - startDayInt : stopDayInt + 7 - startDayInt;
                for (int i = 0; i < numOfValues; ++i) {
                    cal.add(5, 1);
                    testList.add(DATE_TIME_FORMAT.format(cal.getTime()));
                }
            }
        }
        if (testList.size() == 0) {
            throw new Exception("Condition settings does not allow test case generation.");
        }
        return Collections.singletonMap(START_TIME, testList.toArray());
    }

    @Override
    public void setTestFieldDefinition(FieldDefinition fieldDefinition) {
    }

    private int getCalendarDayIndex(String day) {
        if (day.equals("MON")) {
            return 2;
        }
        if (day.equals("TUE")) {
            return 3;
        }
        if (day.equals("WED")) {
            return 4;
        }
        if (day.equals("THU")) {
            return 5;
        }
        if (day.equals("FRI")) {
            return 6;
        }
        if (day.equals("SAT")) {
            return 7;
        }
        if (day.equals("SUN")) {
            return 1;
        }
        return -1;
    }

    @Override
    public void combineFieldValues(GenerationDataModel model, Object theValue, int row, int fieldIndex) {
        Object o = model.getValueAt(row, fieldIndex);
        ERETime currentVal = o instanceof Time ? ERETimeUtil.convertToERETime(o) : (o instanceof ERETime ? (ERETime)o : ERETimeFactory.parseTimeString(o.toString()));
        ERETime thisTime = ERETimeFactory.parseTimeString((String)theValue);
        ERETime newTime = ERETimeFactory.createFrom(thisTime.getFullYear(), thisTime.getMonthOfYear(), thisTime.getDayOfMonth(), currentVal.getHours(), currentVal.getMinutes(), currentVal.getSeconds(), 0);
        model.setValueAt(newTime, row, fieldIndex);
    }

    @Override
    public boolean testParameterChanged(String reference, Variable value, List<Variable> vars) {
        return false;
    }

    @Override
    public Map<String, Object> getFaultyTestSimulationFieldValues(Node config, Node testConfig) throws Exception {
        Element fromElement = XMLUtil.getFirstElementNamed("From", (Element)config);
        Element toElement = XMLUtil.getFirstElementNamed("To", (Element)config);
        String value = null;
        if (toElement != null && fromElement != null) {
            String fromString = XMLUtil.getFirstTextContent(fromElement);
            String toString = XMLUtil.getFirstTextContent(toElement);
            int startDayInt = this.getCalendarDayIndex(fromString);
            int stopDayInt = this.getCalendarDayIndex(toString);
            Calendar cal = GregorianCalendar.getInstance();
            int todaysDayInt = cal.get(7);
            if ((startDayInt - stopDayInt + 7) % 7 == 1) {
                throw new Exception("Condition settings does not allow test case generation.");
            }
            cal.add(5, startDayInt - todaysDayInt - 1);
            value = DATE_TIME_FORMAT.format(cal.getTime());
        }
        return Collections.singletonMap(START_TIME, value);
    }

    @Override
    public Map<String, Object> getDisplayValues(Node data, Map<String, Object> prev) {
        HashMap<String, Object> displayValuesMap;
        HashMap<String, Object> hashMap = displayValuesMap = prev != null ? prev : new HashMap<String, Object>();
        if (data.hasChildNodes()) {
            NodeList children = data.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                String name;
                Node childNode = children.item(i);
                if (childNode.getNodeType() != 1 || !childNode.hasChildNodes()) continue;
                String label = childNode.getNodeName();
                String value = XMLUtil.getFirstTextContent(childNode);
                if ((label.equalsIgnoreCase(LBL_FROM) || label.equalsIgnoreCase(LBL_TO)) && (name = this.convertToFullName(value)) != null) {
                    value = name;
                }
                displayValuesMap.put(label, value);
            }
        }
        return displayValuesMap;
    }

    @Override
    public Map<String, Object> getDisplayValues(List<Variable> variables, Map<String, Object> prev) {
        HashMap<String, Object> displayValuesMap = prev != null ? prev : new HashMap<String, Object>();
        int len = variables.size();
        for (int i = 0; i < len; ++i) {
            String name;
            Variable v = variables.get(i);
            String label = v.getLabel();
            String value = v.getValueString();
            if ((LBL_FROM.equals(label) || LBL_TO.equals(label)) && (name = this.convertToFullName(v.getValueString())) != null) {
                value = name;
            }
            displayValuesMap.put(label, value);
        }
        return displayValuesMap;
    }
}

