/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.ConstantMap;
import com.ericsson.ere.selectiontree.conditions.ImmutableCondition;
import com.ericsson.ere.selectiontree.conditions.field.FieldSelectionParseContext;
import com.ericsson.ere.selectiontree.conditions.util.EnumParser;
import com.ericsson.ere.selectiontree.interfaces.FieldMappable;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.FieldDefinition;
import java.util.Map;
import java.util.Set;

public abstract class ImmutableFieldMappableCondition
extends ImmutableCondition
implements FieldMappable {
    protected final DataSetField myField;
    protected final FieldIndexKeyContainer myKeyIndex;
    protected final Map<Object, String> myEnumMap;

    protected ImmutableFieldMappableCondition(ParseContext ctx) {
        super(ctx, ImmutableFieldMappableCondition.getKeyFromFieldSelectionParseContext(ctx));
        if (ctx instanceof FieldSelectionParseContext) {
            FieldSelectionParseContext fpc = (FieldSelectionParseContext)ctx;
            this.myKeyIndex = fpc.getKeyIndex();
            Map<Object, String> valueMap = EnumParser.convertEnumMapToValueMap(ctx.getClassRepository(), this.getKey(), fpc.getEnumMap());
            this.myEnumMap = valueMap != null ? ConstantMap.createConstantMap(valueMap) : null;
        } else {
            this.myKeyIndex = null;
            Map<Object, String> valueMap = EnumParser.extractValueEnumMap(ctx.getClassRepository(), this.getKey());
            this.myEnumMap = valueMap != null ? ConstantMap.createConstantMap(valueMap) : null;
        }
        FieldOrientedPluginUtil.checkMissingFields(this, ctx.getClassRepository());
        this.myField = this.createDataSetField(ctx);
    }

    protected DataSetField createDataSetField(ParseContext ctx) {
        return this.createDataSetField(ctx, null);
    }

    protected final DataSetField createDataSetField(ParseContext ctx, DataType dataType) {
        FieldDefinition def;
        FieldDefinition fieldDefinition = def = this.key == null ? null : ctx.getClassRepository().getFieldDefinitionByName(this.key);
        DataSetField field = def == null ? new DataSetField(this.key, this.tag, this.tagIsSet, dataType, this.myKeyIndex != null) : new DataSetField(def, dataType);
        return field;
    }

    private static String getKeyFromFieldSelectionParseContext(ParseContext ctx) {
        String key = null;
        if (ctx instanceof FieldSelectionParseContext) {
            key = ((FieldSelectionParseContext)ctx).getFieldName();
        }
        return key;
    }

    @Deprecated
    protected ImmutableFieldMappableCondition(String pconditionName, String key, int tag, boolean tagIsSet, String nodeId, String alias, FieldIndexKeyContainer keyIndex, Map<Object, String> enumMap) {
        super(pconditionName, key, tag, tagIsSet, nodeId, alias);
        this.myKeyIndex = keyIndex;
        this.myEnumMap = ConstantMap.createConstantMap(enumMap);
        this.myField = new DataSetField(key, tag, tagIsSet, null, this.myKeyIndex != null);
    }

    @Override
    public int hashCodeImpl() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myEnumMap == null ? 0 : this.myEnumMap.hashCode());
        result = 31 * result + (this.myKeyIndex == null ? 0 : this.myKeyIndex.hashCode());
        result = 31 * result + (this.myField == null ? 0 : this.myField.hashCode());
        return result;
    }

    @Override
    public boolean equalsImpl(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass() || !super.equalsImpl(obj)) {
            return false;
        }
        ImmutableFieldMappableCondition other = (ImmutableFieldMappableCondition)obj;
        if (this.myEnumMap == null ? other.myEnumMap != null : !this.myEnumMap.equals(other.myEnumMap)) {
            return false;
        }
        if (this.myKeyIndex == null ? other.myKeyIndex != null : !this.myKeyIndex.equals(other.myKeyIndex)) {
            return false;
        }
        return !(this.myField == null ? other.myField != null : !this.myField.equals(other.myField));
    }

    protected String describeFieldName(DataSet dataSet) {
        return FieldOrientedPluginUtil.formatFieldNameWithKeyInformation(this.key, this.myKeyIndex, dataSet);
    }

    @Override
    public Set<String> getUsedFields() {
        Set<String> set = super.getUsedFields();
        if (this.myKeyIndex != null) {
            set.addAll(this.myKeyIndex.getUsedFields());
        }
        return set;
    }

    protected final Object extractFieldValueFromDataSet(DataSet theData, DataSetField theField) {
        Object fieldValue;
        if (this.myKeyIndex == null) {
            fieldValue = theField.getValueFromDataSet(theData);
        } else {
            Key firstKey = FieldOrientedPluginUtil.extractFirstKeyFromSet(this.myKeyIndex.getKeySet(theData));
            fieldValue = theField.getValueFromDataSet(theData, firstKey);
        }
        return fieldValue;
    }
}

