/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions;

import com.ericsson.ere.gui.util.ExceptionUtil;
import ericsson.ere.condition.AbstractConditionProfileV2;
import ericsson.vareditor.variable.NotAllowedVariable;
import ericsson.vareditor.variable.Variable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;

public class ErrorConditionProfile
extends AbstractConditionProfileV2 {
    private String myName;
    private String myExceptionMessage;
    private String myInitializationFailureMessage;
    private long myLogNumber;

    public ErrorConditionProfile(String conditionName, Exception exception) {
        this.myName = conditionName;
        this.myLogNumber = ExceptionUtil.handleException(exception, "ratingRuleFrame", 1, "Failed to initialize the " + this.myName + " condition.", false);
        this.myExceptionMessage = exception.getMessage();
        this.myInitializationFailureMessage = "Failed to initialize the " + this.myName + " condition.";
    }

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> vars = new ArrayList<Variable>();
        vars.add(new NotAllowedVariable("", this.myInitializationFailureMessage));
        if (this.stringNotNull(this.myExceptionMessage)) {
            vars.add(new NotAllowedVariable("", "Error message: " + this.myExceptionMessage));
        }
        vars.add(new NotAllowedVariable("", "See log entry " + this.myLogNumber + " for more information."));
        return vars;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        return this.getVariables();
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        if (this.stringNotNull(this.myExceptionMessage)) {
            return this.myExceptionMessage;
        }
        return this.myInitializationFailureMessage;
    }

    @Override
    public String getDescription(List<Variable> variables) {
        return this.myName;
    }

    private boolean stringNotNull(String string) {
        return string != null && !string.equalsIgnoreCase("null") && !string.equals("");
    }
}

