/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.selectiontree.TreeExecutionException;
import com.ericsson.ere.selectiontree.conditions.AbstractCondition;
import com.ericsson.ere.selectiontree.conditions.ConditionTestResult;
import com.ericsson.ere.selectiontree.conditions.DefaultConditionTestResult;
import com.ericsson.ere.selectiontree.interfaces.Condition;
import com.ericsson.ere.selectiontree.interfaces.Conditionality;
import com.ericsson.ere.selectiontree.interfaces.MillisecondDurationSupport;
import com.ericsson.ere.selectiontree.interfaces.ResultConditionality;
import com.ericsson.ere.trace.TraceNodeInterface;
import com.ericsson.ere.trace.TracePoint;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.TariffNodeLink;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.interfaces.XMLInitializable;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ConditionLink
extends AbstractCondition
implements TariffNodeLink,
ResultConditionality,
MillisecondDurationSupport {
    private static final long MILLISECONDS_PER_SECOND = 1000L;
    protected String myTargetName = null;
    protected Conditionality myTargetNode = null;

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        super.init(iterator);
        NamedNodeMap attr = iterator.getAttributes();
        this.myTargetName = attr.getNamedItem("target").getNodeValue().trim();
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myTargetName == null ? 0 : this.myTargetName.hashCode());
        result = 31 * result + (this.myTargetNode == null ? 0 : this.myTargetNode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConditionLink other = (ConditionLink)obj;
        if (this.myTargetName == null ? other.myTargetName != null : !this.myTargetName.equals(other.myTargetName)) {
            return false;
        }
        return !(this.myTargetNode == null ? other.myTargetNode != null : !this.myTargetNode.equals(other.myTargetNode));
    }

    @Override
    public void setConditionName(String conditionName1) {
        throw new IllegalArgumentException("ConditionLink");
    }

    @Override
    public void setKey(String key1) {
        throw new IllegalArgumentException("ConditionLink");
    }

    @Override
    public void setDataType(String dataType1) {
        throw new IllegalArgumentException("ConditionLink");
    }

    @Override
    public String getConditionName() {
        throw new IllegalArgumentException("ConditionLink");
    }

    @Override
    public String getKey() {
        throw new IllegalArgumentException("ConditionLink");
    }

    @Override
    public String getDataType() {
        throw new IllegalArgumentException("ConditionLink");
    }

    @Override
    public void add(Condition child) {
        if (this.myTargetNode != null) {
            throw new IllegalArgumentException("Link already contains child");
        }
        this.myTargetNode = child;
        ((DAGNode)((Object)child)).addReferer(this);
    }

    @Override
    public void replace(DAGNode child, DAGNode replacement) {
        if (child != this.myTargetNode) {
            throw new IllegalArgumentException("Child not found: " + child);
        }
        this.myTargetNode = (Conditionality)((Object)replacement);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean test(DataSet theData) {
        return this.myTargetNode.test(theData);
    }

    @Override
    public long getConditionSatisfiedDuration(DataSet theData) {
        return this.myTargetNode.getConditionSatisfiedDuration(theData);
    }

    @Override
    public long getConditionUnsatisfiedDuration(DataSet theData) {
        return this.myTargetNode.getConditionUnsatisfiedDuration(theData);
    }

    @Override
    public boolean needsFieldToBeSet() {
        return false;
    }

    @Override
    public void setFieldName(String fieldName) {
    }

    @Override
    public String getTypename() {
        if (this.myTargetNode == null) {
            throw new IllegalArgumentException("ConditionLink - target not set");
        }
        return this.myTargetNode.getTypename();
    }

    @Override
    public String getNodeId() {
        String id = this.myNodeId;
        if (id == null || "".equals(id.trim())) {
            id = this.getLinkPath();
        }
        id = id.replace('/', '\\');
        return id;
    }

    @Override
    public DAGNode getChildAt(int index) throws IndexOutOfBoundsException {
        if (index == 0) {
            return (DAGNode)((Object)this.myTargetNode);
        }
        throw new IndexOutOfBoundsException("No child at index: " + index);
    }

    @Override
    public int getChildCount() {
        if (this.myTargetNode != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public void insertChildAt(int index, DAGNode node) throws IndexOutOfBoundsException {
        if (index != 0 || this.myTargetNode != null) {
            throw new IndexOutOfBoundsException("No child at index: " + index);
        }
        this.myTargetNode = (Conditionality)((Object)node);
        node.setParent(this);
    }

    @Override
    public void insertLinkAt(int index, DAGNode node) throws IndexOutOfBoundsException {
        if (index != 0 || this.myTargetNode != null) {
            throw new IndexOutOfBoundsException("No child at index: " + index);
        }
        this.myTargetNode = (Conditionality)((Object)node);
        node.addReferer(this);
    }

    @Override
    protected void removeChild(DAGNode node) throws IllegalArgumentException {
        throw new IllegalArgumentException("Node not removed, structure is read-only");
    }

    @Override
    protected void removeLink(DAGNode node) throws IllegalArgumentException {
        throw new IllegalArgumentException("Node not removed, structure is read-only");
    }

    @Override
    public void enter(DataSet theData) {
        this.myTargetNode.enter(theData);
    }

    @Override
    public boolean isReadyToLeave(DataSet theData) {
        return this.myTargetNode.isReadyToLeave(theData);
    }

    @Override
    public void leave(DataSet theData) {
        this.myTargetNode.leave(theData);
    }

    @Override
    public int getNodeType() {
        return 2;
    }

    @Override
    public boolean isLink() {
        return true;
    }

    @Override
    public String getLinkPath() {
        return this.myTargetName;
    }

    @Override
    public void setTarget(TariffStructureNode node) throws IllegalArgumentException, Exception {
        if (node == null) {
            throw new IllegalArgumentException("null target not allowed");
        }
        if (this.getChildCount() > 0) {
            if (node != this.getChildAt(0)) {
                throw new IllegalArgumentException("Link already contains child");
            }
        } else {
            this.insertLinkAt(0, node);
        }
    }

    @Override
    public String describeTrace(TracePoint tp) {
        return null;
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    @Override
    public TariffStructureNode createTraceNode(int childIndex, TraceNodeInterface parent) {
        try {
            ConditionLink clone = (ConditionLink)this.clone();
            clone.myTargetNode = null;
            clone.insertLinkAt(0, this.myTargetNode.createTraceNode(0, parent));
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new TreeExecutionException(e);
        }
    }

    @Override
    public ConditionTestResult testResult(DataSet theData) {
        ConditionTestResult result = null;
        if (this.myTargetNode instanceof ResultConditionality) {
            result = ((ResultConditionality)this.myTargetNode).testResult(theData);
        } else {
            boolean testResult = this.myTargetNode.test(theData);
            result = new DefaultConditionTestResult(testResult);
        }
        return result;
    }

    @Override
    public long getConditionSatisfiedDurationInMilliseconds(DataSet theData) {
        long satisfiedDuration;
        long duration = this.myTargetNode instanceof MillisecondDurationSupport ? ((MillisecondDurationSupport)((Object)this.myTargetNode)).getConditionSatisfiedDurationInMilliseconds(theData) : ((satisfiedDuration = this.getConditionSatisfiedDuration(theData)) == Long.MAX_VALUE ? satisfiedDuration : satisfiedDuration * 1000L);
        return duration;
    }

    @Override
    public long getConditionUnsatisfiedDurationInMilliseconds(DataSet theData) {
        long unsatisfiedDuration;
        long duration = this.myTargetNode instanceof MillisecondDurationSupport ? ((MillisecondDurationSupport)((Object)this.myTargetNode)).getConditionUnsatisfiedDurationInMilliseconds(theData) : ((unsatisfiedDuration = this.getConditionUnsatisfiedDuration(theData)) == Long.MAX_VALUE ? unsatisfiedDuration : unsatisfiedDuration * 1000L);
        return duration;
    }
}

