/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.proxy;

import com.ericsson.ere.dataset.jump.JumpContext;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.ActiveListProxy;
import com.ericsson.ere.proxy.EreProxyManager;
import com.ericsson.ere.proxy.ProgressWrapper;
import com.ericsson.ere.proxy.RatingManagerProxy;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import com.ericsson.ere.proxy.SavedListProxy;
import com.ericsson.ere.proxy.ServiceCache;
import com.ericsson.ere.proxy.ServiceListProxy;
import com.ericsson.ere.proxy.ServiceProviderProxy;
import com.ericsson.ere.proxy.ServiceProxy;
import com.ericsson.ere.proxy.event.ProxyStructureEvent;
import com.ericsson.ere.proxy.exception.BuildFailedException;
import com.ericsson.ere.selectiontree.SelectionTreeNodeFactoryImpl;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.ratingrules.RatingJTreeErrorHandler;
import ericsson.ere.gui.ratingrules.RatingJTreeNodeFactory;
import ericsson.ere.gui.ratingrules.RatingRuleFrame;
import ericsson.ere.gui.ratingrules.RatingRuleFrameJumper;
import ericsson.ere.gui.ratingrules.RatingRuleFrameOpener;
import ericsson.ere.gui.ratingrules.nodes.TSTariffStructure;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.integration.connector.AbstractConnector;
import ericsson.ere.integration.connector.EreCommunicationException;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.ere.interfaces.RatingRuleBuilderErrorHandler;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.management.DateUtil;
import ericsson.ere.management.FieldContext;
import ericsson.ere.management.RatingPeriod;
import ericsson.ere.management.RatingPlan;
import ericsson.ere.management.Service;
import ericsson.ere.management.ServiceProvider;
import ericsson.ere.ratingrules.RatingBuilderErrorHandler;
import ericsson.ere.ratingrules.RatingRuleBuilder;
import ericsson.ere.xml.DomWriter;
import ericsson.ere.xml.ElementIterator;
import ericsson.ere.xml.XMLUtil;
import java.awt.Dimension;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Vector;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RatingPlanProxy
extends AbstractEreProxy {
    private transient Vector<RatingPeriodProxy> ratingPeriodList = new Vector();
    protected transient ServiceProviderProxy parentProxy = null;
    public static final int OK = 0;
    public static final int INVALID_DATE = 1;
    public static final String CHARACTER_INFO = "\nCharacters \\ / : * ? ; \" are not valid.";
    private static char[] invalidCharacters = new char[]{'\\', '/', ':', '*', '\"', '<', '>', '|', ';', '\'', '?'};

    public RatingPlanProxy(AbstractConnector connect, ServiceProviderProxy parentProxy, String ratingPlanName) {
        this.connector = connect;
        this.setName(ratingPlanName);
        this.parentProxy = parentProxy;
        this.myURI = this.buildURI(AbstractEreProxy.URIScheme.PLAN);
        if (this.getAbortRefresh()) {
            return;
        }
        this.refresh();
    }

    @Override
    public void refresh() {
        String savedName = this.getName();
        ProgressWrapper progress = EreProxyManager.getInstance().getProgressWrapper();
        progress.setInfo("Building RatingPlan: " + savedName);
        this.myEreSettings = new SettingsMap();
        String ratingPlanService = "UNDEFINED";
        try {
            Element rpElement = this.connector.getRatingPlanElement(this.parentProxy.getName(), savedName);
            ratingPlanService = rpElement.getAttribute("Service");
            this.setName(savedName);
            this.myEreSettings.setParameter("Service", ratingPlanService, 1, true);
            XPath xpath = XPathFactory.newInstance().newXPath();
            String ratingPeriodPath = "RatingPeriod";
            NodeList ratingPeriodNodes = (NodeList)xpath.evaluate(ratingPeriodPath, rpElement, XPathConstants.NODESET);
            this.ratingPeriodList.clear();
            if (ratingPeriodNodes.getLength() > 0) {
                ElementIterator eIter = new ElementIterator(ratingPeriodNodes);
                ProgressWrapper[] progressArray = EreProxyManager.getInstance().getProgressWrapper().splitProgress(eIter.getElementCount());
                int progressIdCounter = 0;
                for (Element ratingPeriod : eIter) {
                    EreProxyManager.getInstance().setProgressWrapper(progressArray[progressIdCounter]);
                    progressArray[progressIdCounter].progressStart();
                    RatingPeriodProxy newPeriodProxy = this.connector.getProxyFactory().createRatingPeriodProxy(this.connector, this, ratingPeriod.getAttribute("Name"), ratingPeriod.getAttribute("StartDate"));
                    this.ratingPeriodList.add(newPeriodProxy);
                    progressArray[progressIdCounter].progressFinished();
                    ++progressIdCounter;
                }
            }
            progress.progressIncrement();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ServiceProviderProxy getServiceProviderProxy() {
        return this.parentProxy;
    }

    public boolean hasActiveAndSavedPeriods() {
        return false;
    }

    public SavedListProxy getSavedListProxy() {
        return null;
    }

    public ActiveListProxy getActiveListProxy() {
        return null;
    }

    public Vector<RatingPeriodProxy> getRatingPeriodList() {
        return this.ratingPeriodList;
    }

    public String getServiceName() {
        return this.myEreSettings.getParameterAsString("Service");
    }

    public final RatingPlan getRatingPlanObject() {
        return this.getRatingPlanObject(null);
    }

    public RatingPlan getRatingPlanObject(JumpContext jctx) {
        RatingPlan plan = this.constructRatingPlanObject(jctx);
        return this.populateRatingPlanObject(plan, jctx, this.ratingPeriodList);
    }

    protected RatingPlan constructRatingPlanObject(JumpContext jctx) {
        ServiceProvider provider = new ServiceProvider(this.getServiceProviderProxy().getName());
        RatingPlan plan = new RatingPlan(provider, this.getName(), this.getName(), this.getServiceName());
        return plan;
    }

    protected RatingPlan populateRatingPlanObject(RatingPlan plan, JumpContext jctx, List<RatingPeriodProxy> periods) {
        Service service = null;
        ServiceCache serviceCache = null;
        String serviceName = this.getServiceName();
        try {
            RatingRuleFrameJumper jumper = new RatingRuleFrameJumper(this.getRatingManagerProxy(), null);
            if (jctx != null) {
                jumper.setJumpContext(jctx);
                if (jctx instanceof ServiceCache) {
                    serviceCache = (ServiceCache)((Object)jctx);
                    service = serviceCache.getService(serviceName);
                }
            }
            if (service == null) {
                service = this.getRatingManagerProxy().getServiceListProxy().getServiceProxy(serviceName).instantiateServiceObject();
            }
            if (serviceCache != null) {
                serviceCache.setService(service);
            }
            service.setJumperSupport(jumper);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        plan.setService(service);
        for (RatingPeriodProxy ratingPeriodProxy : periods) {
            try {
                plan.addRatingPeriod(this.constructRatingPeriod(plan, ratingPeriodProxy));
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        return plan;
    }

    public RatingPeriod constructRatingPeriod(RatingPlan plan, RatingPeriodProxy proxy) throws Exception {
        RatingPeriod period = new RatingPeriod(plan, proxy.getName(), proxy.getServiceProviderName());
        period.setStartTime(DateUtil.parse(proxy.getRatingPeriodStartTime()));
        Element element = proxy.getRatingPeriodRuleTree();
        element = XMLUtil.getFirstElementNamed("TariffStructure", element);
        period.startStructure(element);
        return period;
    }

    @Override
    public RatingManagerProxy getRatingManagerProxy() {
        return this.parentProxy.getRatingManagerProxy();
    }

    public RatingPeriodProxy createRatingPeriod(SettingsMap settings, Element structureElement) throws EreCommunicationException {
        RatingPeriodProxy.createFileRef(settings);
        this.connector.createRatingPeriod(this, settings, structureElement);
        this.getEreProxy().refreshRatingManagerDocument();
        this.refresh();
        this.getEreProxy().fireProxyStructureEvent(new ProxyStructureEvent(this));
        String name = settings.getParameterAsString("Name");
        String startTime = settings.getParameterAsString("Start date");
        return this.getRatingPeriodProxy(name, startTime);
    }

    public RatingPeriodProxy createRatingPeriod(Element ratingPeriodElement) throws EreCommunicationException, Exception {
        XMLInitializable guiRoot;
        Element structureElement = this.getTariffStructureElement(ratingPeriodElement);
        String ratingPeriodName = ratingPeriodElement.getAttribute("Name");
        String ratingPeriodStartTime = ratingPeriodElement.getAttribute("StartDate");
        String filePath = RatingPlanProxy.fixDirName(this.getServiceProviderProxy().getName()) + "/" + RatingPlanProxy.fixDirName(this.getName() + "/" + RatingPlanProxy.fixDirName(ratingPeriodName));
        SettingsMap settings = new SettingsMap();
        settings.setParameter("Name", ratingPeriodName);
        settings.setParameter("Start date", ratingPeriodStartTime);
        settings.setParameter("Selection Tree file", filePath);
        settings.setParameter("Service", this.getServiceName());
        ServiceProxy serviceProxy = this.getRatingManagerProxy().getServiceListProxy().getServiceProxy(this.getServiceName());
        ClassRepository repository = serviceProxy.instantiateServiceObject().getClassRepository(new FieldContext(this.getServiceProviderProxy().getName(), this.getName()));
        RatingJTreeNodeFactory nodeFactory = new RatingJTreeNodeFactory(serviceProxy.getId(), repository);
        RatingBuilderErrorHandler errorHandler = new RatingJTreeErrorHandler();
        RatingRuleBuilder builder = new RatingRuleBuilder(nodeFactory, (RatingRuleBuilderErrorHandler)errorHandler);
        try {
            guiRoot = builder.build(structureElement);
        }
        catch (Exception ex) {
            throw new BuildFailedException("Could not build configuration tree.", ex);
        }
        assert (guiRoot instanceof TSTariffStructure) : "Invalid structure root type.";
        SelectionTreeNodeFactoryImpl stFactory = new SelectionTreeNodeFactoryImpl(repository);
        errorHandler = new RatingBuilderErrorHandler();
        builder = new RatingRuleBuilder(stFactory, (RatingRuleBuilderErrorHandler)errorHandler);
        try {
            builder.build(structureElement);
        }
        catch (Exception ex) {
            throw new BuildFailedException("Could not build execution tree.", ex);
        }
        this.connector.createRatingPeriod(this, settings, structureElement);
        this.getEreProxy().refreshRatingManagerDocument();
        this.refresh();
        this.getEreProxy().fireProxyStructureEvent(new ProxyStructureEvent(this));
        return this.getRatingPeriodProxy(ratingPeriodName, ratingPeriodStartTime);
    }

    public void deleteRatingPeriod(RatingPeriodProxy toDelete) {
        try {
            this.connector.removeRatingPeriod(toDelete);
            this.getEreProxy().refreshRatingManagerDocument();
            if (this.connector.getRatingPlanElement(this.parentProxy.getName(), this.getName()) == null) {
                this.getServiceProviderProxy().refresh();
                this.getEreProxy().fireProxyStructureEvent(new ProxyStructureEvent(this.getServiceProviderProxy()));
            } else {
                this.refresh();
                this.getEreProxy().fireProxyStructureEvent(new ProxyStructureEvent(this));
            }
        }
        catch (Exception e) {
            String msg = "Could not delete the selected Rating period\nReason:" + e.getMessage();
            DialogFactory.getInformationDialog(GuiServiceCenter.getInstance().getMainWindow(), "Problem deleting Rating period", msg);
        }
    }

    private static String fixDirName(String str) {
        return str.replace(' ', '_');
    }

    @Deprecated
    public String getRatingPlanName() {
        return this.getName();
    }

    public RatingPeriodProxy getRatingPeriodProxy(String ratingPeriodName, String startTime) {
        for (RatingPeriodProxy ratingPeriodProxy : this.ratingPeriodList) {
            if (!(ratingPeriodProxy.isStartTimeUsed() ? ratingPeriodProxy.getName().equalsIgnoreCase(ratingPeriodName) && ratingPeriodProxy.getRatingPeriodStartTime().equals(startTime) : ratingPeriodProxy.getName().equalsIgnoreCase(ratingPeriodName))) continue;
            return ratingPeriodProxy;
        }
        return null;
    }

    @Override
    protected AbstractEreProxy getAbstractParentProxy() {
        return this.parentProxy;
    }

    @Override
    public boolean isImportableUnder(AbstractEreProxy destination) {
        if (destination instanceof RatingPlanProxy) {
            if (this.getServiceName().equalsIgnoreCase(((RatingPlanProxy)destination).getServiceName())) {
                return true;
            }
        } else if (destination instanceof ServiceProviderProxy) {
            ServiceListProxy slp = ((ServiceProviderProxy)destination).getRatingManagerProxy().getServiceListProxy();
            Vector<ServiceProxy> sp = slp.getServiceList();
            for (ServiceProxy s : sp) {
                if (!this.getServiceName().equalsIgnoreCase(s.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public RatingPeriodProxy isValidStartDate(String startDate) {
        if (this.hasActiveAndSavedPeriods()) {
            return null;
        }
        Vector<RatingPeriodProxy> periods = this.getRatingPeriodList();
        if (periods == null || periods.isEmpty()) {
            return null;
        }
        for (RatingPeriodProxy proxy : periods) {
            if (!startDate.equals(proxy.getRatingPeriodStartTime())) continue;
            return proxy;
        }
        return null;
    }

    public RatingPeriodProxy isPeriodNameUnique(String periodName) {
        if (this.hasActiveAndSavedPeriods()) {
            return null;
        }
        Vector<RatingPeriodProxy> periods = this.getRatingPeriodList();
        if (periods == null || periods.isEmpty()) {
            return null;
        }
        for (RatingPeriodProxy proxy : periods) {
            if (!periodName.equalsIgnoreCase(proxy.getName())) continue;
            return proxy;
        }
        return null;
    }

    public int validateDate(String startDate) {
        int result = 0;
        if (!this.hasActiveAndSavedPeriods() && this.isValidStartDate(startDate) != null) {
            ++result;
        }
        return result;
    }

    public static boolean validateName(String name) {
        for (int i = 0; i < invalidCharacters.length; ++i) {
            if (name.indexOf(invalidCharacters[i]) == -1) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RatingPeriodProxy createRatingPeriodViaEditor(Element ratingPeriodElement, String message) throws Exception {
        Service service = this.getRatingManagerProxy().getServiceListProxy().getServiceProxy(this.getServiceName()).instantiateServiceObject();
        File temp = File.createTempFile("rma", "tmp");
        try {
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(temp), Charset.forName("UTF-8"));){
                Element ts = this.getTariffStructureElement(ratingPeriodElement);
                DomWriter.nodeToWriter(ts, writer, false, true);
            }
            long modifiedBefore = temp.lastModified();
            RatingRuleFrame rrf = RatingRuleFrameOpener.openFromFile(service, this, temp, false, null);
            RatingRuleFrameOpener.showInDialog(GuiServiceCenter.getInstance().getMainWindow(), rrf, message, true, new Dimension(600, 500));
            long modifiedAfter = temp.lastModified();
            RatingPeriodProxy proxy = null;
            if (modifiedAfter != modifiedBefore) {
                Element newRatingPeriod = this.buildRatingPeriodElementFromFile(temp, ratingPeriodElement);
                proxy = this.createRatingPeriod(newRatingPeriod);
            } else {
                proxy = this.createRatingPeriod(ratingPeriodElement);
            }
            RatingPeriodProxy ratingPeriodProxy = proxy;
            return ratingPeriodProxy;
        }
        finally {
            temp.delete();
        }
    }

    private Element buildRatingPeriodElementFromFile(File file, Element originalElement) throws Exception {
        Document doc = XMLUtil.buildDocumentFromFile(file);
        Node ratingPeriod = originalElement.cloneNode(false);
        ratingPeriod = doc.adoptNode(ratingPeriod);
        ratingPeriod.appendChild(doc.getDocumentElement());
        return (Element)ratingPeriod;
    }

    private Element getTariffStructureElement(Element xml) {
        Element ts = xml;
        if (!"TariffStructure".equals(xml.getNodeName())) {
            ts = XMLUtil.getFirstElementNamed("TariffStructure", xml);
        }
        return ts;
    }
}

