/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.proxy;

import com.ericsson.ere.gui.navigator.NavigatorTree;
import com.ericsson.ere.proxy.EreProxy;
import com.ericsson.ere.proxy.RatingManagerProxy;
import com.ericsson.ere.proxy.event.ProxyPropertyEvent;
import ericsson.ere.integration.connector.AbstractConnector;
import ericsson.ere.integration.connector.EreCommunicationException;
import ericsson.ere.integration.connector.http.NavigatorMenuBuilder;
import ericsson.ere.integration.connector.http.NavigatorTreeBuilder;
import ericsson.ere.integration.settingsmap.Parameter;
import ericsson.ere.integration.settingsmap.SettingsMap;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public abstract class AbstractEreProxy {
    @Deprecated
    protected transient String proxyName = "UNDEFINED";
    protected SettingsMap myEreSettings = new SettingsMap();
    protected transient AbstractConnector connector = null;
    protected transient boolean abortRefresh = false;
    protected URI myURI;

    public abstract RatingManagerProxy getRatingManagerProxy();

    public Class<?> getEditProxyEditorForClass(Class<?> editorFor) {
        return this.connector.getEditProxyEditorForClass(editorFor);
    }

    public void abortRefresh() {
        this.abortRefresh = true;
    }

    protected void checkAbortRefresh() {
        this.abortRefresh = this.getAbstractParentProxy().getAbortRefresh();
    }

    public boolean getAbortRefresh() {
        this.checkAbortRefresh();
        return this.abortRefresh;
    }

    public void clearAbortRefresh() {
        this.abortRefresh = false;
    }

    public boolean lastRefreshSuccessfull() {
        return !this.abortRefresh;
    }

    public Class<?> getCreateProxyEditorClass(Class<?> editorFor) {
        return this.connector.getCreateProxyEditorForClass(editorFor);
    }

    public Class<?> getSaveAsProxyEditorClass() {
        return this.connector.getSaveAsProxyEditorForClass();
    }

    public SettingsMap getSettingsMap() {
        return this.myEreSettings;
    }

    public abstract void refresh() throws EreCommunicationException;

    public void updateSettingsMap(SettingsMap newPropertiesMap) {
        this.myEreSettings.updateParametersFrom(newPropertiesMap);
        this.getEreProxy().fireProxyPropertyEvent(new ProxyPropertyEvent(this));
    }

    public void setSettingsMap(SettingsMap newPropertyModel) throws Exception {
        this.myEreSettings.clear();
        this.myEreSettings.mergeParametersFrom(newPropertyModel);
        this.getEreProxy().fireProxyPropertyEvent(new ProxyPropertyEvent(this));
    }

    public EreProxy getEreProxy() {
        AbstractEreProxy proxy = this.getAbstractParentProxy();
        EreProxy ereProxy = null;
        if (proxy != null) {
            ereProxy = proxy.getEreProxy();
        }
        return ereProxy;
    }

    protected abstract AbstractEreProxy getAbstractParentProxy();

    public abstract boolean isImportableUnder(AbstractEreProxy var1);

    public String toString() {
        return this.getName();
    }

    public Class<?> getDistributedSaveRatingPeriodTask() {
        return this.connector.getDistributedSaveRatingPeriodTask();
    }

    public String getDefaultWindowTitle() {
        return "";
    }

    public NavigatorMenuBuilder getNavigatorMenuBuilderForNavigatorTree(NavigatorTree tree) {
        return this.connector.getNavigatorMenuBuilderForNavigatorTree(tree);
    }

    public NavigatorTreeBuilder getNavigatorTreeBuilder() {
        return this.connector.getNavigatorTreeBuilder();
    }

    public String getName() {
        String name = null;
        Parameter param = this.myEreSettings.getParameter("Name");
        if (param != null) {
            name = param.getValue();
        }
        return name;
    }

    protected void setName(String aName) {
        if (aName == null) {
            throw new IllegalArgumentException("Name cannot be null.");
        }
        this.myEreSettings.setParameter("Name", aName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myEreSettings == null ? 0 : this.myEreSettings.hashCode());
        result = 31 * result + (this.myURI == null ? 0 : this.myURI.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractEreProxy other = (AbstractEreProxy)obj;
        if (this.myEreSettings == null ? other.myEreSettings != null : !this.myEreSettings.equals(other.myEreSettings)) {
            return false;
        }
        return !(this.myURI == null ? other.myURI != null : !this.myURI.equals(other.myURI));
    }

    protected String getURIPath() {
        String name = this.getName();
        String parentPath = "";
        AbstractEreProxy parent = this.getAbstractParentProxy();
        if (parent != null) {
            parentPath = parent.getURIPath();
            if (name.length() > 0 && !parentPath.endsWith("/")) {
                parentPath = parentPath + "/";
            }
        }
        try {
            name = URLEncoder.encode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 is not supported!");
        }
        return parentPath + name;
    }

    protected URI buildURI(URIScheme scheme) {
        try {
            URI uri = new URI(scheme.getName(), this.getURIPath(), null);
            return uri;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected String getProxyName() {
        String name;
        URI uri = this.myURI;
        if (uri != null) {
            String path = uri.getSchemeSpecificPart();
            int lastIndex = path.lastIndexOf(47);
            if (lastIndex == -1) {
                name = path;
            } else {
                name = path.substring(lastIndex + 1);
                try {
                    name = URLDecoder.decode(name, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new AssertionError((Object)"UTF-8 is not supported!");
                }
            }
        } else {
            name = this.getName();
        }
        return name;
    }

    protected String getProxyScheme() {
        String scheme = null;
        if (this.myURI != null) {
            scheme = this.myURI.getScheme();
        }
        return scheme;
    }

    public String getEREName() {
        String name = null;
        if (this.myURI != null) {
            String path = this.myURI.getSchemeSpecificPart();
            int firstIndex = path.indexOf(47);
            name = firstIndex == -1 ? path : path.substring(0, firstIndex);
            try {
                name = URLDecoder.decode(name, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)"UTF-8 is not supported!");
            }
        } else {
            EreProxy ereProxy = this.getEreProxy();
            if (ereProxy != null) {
                name = ereProxy.getName();
            }
        }
        return name;
    }

    protected URI getURI() {
        return this.myURI;
    }

    public boolean isServiceEditingAllowed() {
        return this.connector.isServiceEditingAllowed();
    }

    protected static enum URIScheme {
        MANAGER("manager"),
        SERVICELIST("servicelist"),
        SERVICE("service"),
        SERVICEPROVIDERLIST("serviceproviderlist"),
        SERVICEPROVIDER("serviceprovider"),
        PLAN("plan"),
        PERIOD("period");

        private final String myName;

        private URIScheme(String aName) {
            this.myName = aName;
        }

        public String getName() {
            return this.myName;
        }
    }
}

