/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.mbean;

import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class ManagementSupport {
    public static ObjectName register(Object obj, String pkg, String type, String name) throws IllegalArgumentException {
        ObjectName objName;
        MBeanServer srv = ManagementFactory.getPlatformMBeanServer();
        try {
            objName = new ObjectName(pkg + ":type=" + type + ",name=" + name);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e);
        }
        boolean done = false;
        while (!done) {
            try {
                srv.registerMBean(obj, objName);
                done = true;
            }
            catch (InstanceAlreadyExistsException e) {
                try {
                    srv.unregisterMBean(objName);
                }
                catch (InstanceNotFoundException e1) {
                    throw new IllegalArgumentException("Trying to remove name " + objName + " because of re-registration.", e1);
                }
                catch (MBeanRegistrationException e1) {
                    throw new IllegalArgumentException(e1);
                }
            }
            catch (MBeanRegistrationException e) {
                throw new IllegalArgumentException(e);
            }
            catch (NotCompliantMBeanException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return objName;
    }

    public static void unregister(ObjectName objName) throws IllegalArgumentException {
        if (objName == null) {
            return;
        }
        MBeanServer srv = ManagementFactory.getPlatformMBeanServer();
        try {
            srv.unregisterMBean(objName);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (MBeanRegistrationException e) {
            throw new IllegalArgumentException("Trying to remove name " + objName + " because of disposal.", e);
        }
    }
}

