/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.math;

import com.ericsson.ere.math.BaseRationalNumber;
import com.ericsson.ere.math.LongRationalNumber;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;

public final class BigRationalNumber
extends BaseRationalNumber {
    private final BigInteger myNumerator;
    private final BigInteger myDenominator;

    private BigRationalNumber(BigInteger numerator, BigInteger denominator, boolean shorten) {
        if (denominator.signum() == 0) {
            throw new ArithmeticException("Division by Zero");
        }
        BigInteger n = numerator;
        BigInteger d = denominator;
        if (n.signum() == 0) {
            n = BigInteger.ZERO;
            d = BigInteger.ONE;
        } else {
            BigInteger gcd;
            if (d.signum() == -1) {
                n = n.negate();
                d = d.negate();
            }
            if (shorten && !(gcd = n.gcd(d)).equals(BigInteger.ONE)) {
                n = n.divide(gcd);
                d = d.divide(gcd);
            }
        }
        this.myNumerator = n;
        this.myDenominator = d;
        this.myBase = 2;
    }

    public BigRationalNumber(BigInteger numerator, BigInteger denominator) {
        this(numerator, denominator, true);
    }

    public BigRationalNumber(LongRationalNumber number) {
        this(BigInteger.valueOf(number.getNumerator()), BigInteger.valueOf(number.getDenominator()), true);
    }

    public BigRationalNumber(long numerator, long denominator) {
        this(BigInteger.valueOf(numerator), BigInteger.valueOf(denominator), true);
    }

    public BigRationalNumber(byte[] data) {
        if (data.length > 5 && data[0] == 2) {
            int nSize = (data[1] & 0xFF) << 8;
            int dSize = (data[3] & 0xFF) << 8;
            if (data.length != 5 + (nSize |= data[2] & 0xFF) + (dSize |= data[4] & 0xFF)) {
                throw new ArithmeticException("Can not create BigRatingDecimal from byte array. Size not correct.");
            }
            byte[] n = new byte[nSize];
            byte[] d = new byte[dSize];
            System.arraycopy(data, 5, n, 0, nSize);
            System.arraycopy(data, 5 + nSize, d, 0, dSize);
            this.myNumerator = new BigInteger(n);
            this.myDenominator = new BigInteger(d);
            if (this.myDenominator.signum() == 0) {
                throw new ArithmeticException("Division by Zero");
            }
        } else {
            throw new ArithmeticException("Can not create BigRatingDecimal from byte array.");
        }
        this.myBase = 2;
    }

    @Override
    public BaseRationalNumber abs() {
        return this.myNumerator.signum() >= 0 ? this : this.negate();
    }

    @Override
    public BaseRationalNumber add(BaseRationalNumber number) {
        BigRationalNumber bigNumber = this.convertToBigIfNeeded(number);
        BigInteger numerator = this.myNumerator.multiply(bigNumber.myDenominator).add(bigNumber.myNumerator.multiply(this.myDenominator));
        BigInteger denominator = this.myDenominator.multiply(bigNumber.myDenominator);
        BigRationalNumber rationalNumber = new BigRationalNumber(numerator, denominator);
        return this.convertToLongIfPossible(rationalNumber);
    }

    @Override
    public BaseRationalNumber add(long number) {
        return this.add(new BigRationalNumber(number, 1L));
    }

    @Override
    public BigDecimal bigDecimalValue(int scale, int roundingMode) {
        BigDecimal numer = new BigDecimal(this.myNumerator);
        BigDecimal denom = new BigDecimal(this.myDenominator);
        return numer.divide(denom, scale, roundingMode);
    }

    @Override
    public BaseRationalNumber divide(BaseRationalNumber number) {
        BigRationalNumber bigNumber = this.convertToBigIfNeeded(number);
        BigInteger numerator = this.myNumerator.multiply(bigNumber.myDenominator);
        BigInteger denominator = this.myDenominator.multiply(bigNumber.myNumerator);
        BigRationalNumber rationalNumber = new BigRationalNumber(numerator, denominator);
        return this.convertToLongIfPossible(rationalNumber);
    }

    @Override
    public BaseRationalNumber divide(long number) {
        return this.divide(new BigRationalNumber(number, 1L));
    }

    @Override
    public BaseRationalNumber multiply(BaseRationalNumber number) {
        BigRationalNumber bigNumber = this.convertToBigIfNeeded(number);
        BigInteger numerator = this.myNumerator.multiply(bigNumber.myNumerator);
        BigInteger denominator = this.myDenominator.multiply(bigNumber.myDenominator);
        BigRationalNumber rationalNumber = new BigRationalNumber(numerator, denominator);
        return this.convertToLongIfPossible(rationalNumber);
    }

    @Override
    public BaseRationalNumber multiply(long number) {
        return this.multiply(new BigRationalNumber(number, 1L));
    }

    @Override
    public BaseRationalNumber negate() {
        return new BigRationalNumber(this.myNumerator.negate(), this.myDenominator, false);
    }

    @Override
    public BaseRationalNumber remainder(BaseRationalNumber number) {
        BigRationalNumber bigNumber = this.convertToBigIfNeeded(number);
        return this.subtract(((BaseRationalNumber)bigNumber).multiply(this.divideToIntegralValue(bigNumber)));
    }

    @Override
    public BaseRationalNumber subtract(BaseRationalNumber number) {
        BigRationalNumber bigNumber = this.convertToBigIfNeeded(number);
        BigInteger numerator = this.myNumerator.multiply(bigNumber.myDenominator).subtract(bigNumber.myNumerator.multiply(this.myDenominator));
        BigInteger denominator = this.myDenominator.multiply(bigNumber.myDenominator);
        BigRationalNumber rationalNumber = new BigRationalNumber(numerator, denominator);
        return this.convertToLongIfPossible(rationalNumber);
    }

    @Override
    public BaseRationalNumber subtract(long number) {
        return this.subtract(new BigRationalNumber(number, 1L));
    }

    @Override
    public boolean isZero() {
        return this.myNumerator == BigInteger.ZERO;
    }

    public BigDecimal toBigDecimal() {
        return this.isWholeNumber() ? this.toBigDecimal(MathContext.UNLIMITED) : this.toBigDecimal(MathContext.DECIMAL128);
    }

    @Override
    public BigDecimal toBigDecimal(MathContext mc) {
        return new BigDecimal(this.myNumerator).divide(new BigDecimal(this.myDenominator), mc);
    }

    public String toString() {
        return this.toString(10);
    }

    public String toString(int base) {
        return this.toBigDecimal().toPlainString();
    }

    @Override
    public String toDotString(int scale, int roundingMode) {
        BigDecimal numer = new BigDecimal(this.myNumerator);
        BigDecimal denom = new BigDecimal(this.myDenominator);
        BigDecimal result = numer.divide(denom, scale, roundingMode);
        return result.toPlainString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LongRationalNumber) {
            return this.equalsLong((LongRationalNumber)obj);
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equals((BigRationalNumber)obj);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myDenominator == null ? 0 : this.myDenominator.hashCode());
        result = 31 * result + (this.myNumerator == null ? 0 : this.myNumerator.hashCode());
        return result;
    }

    public boolean equals(BigRationalNumber otherNumber) {
        return this.myNumerator.equals(otherNumber.myNumerator) && this.myDenominator.equals(otherNumber.myDenominator);
    }

    boolean equalsLong(LongRationalNumber otherNumber) {
        if (this.isWithinLongRange(this)) {
            long num = this.myNumerator.longValue();
            long den = this.myDenominator.longValue();
            return otherNumber.equals(num, den);
        }
        return false;
    }

    @Override
    public double doubleValue() {
        return this.toBigDecimal().doubleValue();
    }

    @Override
    public float floatValue() {
        return this.toBigDecimal().floatValue();
    }

    @Override
    public int intValue() {
        return this.toBigInteger().intValue();
    }

    @Override
    public long longValue() {
        return this.toBigInteger().longValue();
    }

    @Override
    public int compareTo(BaseRationalNumber o) {
        BigRationalNumber bigNumber = this.convertToBigIfNeeded(o);
        if (this.signum() == bigNumber.signum()) {
            if (this.signum() == 0) {
                return 0;
            }
            return this.myNumerator.multiply(bigNumber.myDenominator).compareTo(bigNumber.myNumerator.multiply(this.myDenominator));
        }
        return this.signum() > bigNumber.signum() ? 1 : -1;
    }

    private BaseRationalNumber convertToLongIfPossible(BigRationalNumber rationalNumber) {
        if (this.isWithinLongRange(rationalNumber)) {
            return new LongRationalNumber(rationalNumber.myNumerator.longValue(), rationalNumber.myDenominator.longValue());
        }
        return rationalNumber;
    }

    private boolean isWithinLongRange(BigRationalNumber rationalNumber) {
        return BigRationalNumber.isWithinLongRange(rationalNumber.myNumerator) && BigRationalNumber.isWithinLongRange(rationalNumber.myDenominator);
    }

    public BaseRationalNumber simplify() {
        return this.convertToLongIfPossible(this);
    }

    public int signum() {
        return this.myNumerator.signum();
    }

    private BigRationalNumber convertToBigIfNeeded(BaseRationalNumber number) {
        if (number.myBase == 2) {
            return (BigRationalNumber)number;
        }
        return new BigRationalNumber((LongRationalNumber)number);
    }

    public BaseRationalNumber divideToIntegralValue(BaseRationalNumber number) {
        BaseRationalNumber q = this.divide(number);
        if (q.myBase == 2) {
            return new BigRationalNumber(((BigRationalNumber)q).toBigInteger(), BigInteger.ONE, false);
        }
        return new LongRationalNumber(((LongRationalNumber)q).longValue(), 1L);
    }

    public BigInteger toBigInteger() {
        return this.myNumerator.divide(this.myDenominator);
    }

    @Override
    public byte[] toByteArray() {
        byte[] n = this.myNumerator.toByteArray();
        byte[] d = this.myDenominator.toByteArray();
        if (n.length > 65535 || d.length > 65535) {
            throw new ArithmeticException("Size of numerator or denominator to big to be represented as a byte array");
        }
        byte[] data = new byte[5 + n.length + d.length];
        data[0] = 2;
        data[1] = (byte)(n.length >> 8);
        data[2] = (byte)n.length;
        data[3] = (byte)(d.length >> 8);
        data[4] = (byte)d.length;
        System.arraycopy(n, 0, data, 5, n.length);
        System.arraycopy(d, 0, data, 5 + n.length, d.length);
        return data;
    }

    @Override
    public boolean isWholeNumber() {
        return this.myNumerator.mod(this.myDenominator).equals(BigInteger.ZERO);
    }
}

