/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class GroupedPanel
extends JPanel {
    public GroupedPanel(List<JComponent> list) {
        this.buildPanel(list, false);
    }

    public GroupedPanel(List<JComponent> list, boolean useSpring) {
        this.buildPanel(list, useSpring);
    }

    private void buildPanel(List<JComponent> list, boolean useSpring) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 1;
        c.ipadx = 0;
        c.ipady = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 11;
        c.weightx = 1.0;
        c.weighty = 0.0;
        for (JComponent panel : list) {
            ++c.gridy;
            this.add((Component)panel, c);
        }
        this.addSpring(useSpring, c.gridy++);
    }

    private void addSpring(boolean useSpring, int gridy) {
        if (useSpring) {
            JPanel spring = new JPanel();
            spring.setSize(new Dimension(0, 0));
            this.add((Component)spring, new GridBagConstraints(0, ++gridy, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }
}

