/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.util;

import com.ericsson.ere.gui.util.CalendarModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class DateFieldDocument
extends PlainDocument {
    private CalendarModel myCalendarModel;
    private int myEditField;
    private int myMin;
    private int myMax;

    public DateFieldDocument(CalendarModel calModel, int editField) {
        this.myCalendarModel = calModel;
        this.myEditField = editField;
        this.setMaxAndMin();
    }

    private void setMaxAndMin() {
        switch (this.myEditField) {
            case 1: {
                this.myMin = this.myCalendarModel.getCalendar().getActualMinimum(1);
                this.myMax = this.myCalendarModel.getCalendar().getActualMaximum(1);
                break;
            }
            case 2: {
                this.myMin = this.myCalendarModel.getCalendar().getActualMinimum(2) + 1;
                this.myMax = this.myCalendarModel.getCalendar().getActualMaximum(2) + 1;
                break;
            }
            case 5: {
                this.myMin = this.myCalendarModel.getCalendar().getActualMinimum(5);
                this.myMax = this.myCalendarModel.getCalendar().getActualMaximum(5);
            }
        }
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        String numbersOnlyString = "";
        int start = 0;
        this.setMaxAndMin();
        char[] chars = str.toCharArray();
        for (int i = start; i < chars.length; ++i) {
            if (!Character.isDigit(chars[i])) continue;
            numbersOnlyString = numbersOnlyString + chars[i];
        }
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = beforeOffset + numbersOnlyString + afterOffset;
        if (proposedResult.length() == 0) {
            return;
        }
        try {
            long longProposedResult = Long.parseLong(proposedResult);
            if (longProposedResult <= (long)this.myMax && longProposedResult >= (long)this.myMin) {
                super.insertString(offs, numbersOnlyString, a);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

