/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.util;

import com.ericsson.ere.gui.util.ClosableVarPanel;
import ericsson.vareditor.LabelRenderer2;
import ericsson.vareditor.variable.StringVariable;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class ClosableVarSelectionPanel
extends ClosableVarPanel
implements ActionListener {
    private JComboBox mySelection;
    private Map<String, List<JComponent>> mySelectableComponents;
    private StringVariable mySelectionVariable;

    public ClosableVarSelectionPanel(String groupName, boolean folded, Map<String, List<JComponent>> selectableComponents, StringVariable selectionVariable) {
        super(groupName, folded);
        this.mySelectionVariable = selectionVariable;
        this.mySelectableComponents = selectableComponents;
        Map.Entry<String, List<JComponent>> first = selectableComponents.entrySet().iterator().next();
        this.myComponents = first.getValue();
        this.mySelectionVariable.setValue(first.getKey());
        this.init();
        this.updateFoldedState();
        this.addListeners();
    }

    @Override
    protected List<? extends JComponent> getAdditionalTitleComponents() {
        String[] listNames = this.mySelectableComponents.keySet().toArray(new String[this.mySelectableComponents.size()]);
        this.mySelection = new JComboBox<String>(listNames);
        this.mySelection.addActionListener(this);
        return Collections.singletonList(this.mySelection);
    }

    @Override
    protected void onTitleClicked(MouseEvent e) {
        JComponent titleComponent = this.myTitleRenderer.getComponent();
        if (titleComponent instanceof LabelRenderer2) {
            JCheckBox ch = ((LabelRenderer2)titleComponent).check;
            Point panelL = titleComponent.getLocation();
            Point checkL = ch.getLocation();
            int dist = panelL.x + checkL.x;
            Point p = e.getPoint();
            p.x -= dist;
            if (ch.contains(p)) {
                ((LabelRenderer2)titleComponent).check.doClick();
            } else {
                this.updateFoldedState();
            }
        } else {
            this.updateFoldedState();
        }
    }

    private void recreateCustomBorderPanel() {
        this.myBorderPanel.removeAll();
        this.addComponentsToPanel(this.myBorderPanel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mySelection) {
            String selectedList = (String)this.mySelection.getSelectedItem();
            this.changeSelectedList(selectedList);
        }
    }

    public void setSelectedVarList(String listName) {
        this.mySelection.setSelectedItem(listName);
        this.changeSelectedList(listName);
    }

    public String getSelectedVarList() {
        return (String)this.mySelection.getSelectedItem();
    }

    private void changeSelectedList(String listName) {
        if (this.mySelectionVariable != null) {
            this.mySelectionVariable.setValue(listName);
        }
        this.myComponents = this.mySelectableComponents.get(listName);
        this.recreateCustomBorderPanel();
        this.updateFoldedState();
        this.updateFoldedState();
    }
}

