/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.undoredo;

import com.ericsson.ere.gui.undoredo.StructureAlteringNodeEdit;
import com.ericsson.ere.gui.undoredo.UndoableTree;
import com.ericsson.ere.gui.util.ExceptionUtil;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.ere.interfaces.DAGNode;
import java.util.Enumeration;
import javax.swing.tree.TreePath;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class DeleteNodeEdit
extends StructureAlteringNodeEdit {
    private Enumeration<TreePath> myExpandedDescendants;

    public DeleteNodeEdit(UndoableTree tree, Object[] path, int index) {
        this(tree, path, index, null);
    }

    public DeleteNodeEdit(UndoableTree tree, Object[] path, int index, Enumeration<TreePath> expandedDescendants) {
        super(tree, path, index);
        this.myExpandedDescendants = expandedDescendants;
    }

    @Override
    protected void preInsertSelect() {
        if (this.myExpandedDescendants != null) {
            while (this.myExpandedDescendants.hasMoreElements()) {
                this.getTree().expandPath(this.myExpandedDescendants.nextElement());
            }
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        try {
            if (!this.insertNode()) {
                throw new CannotUndoException();
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (CannotUndoException e) {
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.handleException(e, "ratingperiod", 1, "Exception while performing undo.", false);
            throw new CannotUndoException();
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        TariffDAGNode parent;
        super.redo();
        boolean performRemove = true;
        DAGNode toRemove = (DAGNode)this.myPath.getLastPathComponent();
        TreePath parentPath = this.myPath.getParentPath();
        if (parentPath != null && (parent = (TariffDAGNode)parentPath.getLastPathComponent()).getIndexOfChild(toRemove) < 0) {
            performRemove = false;
        }
        if (performRemove && !this.removeNode()) {
            throw new CannotRedoException();
        }
    }
}

