/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator.testgenerator;

import com.ericsson.ere.gui.simulator.SimulationDataTableModel;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationWizardOptions;
import com.ericsson.ere.gui.util.UniqueId;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class GenerationDataModel {
    private Vector<Vector<Object>> myData;
    private TestCaseGenerationWizardOptions myWizardOptions;

    GenerationDataModel(Vector<Vector<Object>> data, TestCaseGenerationWizardOptions wizardOptions) {
        this.myData = data;
        this.myWizardOptions = wizardOptions;
    }

    public Object getValueAt(int row, int col) {
        return this.myData.get(row).get(col);
    }

    public void setValueAt(Object value, int row, int col) {
        this.myData.get(row).set(col, value);
    }

    void removeRow(int row) {
        this.myData.remove(row);
    }

    public int getRowCount() {
        return this.myData.size();
    }

    Vector<Vector<Object>> getData() {
        return this.myData;
    }

    List<GenerationDataModel> cloneModel(int copies, boolean mergeClones) {
        ArrayList<GenerationDataModel> modelCopies = new ArrayList<GenerationDataModel>(copies);
        for (int i = 0; i < copies; ++i) {
            modelCopies.add(this.cloneModel());
        }
        if (mergeClones) {
            GenerationDataModel mergedModel = GenerationDataModel.mergeModels(modelCopies.toArray(new GenerationDataModel[0]));
            modelCopies.clear();
            modelCopies.add(mergedModel);
            return modelCopies;
        }
        return modelCopies;
    }

    GenerationDataModel cloneModel() {
        if (this.myWizardOptions.isStopped) {
            return this;
        }
        Vector<Vector<Object>> clonedData = null;
        clonedData = new Vector<Vector<Object>>();
        int rowCount = this.myData.size();
        for (int row = 0; row < rowCount; ++row) {
            int colCount = this.myData.get(row).size();
            Vector<Object> originalRow = this.myData.get(row);
            Vector<Object> clonedRow = new Vector<Object>(originalRow.size());
            for (int col = 0; col < colCount; ++col) {
                clonedRow.add(originalRow.get(col));
            }
            clonedData.add(clonedRow);
            String rowId = UniqueId.generate();
            clonedRow.set(SimulationDataTableModel.INDEX_OF_ROW_ID, rowId);
            if (this.myWizardOptions.myProgressPanel == null) continue;
            this.myWizardOptions.myProgressPanel.increaseProgress();
        }
        GenerationDataModel clonedModel = new GenerationDataModel(clonedData, this.myWizardOptions);
        return clonedModel;
    }

    public static GenerationDataModel mergeModels(GenerationDataModel[] models) {
        GenerationDataModel newModel = models[0];
        for (int i = 1; i < models.length; ++i) {
            newModel.getData().addAll(models[i].getData());
        }
        return newModel;
    }
}

