/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator.search;

import com.ericsson.charging.common.dataitem.DataItemAdapter;
import com.ericsson.ere.gui.simulator.SimulationPanelHelper;
import com.ericsson.ere.gui.simulator.search.FieldChooserTool;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.EnumEditor;
import ericsson.ere.gui.util.NumberRangeEditor;
import ericsson.ere.gui.util.VariableFactory;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.TypedDropDownVariable;
import ericsson.vareditor.variable.Variable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.w3c.dom.Element;

public class QueryBuilder
extends JPanel
implements TableModelListener {
    public static final String EQUALS = "Equals";
    public static final String EXACT_MATCH = "Exact match";
    public static final String CONTAINS = "Contains";
    public static final String ENDS_WITH = "Ends with";
    public static final String BEGINS_WITH = "Begins with";
    public static final String AND = " AND\n";
    public static final String OR = " OR\n";
    public static final String OPERATOR_VARIABLE_LABEL = "operator";
    public static final String INPUT_VARIABLE_LABEL = "search_string";
    private JPanel myConditionListPanel;
    private JPanel myDropDownPanel;
    private JPanel myButtonPanel;
    private FieldChooserTool mySelectionTool;
    private List<FieldRowData> myFieldModel = new ArrayList<FieldRowData>();
    private JScrollPane myScrollPanel;
    private ClassRepository myClassRepository;
    private JComboBox mySelectionBox;
    private Map<String, String> myFieldNameColumnNameMap;
    private final String myDatabaseTableName;

    public QueryBuilder(HashMap<String, List<Variable>> variableSections, ClassRepository aRepository, Map<String, String> fieldColumnMap, String tableName) {
        this.myFieldNameColumnNameMap = fieldColumnMap;
        this.myClassRepository = aRepository;
        this.mySelectionTool = this.initSelectionTool(variableSections);
        this.myDatabaseTableName = tableName;
        this.initComponents();
        GuiServiceCenter.getInstance().enableHelpKey(this, this.getClass().toString(), null);
    }

    private FieldChooserTool initSelectionTool(Map<String, List<Variable>> fieldMap) {
        ArrayList<String> fieldList = new ArrayList<String>();
        for (Map.Entry<String, List<Variable>> entry : fieldMap.entrySet()) {
            for (Variable variable : entry.getValue()) {
                if (this.myClassRepository.getFieldDefinitionByName(variable.getLabel()) == null) continue;
                fieldList.add(variable.getLabel());
            }
        }
        FieldChooserTool myTool = new FieldChooserTool(fieldList, "Fields", "Simulation field selection", "Select/deselect fields", "Use");
        myTool.setAdditionalTableModelListener(this);
        return myTool;
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.myConditionListPanel = new JPanel();
        this.myConditionListPanel.setLayout(new GridBagLayout());
        this.myDropDownPanel = new JPanel();
        this.mySelectionBox = new JComboBox<String>(new String[]{"AND", "OR"});
        this.myDropDownPanel.setLayout(new GridBagLayout());
        this.myDropDownPanel.add((Component)this.mySelectionBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(10, 10, 5, 0), 0, 0));
        this.myButtonPanel = new JPanel();
        JButton addRemoveButton = new JButton("Add/remove condition");
        addRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryBuilder.this.mySelectionTool.setVisible(true);
            }
        });
        this.myButtonPanel.setLayout(new GridBagLayout());
        this.myButtonPanel.add((Component)addRemoveButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(5, 0, 10, 10), 0, 0));
        this.myScrollPanel = new JScrollPane(this.myConditionListPanel);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.myDropDownPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.myScrollPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)this.myButtonPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getType() == 0) {
            int row = e.getFirstRow();
            String name = this.mySelectionTool.getNameOnFieldOnRow(row);
            boolean selected = this.mySelectionTool.getSelectedOnFieldOnRow(row);
            boolean didChange = selected ? QueryBuilder.addFieldRowFromModelIfNotExists(name, this.myFieldModel) : QueryBuilder.removeFieldRowFromModelIfExists(name, this.myFieldModel);
            if (didChange) {
                this.repaintPanel();
            }
        }
    }

    private void repaintPanel() {
        this.myConditionListPanel.removeAll();
        int index = 0;
        for (FieldRowData row : this.myFieldModel) {
            FieldDefinition fieldDefinition = this.myClassRepository.getFieldDefinitionByName(row.getFieldName());
            TypedDropDownVariable<String> operationVariable = QueryBuilder.createOperationComponentForFieldDefinition(fieldDefinition, row.getOperatorString());
            ((Variable)operationVariable).setDataItem(row);
            row.setDataItem(((Variable)operationVariable).getLabel(), operationVariable);
            Variable inputVariable = QueryBuilder.createInputVariableForFieldDefinition(fieldDefinition, row.getSearchString());
            inputVariable.setDataItem(row);
            row.setDataItem(inputVariable.getLabel(), inputVariable);
            JLabel label = QueryBuilder.createSimulationFieldLabel(row.getFieldName());
            this.myConditionListPanel.add((Component)label, new GridBagConstraints(0, index, 1, 1, 0.0, 0.0, 512, 1, new Insets(0, 0, 0, 0), 20, 0));
            this.myConditionListPanel.add(((Variable)operationVariable).getEditor(), new GridBagConstraints(1, index, 1, 1, 0.0, 0.0, 512, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.myConditionListPanel.add(inputVariable.getEditor(), new GridBagConstraints(2, index, 1, 1, 1.0, 0.0, 512, 1, new Insets(0, 0, 0, 0), 0, 0));
            ++index;
        }
        this.myConditionListPanel.add((Component)new JLabel(""), new GridBagConstraints(0, index, 3, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.myScrollPanel.validate();
        this.myScrollPanel.repaint();
    }

    String buildAndReturnSQLQuery() {
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM ");
        query.append(this.myDatabaseTableName);
        if (this.myFieldModel.size() > 0) {
            query.append("\nWHERE ");
        }
        String andOrString = ((String)this.mySelectionBox.getSelectedItem()).equals("AND") ? AND : OR;
        for (FieldRowData row : this.myFieldModel) {
            String operator = row.getOperatorString();
            String searchString = row.getSearchString();
            query.append("`" + this.myFieldNameColumnNameMap.get(row.getFieldName()) + "` ");
            query.append(QueryBuilder.convertVisualOperatorToSQLOperator(operator) + " ");
            query.append(QueryBuilder.createSearchString(operator, searchString));
            query.append(andOrString);
        }
        String queryString = query.toString();
        if (queryString.endsWith(AND)) {
            return queryString.substring(0, queryString.length() - AND.length());
        }
        if (queryString.endsWith(OR)) {
            return queryString.substring(0, queryString.length() - OR.length());
        }
        return queryString;
    }

    private static JLabel createSimulationFieldLabel(String fieldName) {
        JLabel newLabel = new JLabel(" " + fieldName);
        newLabel.setBorder(BorderFactory.createEtchedBorder(1));
        return newLabel;
    }

    private static boolean addFieldRowFromModelIfNotExists(String fieldName, List<FieldRowData> model) {
        for (FieldRowData row : model) {
            if (!row.getFieldName().equals(fieldName)) continue;
            return false;
        }
        model.add(new FieldRowData(fieldName));
        return true;
    }

    private static boolean removeFieldRowFromModelIfExists(String fieldName, List<FieldRowData> model) {
        for (FieldRowData row : model) {
            if (!row.getFieldName().equals(fieldName)) continue;
            model.remove(row);
            return true;
        }
        return false;
    }

    private static TypedDropDownVariable<String> createOperationComponentForFieldDefinition(FieldDefinition fieldDef, String defaultChoice) {
        List<String> choices;
        if (fieldDef == null) {
            throw new IllegalArgumentException("Parameter cannot be null");
        }
        if (XMLUtil.containsElementNamed((Element)fieldDef.getDefinitionNode(), "Enum")) {
            return new TypedDropDownVariable<String>(OPERATOR_VARIABLE_LABEL, (T[])new String[]{EQUALS});
        }
        switch (DataType.lookup(fieldDef.getDatatype())) {
            case STRING: 
            case BCDSTRING: {
                choices = Arrays.asList(BEGINS_WITH, ENDS_WITH, CONTAINS, EXACT_MATCH);
                break;
            }
            case UNSIGNEDINT8: 
            case UNSIGNEDINT16: 
            case UNSIGNEDINT32: 
            case LONG: 
            case INTEGER: 
            case SHORT: 
            case DOUBLE: 
            case DECIMAL: 
            case RATINGDECIMAL: 
            case UNSIGNEDSHORT: 
            case UNSIGNEDINT: 
            case UNSIGNEDLONG: 
            case MONETARYUNITS: {
                choices = Arrays.asList(">", "<", ">=", "<=", "=", "!=");
                break;
            }
            case BOOLEAN: 
            case DATE: 
            case TIME: 
            case OCTETSTRING: 
            case AMOUNT: {
                choices = Arrays.asList(EQUALS);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unhandled data type: " + DataType.lookup(fieldDef.getDatatype()).getTypeName()));
            }
        }
        if (choices.contains(defaultChoice)) {
            return new TypedDropDownVariable<String>(OPERATOR_VARIABLE_LABEL, choices.toArray(new String[0]), defaultChoice);
        }
        return new TypedDropDownVariable<String>(OPERATOR_VARIABLE_LABEL, (T[])choices.toArray(new String[0]));
    }

    private static Variable createInputVariableForFieldDefinition(FieldDefinition fieldDef, String defaultValue) {
        DataType dataType = DataType.lookup(fieldDef.getDatatype());
        Element fieldXML = (Element)fieldDef.getDefinitionNode();
        EnumEditor enumEditor = SimulationPanelHelper.buildEnumEditor(fieldXML);
        NumberRangeEditor rangeEditor = SimulationPanelHelper.buildNumberRangeEditor(fieldXML);
        if (enumEditor != null) {
            enumEditor.setFieldDefinition(fieldDef);
            Variable enumVariable = enumEditor.createVariable();
            enumVariable.setLabel(INPUT_VARIABLE_LABEL);
            return enumVariable;
        }
        if (rangeEditor != null) {
            rangeEditor.setFieldDefinition(fieldDef);
            Variable rangeVariable = rangeEditor.createVariable();
            rangeVariable.setLabel(INPUT_VARIABLE_LABEL);
            return rangeVariable;
        }
        String value = defaultValue != null ? defaultValue : String.valueOf(dataType.makeParseableString(dataType.createDefaultInstance()));
        return VariableFactory.getVariableOfDataType(dataType.getTypeName(), INPUT_VARIABLE_LABEL, null, null, null, value);
    }

    private static String createSearchString(String operator, String searchString) {
        if (operator.equals(BEGINS_WITH)) {
            return "'" + searchString + "%'";
        }
        if (operator.equals(ENDS_WITH)) {
            return "'%" + searchString + "'";
        }
        if (operator.equals(CONTAINS)) {
            return "'%" + searchString + "%'";
        }
        if (operator.equals(EQUALS) || operator.equals(EXACT_MATCH)) {
            return "'" + searchString + "'";
        }
        return searchString;
    }

    private static String convertVisualOperatorToSQLOperator(String operator) {
        if (operator.equals(EQUALS) || operator.equals(EXACT_MATCH)) {
            return "=";
        }
        if (operator.equals(BEGINS_WITH) || operator.equals(ENDS_WITH) || operator.equals(CONTAINS)) {
            return "LIKE";
        }
        return operator;
    }

    private static class FieldRowData
    extends DataItemAdapter {
        private final String myFieldName;
        private String myOperator;
        private String mySearchString;

        FieldRowData(String fieldName) {
            this.myFieldName = fieldName;
        }

        String getFieldName() {
            return this.myFieldName;
        }

        String getOperatorString() {
            return this.myOperator;
        }

        String getSearchString() {
            return this.mySearchString;
        }

        @Override
        public void setDataItem(Object variableLabel, Object variable) {
            if (QueryBuilder.OPERATOR_VARIABLE_LABEL.equals(variableLabel)) {
                this.myOperator = ((Variable)variable).getValueString();
            } else if (QueryBuilder.INPUT_VARIABLE_LABEL.equals(variableLabel)) {
                this.mySearchString = ((Variable)variable).getValueString();
            }
        }
    }
}

