/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator;

import com.ericsson.ere.gui.simulator.SimulationSet;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RenameSimulationSetDialog
extends JDialog {
    private SimulationSet mySimulationSet;

    public RenameSimulationSetDialog(SimulationSet simulationSet) {
        super(GuiServiceCenter.getInstance().getMainWindow(), "Rename Simulation Set", true);
        this.mySimulationSet = simulationSet;
        this.initComponents(this.mySimulationSet.getName());
        this.setIconImage(RmaDefs.getImageIcon("index_preferences16.png").getImage());
        this.setSize(250, 125);
        this.setResizable(false);
        this.setLocationRelativeTo(GuiServiceCenter.getInstance().getMainWindow());
    }

    public void initComponents(String currentName) {
        this.getContentPane().setLayout(new GridBagLayout());
        JLabel nameLabel = new JLabel("Enter a new name");
        final JTextField nameField = new JTextField(currentName);
        JButton okButton = new JButton("OK", RmaDefs.getImageIcon("index_preferences16.png"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RenameSimulationSetDialog.this.mySimulationSet.setName(nameField.getText());
                RenameSimulationSetDialog.this.dispose();
            }
        });
        JButton cancelButton = new JButton("Cancel", RmaDefs.getImageIcon("door2_16.png"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RenameSimulationSetDialog.this.dispose();
            }
        });
        this.getContentPane().add((Component)nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 8, 5, 8), 0, 0));
        this.getContentPane().add((Component)nameField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 8, 8, 8), 0, 0));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.add((Component)cancelButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        buttonPanel.add((Component)okButton, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.getContentPane().add((Component)buttonPanel, new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 10, 2, new Insets(8, 8, 8, 8), 0, 0));
    }
}

