/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.search;

import com.ericsson.charging.common.dataitem.DataItemAdapter;
import com.ericsson.ere.gui.search.presenter.SimulationBasedFilterEditPresenter;
import com.ericsson.ere.gui.search.view.SimulationBasedFilterEditView;
import com.ericsson.ere.gui.util.ClosableVarPanel;
import com.ericsson.ere.swing.EventSource;
import ericsson.ere.defs.RmaDefs;
import ericsson.vareditor.variable.TypedDropDownVariable;
import ericsson.vareditor.variable.Variable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class SimulationBasedFilterEditPanel
extends JPanel
implements SimulationBasedFilterEditView {
    private EventSource myAddParameterEvent = new EventSource();
    private EventSource myRemoveParameterEvent = new EventSource();
    private EventSource myEditParameterEvent = new EventSource();
    private JList myParameterList;
    private JLabel myEditParameterLabel;
    private JPanel myEditParameterArea;
    private JButton myAddButton;
    private JButton myDeleteButton;
    private static final String ADD_PARAMETER_TOOLTIP = "Add new field";
    private static final String REMOVE_PARAMETER_TOOLTIP = "Remove selected field";
    private static final String PARAMETER_LABEL = "Field";
    private static final String CONTEXT_LABEL = "Context";
    private static final String SELECT_PARAMETER = "Select Field";
    private static final String EDITING_PARAMETER_FMT = "Editing value for field '%s'.";
    private static final String DELETE_PARAMETER_ICON = "new_tableDeleteRow.gif";
    private static final String ADD_PARAMETER_ICON = "new_tableAddRowBelow.gif";

    public SimulationBasedFilterEditPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.createParameterList();
        this.myEditParameterLabel = new JLabel();
        this.myEditParameterArea = new JPanel(new GridBagLayout());
        this.setLayout(new BorderLayout(10, 10));
        this.add(this.createListView(), "West");
        this.add(this.createEditArea(), "Center");
    }

    private void createParameterList() {
        this.myParameterList = new JList();
        this.myParameterList.setSelectionMode(0);
        this.myParameterList.addListSelectionListener(this.myEditParameterEvent);
        this.myParameterList.setCellRenderer(new ParameterListRenderer());
    }

    private Component createListView() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 10, 0), 0, 0);
        JScrollPane scroller = new JScrollPane(this.myParameterList);
        scroller.setPreferredSize(new Dimension(200, 100));
        panel.add((Component)scroller, gbc);
        ++gbc.gridy;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.weighty = 0.0;
        panel.add(this.createToolbar(), gbc);
        return panel;
    }

    private Component createEditArea() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 10, 0), 0, 0);
        panel.add((Component)this.myEditParameterLabel, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel.add((Component)this.myEditParameterArea, gbc);
        JScrollPane scroll = new JScrollPane(panel);
        scroll.setBorder(BorderFactory.createEmptyBorder());
        return scroll;
    }

    private Component createToolbar() {
        JPanel toolbar = new JPanel(new GridLayout(1, 2, 5, 0));
        this.myAddButton = this.myAddParameterEvent.createButton("", RmaDefs.getImageIcon(ADD_PARAMETER_ICON), ADD_PARAMETER_TOOLTIP);
        this.myAddButton.setName("SimulationBasedFilterEditPanel.JButton.AddField");
        toolbar.add(this.myAddButton);
        this.myDeleteButton = this.myRemoveParameterEvent.createButton("", RmaDefs.getImageIcon(DELETE_PARAMETER_ICON), REMOVE_PARAMETER_TOOLTIP);
        this.myDeleteButton.setName("SimulationBasedFilterEditPanel.JButton.RemoveField");
        this.myDeleteButton.setEnabled(false);
        toolbar.add(this.myDeleteButton);
        JPanel holder = new JPanel(new GridBagLayout());
        holder.add((Component)toolbar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        return holder;
    }

    @Override
    public EventSource addParameterEvent() {
        return this.myAddParameterEvent;
    }

    @Override
    public Object getSelectedParameter() {
        return this.myParameterList.getSelectedValue();
    }

    @Override
    public EventSource removeParameterEvent() {
        return this.myRemoveParameterEvent;
    }

    @Override
    public String chooseParameter(String[] parameters) {
        ParameterSelector selector = new ParameterSelector(parameters);
        int result = JOptionPane.showOptionDialog(this, selector, SELECT_PARAMETER, -1, 3, null, new Object[]{"OK", "Cancel"}, "OK");
        String ret = result == 0 ? selector.getSelectedParameter() : null;
        return ret;
    }

    @Override
    public void editParameter(String name, Variable variable) {
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.myEditParameterLabel.setText(String.format(EDITING_PARAMETER_FMT, name));
        this.myEditParameterArea.removeAll();
        this.myEditParameterArea.add(this.getEditor(variable), gbc);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setParametersLeft(boolean enabled) {
        this.myAddButton.setEnabled(enabled);
    }

    private Component getEditor(Variable variable) {
        Component editor = variable.getEditor();
        ClosableVarPanel closablePanel = this.findClosableVarPanel(editor);
        if (closablePanel != null) {
            editor = this.getComponentFromClosableVarPanel(closablePanel);
        }
        return editor;
    }

    private ClosableVarPanel findClosableVarPanel(Component comp) {
        Container cont;
        int cc;
        if (comp instanceof ClosableVarPanel) {
            return (ClosableVarPanel)comp;
        }
        if (comp instanceof Container && (cc = (cont = (Container)comp).getComponentCount()) == 1) {
            return this.findClosableVarPanel(cont.getComponent(0));
        }
        return null;
    }

    private Component getComponentFromClosableVarPanel(ClosableVarPanel comp) {
        Component ret = comp;
        List<JComponent> components = comp.getClosableComponents();
        if (components.size() == 1) {
            ret = components.get(0);
            ret.setVisible(true);
        }
        return ret;
    }

    @Override
    public EventSource editParameterEvent() {
        return this.myEditParameterEvent;
    }

    @Override
    public void setParameterModel(ListModel model) {
        this.myParameterList.setModel(model);
        model.addListDataListener(new ParameterChangeHandler());
    }

    @Override
    public void stopEditingParameter() {
        this.myEditParameterLabel.setText("");
        this.myEditParameterArea.removeAll();
        this.revalidate();
        this.repaint();
    }

    void updateModified(boolean modified) {
        this.firePropertyChange("filter-is-modified", !modified, modified);
    }

    private static class IgnoreCaseStringComparator
    implements Comparator<String> {
        private IgnoreCaseStringComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    }

    private static class ParameterListRenderer
    extends DefaultListCellRenderer {
        private Font myInvalidFont = this.getFont().deriveFont(1);

        ParameterListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            SimulationBasedFilterEditPresenter.Parameter parameter = (SimulationBasedFilterEditPresenter.Parameter)value;
            if (!parameter.isValid()) {
                this.setForeground(Color.red);
                this.setFont(this.myInvalidFont);
            }
            return this;
        }
    }

    private static class ParameterSelector
    extends JPanel {
        private Map<String, List<String>> myParametersByContext;
        protected String mySelectedParameter;
        private TypedDropDownVariable<String> myContextVariable;
        private TypedDropDownVariable<String> myParameterVariable;
        private JPanel myParameterSelectorHolder;

        ParameterSelector(String[] parameters) {
            this.myParametersByContext = this.createContextMap(parameters);
            this.createVariables();
            this.initComponents();
        }

        String getSelectedParameter() {
            return this.mySelectedParameter;
        }

        private void initComponents() {
            JLabel contextLabel = new JLabel(SimulationBasedFilterEditPanel.CONTEXT_LABEL);
            JLabel parameterLabel = new JLabel(SimulationBasedFilterEditPanel.PARAMETER_LABEL);
            Component contextSelector = this.myContextVariable.getEditor();
            contextSelector.setName("SimulationBasedFilterEditPanel.JComboBox.ContextSelector");
            this.myParameterSelectorHolder = new JPanel(new BorderLayout());
            this.replaceParameterSelector();
            this.setLayout(new GridBagLayout());
            this.add((Component)contextLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.5, 512, 0, new Insets(0, 0, 8, 10), 0, 0));
            this.add(contextSelector, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.5, 512, 2, new Insets(0, 0, 8, 0), 0, 0));
            this.add((Component)parameterLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.5, 512, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.add((Component)this.myParameterSelectorHolder, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.5, 512, 2, new Insets(0, 0, 0, 0), 0, 0));
        }

        private void replaceParameterSelector() {
            this.myParameterSelectorHolder.removeAll();
            Component parameterSelector = this.myParameterVariable.getEditor();
            parameterSelector.setName("SimulationBasedFilterEditPanel.JComboBox.ParameterSelector");
            this.myParameterSelectorHolder.add(parameterSelector, "Center");
            this.revalidate();
            this.repaint();
        }

        private void createVariables() {
            ArrayList<String> contexts = new ArrayList<String>(this.myParametersByContext.keySet());
            Collections.sort(contexts, new IgnoreCaseStringComparator());
            String[] acontexts = contexts.toArray(new String[contexts.size()]);
            this.myContextVariable = new TypedDropDownVariable<String>("", acontexts, acontexts[0], new ContextLabeler());
            this.myParameterVariable = this.createParameterVariable(acontexts[0]);
            this.myContextVariable.setDataItem(new DataItemAdapter(){

                @Override
                public void setDataItem(Object reference, Object object) {
                    String selectedContext = (String)((Variable)object).getValueObject();
                    myParameterVariable = this.createParameterVariable(selectedContext);
                    this.replaceParameterSelector();
                }
            });
        }

        private TypedDropDownVariable<String> createParameterVariable(String context) {
            List<String> params = this.myParametersByContext.get(context);
            Collections.sort(params, new IgnoreCaseStringComparator());
            String[] aparams = params.toArray(new String[params.size()]);
            TypedDropDownVariable<String> variable = new TypedDropDownVariable<String>("", aparams, aparams[0], new ParameterLabeler());
            variable.setDataItem(new DataItemAdapter(){

                @Override
                public void setDataItem(Object reference, Object object) {
                    mySelectedParameter = (String)((Variable)object).getValueObject();
                }
            });
            this.mySelectedParameter = aparams[0];
            return variable;
        }

        private Map<String, List<String>> createContextMap(String[] parameters) {
            HashMap<String, List<String>> map = new HashMap<String, List<String>>();
            for (String param : parameters) {
                ArrayList<String> list;
                String context = "";
                int idx = param.indexOf(">");
                if (idx >= 0) {
                    context = param.substring(0, idx);
                }
                if ((list = (ArrayList<String>)map.get(context)) == null) {
                    list = new ArrayList<String>();
                    map.put(context, list);
                }
                list.add(param);
            }
            return map;
        }

        private static class ContextLabeler
        implements TypedDropDownVariable.ItemLabeler<String> {
            private ContextLabeler() {
            }

            @Override
            public String getDisplayStringFor(String context, int index) {
                return "".equals(context) ? "None" : context;
            }
        }

        private static class ParameterLabeler
        implements TypedDropDownVariable.ItemLabeler<String> {
            private ParameterLabeler() {
            }

            @Override
            public String getDisplayStringFor(String parameter, int index) {
                String display = parameter;
                int idx = display.indexOf(">");
                if (idx >= 0) {
                    display = display.substring(idx + 1);
                }
                return display;
            }
        }
    }

    private class ParameterChangeHandler
    implements ListDataListener {
        private ParameterChangeHandler() {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            SimulationBasedFilterEditPanel.this.updateModified(true);
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            SimulationBasedFilterEditPanel.this.updateModified(true);
            SwingUtilities.invokeLater(new ParameterListSelector(e.getIndex0()));
            SimulationBasedFilterEditPanel.this.myDeleteButton.setEnabled(true);
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            SimulationBasedFilterEditPanel.this.updateModified(true);
            int newIdx = Math.max(0, e.getIndex0() - 1);
            SwingUtilities.invokeLater(new ParameterListSelector(newIdx));
            SimulationBasedFilterEditPanel.this.myDeleteButton.setEnabled(SimulationBasedFilterEditPanel.this.myParameterList.getModel().getSize() > 0);
        }
    }

    private class ParameterListSelector
    implements Runnable {
        private int myIndex;

        ParameterListSelector(int index) {
            this.myIndex = index;
        }

        @Override
        public void run() {
            SimulationBasedFilterEditPanel.this.myParameterList.setSelectedIndex(this.myIndex);
        }
    }
}

