/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.nodes;

import com.ericsson.ere.gui.navigator.nodes.AbstractNavigatorNode;
import com.ericsson.ere.gui.navigator.nodes.DeletableNode;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.RatingPlanProxy;
import ericsson.ere.defs.RmaDefs;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;

public class RatingPlanNode
extends AbstractNavigatorNode
implements DeletableNode {
    public static final String NODE_TYPE = "RatingPlanNode";
    public static final String ICON_NO_CHILDREN = "navigator_closed_ratingplan2.png";
    public static final String ICON_CHILDREN = "navigator_open_ratingplan2.png";
    public static final String ICON_NO_CHILDREN_FILTERED = "navigator_closed_ratingplan2_filtered.png";
    public static final String ICON_CHILDREN_FILTERED = "navigator_open_ratingplan2_filtered.png";
    private RatingPlanProxy myRatingPlanProxy = null;

    public RatingPlanNode(RatingPlanProxy planProxy) {
        this.myRatingPlanProxy = planProxy;
    }

    @Override
    public String toString() {
        return this.myRatingPlanProxy.getName() + " (" + this.myRatingPlanProxy.getServiceName() + ")";
    }

    @Override
    public void cancel() {
        if (this.isNew && (DefaultMutableTreeNode)this.getParent() != null) {
            ((DefaultMutableTreeNode)this.getParent()).remove(this);
        }
    }

    @Override
    public String getTitle() {
        return this.toString();
    }

    @Override
    public ImageIcon getNodeIcon(boolean expanded) {
        boolean hasFilteredChildren = this.hasFilteredChildren();
        if (expanded && !hasFilteredChildren) {
            return RmaDefs.getImageIcon(ICON_CHILDREN);
        }
        if (expanded && hasFilteredChildren) {
            return RmaDefs.getImageIcon(ICON_CHILDREN_FILTERED);
        }
        if (!expanded && hasFilteredChildren) {
            return RmaDefs.getImageIcon(ICON_NO_CHILDREN_FILTERED);
        }
        return RmaDefs.getImageIcon(ICON_NO_CHILDREN);
    }

    @Override
    public String getNodeToolTip() {
        return "RatingPlan : <b>" + this.myRatingPlanProxy.getName() + "</b>\n" + "Service" + " : " + this.myRatingPlanProxy.getServiceName();
    }

    @Override
    public AbstractEreProxy getProxy() {
        return this.myRatingPlanProxy;
    }

    public String getRatingPlanName() {
        return this.myRatingPlanProxy.getName();
    }
}

