/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.nodeimport;

import com.ericsson.ere.datatype.ERETimeFactory;
import com.ericsson.ere.datatype.ERETimeUtil;
import com.ericsson.ere.gui.navigator.NavigatorTreeUtil;
import com.ericsson.ere.gui.navigator.nodednd.panels.DndProgressPanel;
import com.ericsson.ere.gui.navigator.nodeimport.ImportUtil;
import com.ericsson.ere.gui.navigator.nodeimport.ImportWizardOptions;
import com.ericsson.ere.gui.navigator.nodeimport.panels.ImportProgressPanel;
import com.ericsson.ere.gui.navigator.nodes.AbstractNavigatorNode;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.RatingManagerProxy;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import com.ericsson.ere.proxy.RatingPlanProxy;
import com.ericsson.ere.proxy.SavedListProxy;
import com.ericsson.ere.proxy.ServiceListProxy;
import com.ericsson.ere.proxy.ServiceProviderListProxy;
import com.ericsson.ere.proxy.ServiceProviderProxy;
import com.ericsson.ere.proxy.ServiceProxy;
import com.ericsson.ere.proxy.exception.BuildFailedException;
import com.ericsson.ere.proxy.exception.ServiceValidationException;
import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.Time;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.propertieseditor.EditablePropertiesInterface;
import ericsson.ere.gui.propertieseditor.PropertiesEditor;
import ericsson.ere.gui.propertieseditor.PropertiesException;
import ericsson.ere.gui.util.DefaultDialogFactory;
import ericsson.ere.gui.util.DialogFactoryInterface;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.ere.integration.settingsmap.propertyio.VarTableInput;
import ericsson.ere.integration.settingsmap.propertyio.VarTableOutput;
import ericsson.ere.management.DateUtil;
import ericsson.ere.progress.ProgressIndicator;
import ericsson.ere.progress.ProgressVisualizer;
import ericsson.ere.progress.SynchronizedEDTProgressVisualizer;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.VarTableModel;
import java.text.ParseException;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Element;

public class ProxiedNavigatorTreeImporter {
    private RatingManagerProxy myRatingManagerProxy = null;
    private boolean myImportFailure = false;
    private volatile boolean myContinueImport = true;
    private ProgressVisualizer myVisualizer = null;
    private ProgressIndicator myProgress = null;
    public boolean hasCompleted = false;
    private boolean yesToAllServiceProvider = false;
    private boolean yesToAllRatingPlan = false;
    private boolean cancelEdit = false;
    private boolean skipImport = false;
    private DialogFactoryInterface myDialogFactory;

    public ProxiedNavigatorTreeImporter(ProgressVisualizer visualizer) {
        this.myVisualizer = visualizer;
        this.myDialogFactory = new DefaultDialogFactory();
    }

    public void setDialogFactory(DialogFactoryInterface aFactory) {
        this.myDialogFactory = aFactory;
    }

    public ProxiedNavigatorTreeImporter(ProgressVisualizer visualizer, DialogFactoryInterface aFactory) {
        this.myVisualizer = visualizer;
        this.myDialogFactory = aFactory;
    }

    public void setCanceled() {
        this.myContinueImport = false;
    }

    @Deprecated
    public void importXML(ImportWizardOptions options) {
        this.importXML(options.rootElement, options.targetNavigatorTreeNode, options.selectedNodes.size());
    }

    public void importXML(Element rootElement, AbstractNavigatorNode targetNode, int numberOfSelectedNodes) {
        AbstractEreProxy targetEreProxy = targetNode.getProxy();
        this.myImportFailure = false;
        this.initiateRatingManagerProxy(targetNode);
        try {
            this.initProgressIndicator(numberOfSelectedNodes);
            boolean containsListOfServices = XMLUtil.containsElementNamed(rootElement, "ServiceList");
            boolean containsService = XMLUtil.containsElementNamed(rootElement, "Service");
            boolean containsServiceProviderList = XMLUtil.containsElementNamed(rootElement, "ServiceProviderList");
            boolean containsServiceProvider = XMLUtil.containsElementNamed(rootElement, "ServiceProvider");
            boolean containsRatingPlan = XMLUtil.containsElementNamed(rootElement, "RatingPlan");
            boolean containsRatingPeriod = XMLUtil.containsElementNamed(rootElement, "RatingPeriod");
            int importFailureCount = 0;
            if (containsListOfServices || containsRatingPeriod || containsRatingPlan || containsService || containsServiceProvider || containsServiceProviderList) {
                if ((containsService || containsListOfServices) && this.myContinueImport) {
                    Vector<Element> serviceElements = ImportUtil.getServiceElements(rootElement);
                    int numberOfImportedNodes = this.importServices(serviceElements);
                    importFailureCount += serviceElements.size() - numberOfImportedNodes;
                }
                if ((containsServiceProvider || containsServiceProviderList) && this.myContinueImport) {
                    ServiceProviderListProxy serviceProviderListProxy = this.myRatingManagerProxy.getServiceProviderListProxy();
                    Vector<Element> serviceProviderList = ImportUtil.getServiceProviderList(rootElement);
                    block2: for (Element serviceProviderElement : serviceProviderList) {
                        if (this.myContinueImport) {
                            ServiceProviderProxy newServiceProviderProxy = this.importServiceProvider(serviceProviderListProxy, serviceProviderElement);
                            this.myProgress.progressIncrement(1);
                            Vector<Element> ratingPlanList = ImportUtil.getRatingPlanList(serviceProviderElement);
                            for (Element ratingPlanElement : ratingPlanList) {
                                String ratingPlanService = ImportUtil.getRatingPlanService(ratingPlanElement);
                                if (this.myRatingManagerProxy.getServiceListProxy().serviceExists(ratingPlanService)) {
                                    if (!this.myContinueImport) continue block2;
                                    RatingPlanProxy ratingPlanProxy = this.getRatingPlanProxy(newServiceProviderProxy, ratingPlanElement);
                                    if (ratingPlanProxy == null) continue;
                                    importFailureCount += this.importRatingPeriodsAndReturnNbrOfFailures(ratingPlanElement, ratingPlanProxy);
                                    continue;
                                }
                                String info = "No matching service for rating plan '" + ImportUtil.getRatingPlanName(ratingPlanElement) + "' was found";
                                this.myDialogFactory.getErrorDialog("No service found", info);
                                this.myProgress.showAdditionalInfo(info);
                                ++importFailureCount;
                            }
                            continue;
                        }
                        break;
                    }
                } else if (containsRatingPlan && this.myContinueImport) {
                    ServiceListProxy serviceListProxy = this.myRatingManagerProxy.getServiceListProxy();
                    Vector<Element> ratingPlanList = ImportUtil.getRatingPlanList(rootElement);
                    for (Element ratingPlanElement : ratingPlanList) {
                        String ratingPlanName = ImportUtil.getRatingPlanName(ratingPlanElement);
                        String ratingPlanService = ImportUtil.getRatingPlanService(ratingPlanElement);
                        if (serviceListProxy.serviceExists(ratingPlanService)) {
                            if (this.myContinueImport) {
                                RatingPlanProxy rpProxy = this.getRatingPlanProxy(targetEreProxy, ratingPlanElement);
                                this.myProgress.progressIncrement(1);
                                if (rpProxy == null) {
                                    ++importFailureCount;
                                    continue;
                                }
                                if (this.myContinueImport) {
                                    importFailureCount += this.importRatingPeriodsAndReturnNbrOfFailures(ratingPlanElement, rpProxy);
                                    continue;
                                }
                            }
                            break;
                        }
                        this.myProgress.showAdditionalInfo("Failed to import rating period '" + ratingPlanName + "'.");
                        this.myProgress.showAdditionalInfo("The service '" + ratingPlanService + "' specified in the imported file could not be found.");
                        this.myProgress.setInfo(" ");
                        this.myProgress.progressIncrement(1);
                    }
                } else if (containsRatingPeriod && this.myContinueImport) {
                    RatingPlanProxy ratingPlanProxy = this.getRatingPlanProxy(targetEreProxy, null);
                    importFailureCount += this.importRatingPeriodsAndReturnNbrOfFailures(rootElement, ratingPlanProxy);
                }
            }
            this.finishProgressIndicator(importFailureCount);
        }
        catch (Exception e) {
            ExceptionUtil.handleException(e, "navigator", 1, "Import problems", false);
            this.myProgress.setInfo("Problems during import (check log for details): " + e.getMessage());
        }
        this.hasCompleted = true;
    }

    private RatingPlanProxy getRatingPlanProxy(ServiceProviderProxy serviceProviderProxy, Element ratingPlanElement) {
        RatingPlanProxy ratingPlanProxy = null;
        ratingPlanProxy = serviceProviderProxy.hasRatingPlanAndPeriodProxy() ? this.importRatingPlanAndPeriods(serviceProviderProxy, ratingPlanElement) : this.importRatingPlan(serviceProviderProxy, ratingPlanElement);
        return ratingPlanProxy;
    }

    private int importRatingPeriodsAndReturnNbrOfFailures(Element element, RatingPlanProxy planProxy) {
        Vector<Element> ratingPeriodList = ImportUtil.getRatingPeriodList(element);
        int numberOfImportedNodes = this.importRatingPeriods(planProxy, ratingPeriodList);
        return ratingPeriodList.size() - numberOfImportedNodes;
    }

    private void initiateRatingManagerProxy(AbstractNavigatorNode targetNavigatorTreeNode) {
        AbstractEreProxy targetEreProxy = targetNavigatorTreeNode.getProxy();
        this.myRatingManagerProxy = targetEreProxy == null ? targetNavigatorTreeNode.getProxy().getRatingManagerProxy() : targetEreProxy.getRatingManagerProxy();
    }

    private void initProgressIndicator(int nbrOfIncrements) {
        this.myProgress = this.createProgressIndicator(nbrOfIncrements);
        this.myProgress.setInfo("Import Start");
        this.myProgress.setInfo("");
    }

    private void finishProgressIndicator(int nbrOfFailedImports) {
        this.myProgress.progressFinished();
        if (this.myContinueImport) {
            if (!this.myImportFailure && nbrOfFailedImports == 0) {
                this.myProgress.setInfo("Import completed successfully.");
            } else if (nbrOfFailedImports > 0) {
                this.myProgress.setInfo("Finished, but some items could not be imported.");
            } else {
                this.myProgress.setInfo("Import failed.");
            }
        } else {
            this.myProgress.setInfo("Import canceled.");
        }
        this.myProgress.setInfo("");
    }

    private ProgressIndicator createProgressIndicator(int nbrOfSelectedNodes) {
        ProgressIndicator pi;
        if (this.myVisualizer instanceof ImportProgressPanel) {
            pi = SynchronizedEDTProgressVisualizer.createThreadSafeProgressIndicator(this.myVisualizer, nbrOfSelectedNodes);
        } else if (this.myVisualizer instanceof DndProgressPanel) {
            pi = SynchronizedEDTProgressVisualizer.createThreadSafeProgressIndicator(this.myVisualizer);
        } else {
            throw new AssertionError((Object)("Unhandled visualizer: " + this.myVisualizer.getClass().getName()));
        }
        return pi;
    }

    private RatingPlanProxy getRatingPlanProxy(AbstractEreProxy proxy, Element ratingPlanElement) {
        RatingPlanProxy rpProxy = null;
        if (proxy instanceof ServiceProviderProxy) {
            ServiceProviderProxy spProxy = (ServiceProviderProxy)proxy;
            rpProxy = this.importRatingPlan(spProxy, ratingPlanElement);
        } else if (proxy instanceof RatingPlanProxy) {
            rpProxy = (RatingPlanProxy)proxy;
        }
        if (proxy instanceof RatingPeriodProxy) {
            RatingPeriodProxy ratingPeriodProxy = (RatingPeriodProxy)proxy;
            rpProxy = ratingPeriodProxy.getParentRatingPlanProxy();
        } else if (proxy instanceof SavedListProxy) {
            SavedListProxy savedListProxy = (SavedListProxy)proxy;
            rpProxy = savedListProxy.getRatingPlanProxy();
        }
        return rpProxy;
    }

    private int importRatingPeriods(RatingPlanProxy planProxy, List<Element> ratingPeriodList) {
        int count = 0;
        for (Element ratingPeriodElement : ratingPeriodList) {
            if (!this.myContinueImport) break;
            if (this.importRatingPeriod(planProxy, ratingPeriodElement) != null) {
                ++count;
            }
            this.myProgress.progressIncrement(1);
        }
        return count;
    }

    private int importServices(List<Element> serviceElements) {
        int count = 0;
        for (Element service : serviceElements) {
            if (!this.myContinueImport) break;
            if (this.importService(service)) {
                ++count;
            }
            this.myProgress.progressIncrement(1);
        }
        return count;
    }

    private boolean importService(Element serviceElement) {
        boolean result = false;
        String serviceName = serviceElement.getAttribute("Name");
        if (!NavigatorTreeUtil.shouldServiceListBeShown(this.myRatingManagerProxy)) {
            this.myProgress.showAdditionalInfo("! Failed to import service '" + serviceName + "'.");
            this.myProgress.showAdditionalInfo("! ERE error message: The connected ERE prohibits the import of services.");
            this.myProgress.setInfo(" ");
            return false;
        }
        ServiceListProxy serviceListProxy = this.myRatingManagerProxy.getServiceListProxy();
        this.myProgress.setInfo("Importing service: " + serviceName);
        boolean serviceExists = serviceListProxy.serviceExists(serviceName);
        if (serviceExists) {
            boolean answer = this.myDialogFactory.getQuestionDialogCustomButtons(GuiServiceCenter.getInstance().getMainWindow(), "Overwrite", "<html>The service <i>" + serviceName + "</i> already exists.<br><br>Do you want to overwrite it?", "Yes", "Skip");
            if (answer) {
                result = this.importService(serviceListProxy, serviceElement, serviceName, true);
            }
        } else {
            result = this.importService(serviceListProxy, serviceElement, serviceName, false);
        }
        this.myProgress.setInfo(" ");
        return result;
    }

    private boolean importService(ServiceListProxy serviceListProxy, Element serviceElement, String serviceName, boolean overwrite) {
        boolean result = false;
        try {
            ServiceProxy.prepareXMLForServiceCreation(serviceElement);
            if (overwrite) {
                Element structureElement = XMLUtil.getNamedElement("ServiceDefinition", serviceElement.getChildNodes());
                Element conditionElement = XMLUtil.getNamedElement("Settings", structureElement.getChildNodes());
                serviceListProxy.getServiceProxy(serviceName).updateService(structureElement, conditionElement, true);
            } else {
                serviceListProxy.createService(serviceElement);
            }
            result = true;
        }
        catch (ServiceValidationException e) {
            String msg = e.getMessage();
            if (e.getCause() != null) {
                msg = msg + " Check log for details.";
                ExceptionUtil.handleException(e, "navigator", 1, "Service import failed to complete.", false);
            }
            this.myProgress.showAdditionalInfo(msg);
        }
        catch (Exception ex) {
            this.myProgress.showAdditionalInfo("Unable to import service (check log for details): " + ex.getMessage());
            ExceptionUtil.handleException(ex, "navigator", 1, "Service import failed to complete.", false);
        }
        return result;
    }

    private ServiceProviderProxy importServiceProvider(ServiceProviderListProxy serviceProviderListProxy, Element serviceProviderElement) throws Exception {
        ServiceProviderProxy result = null;
        String serviceProviderName = serviceProviderElement.getAttribute("Name");
        this.myProgress.setInfo("Importing service provider: " + serviceProviderName);
        result = serviceProviderListProxy.getServiceProvider(serviceProviderName);
        if (result != null) {
            if (!this.yesToAllServiceProvider) {
                String[] options = new String[]{"Yes", "Yes to All", "Stop"};
                int choice = this.myDialogFactory.showOptionDialog(GuiServiceCenter.getInstance().getMainWindow(), "Service Provider Exists", "<html> The service provider <i>" + serviceProviderName + "</i> already exists.<br><br>Would you like to merge the two service providers?<br><br>", options);
                switch (choice) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.yesToAllServiceProvider = true;
                        break;
                    }
                    default: {
                        this.myContinueImport = false;
                        break;
                    }
                }
            }
        } else {
            try {
                result = serviceProviderListProxy.createServiceProvider(serviceProviderElement);
                this.myProgress.setInfo("Successful");
            }
            catch (Exception e) {
                this.myProgress.showAdditionalInfo("! Failed to import service provider '" + serviceProviderName + "'\n\n");
                throw e;
            }
        }
        this.myProgress.setInfo("");
        return result;
    }

    private RatingPlanProxy importRatingPlanAndPeriods(ServiceProviderProxy serviceProviderProxy, Element ratingPlanElement) {
        String ratingPlanName = ratingPlanElement.getAttribute("Name");
        String serviceName = ratingPlanElement.getAttribute("Service");
        this.myProgress.setInfo("Importing rating plan: " + ratingPlanName);
        RatingPlanProxy ratingPlanProxy = serviceProviderProxy.getRatingPlanProxy(ratingPlanName);
        if (ratingPlanProxy != null) {
            if (this.shouldContinueImport(ratingPlanName, serviceName, serviceProviderProxy)) {
                return ratingPlanProxy;
            }
            return null;
        }
        try {
            serviceProviderProxy.createRatingPlanAndPeriod(ratingPlanElement);
            this.myProgress.progressIncrement(ratingPlanElement.getElementsByTagName("RatingPeriod").getLength() + 1);
            this.myProgress.setInfo("Successful");
            return null;
        }
        catch (Exception e) {
            this.myProgress.showAdditionalInfo("! Failed to create rating plan '" + ratingPlanName + "' and its rating periods.");
            this.myProgress.showAdditionalInfo("! ERE error message: " + e.getMessage());
            this.myProgress.setInfo("");
            return ratingPlanProxy;
        }
    }

    private boolean shouldContinueImport(String ratingPlanName, String serviceName, ServiceProviderProxy serviceProviderProxy) {
        RatingPlanProxy ratingPlanProxy = serviceProviderProxy.getRatingPlanProxy(ratingPlanName);
        if (ratingPlanProxy == null) {
            return true;
        }
        if (ratingPlanProxy.getServiceName().equalsIgnoreCase(serviceName)) {
            return this.showDialog(ratingPlanName);
        }
        this.myDialogFactory.getErrorDialog("Ambigious service found", "Service ' " + serviceName + "' in the import file must match service '" + ratingPlanProxy.getServiceName() + "'");
        this.myProgress.showAdditionalInfo("Failed to import rating plan '" + ratingPlanName + "'.");
        this.myProgress.showAdditionalInfo("The service '" + serviceName + "' did not match the service '" + ratingPlanProxy.getServiceName() + "of the existing rating plan.");
        return false;
    }

    private boolean showDialog(String ratingPlanName) {
        if (this.yesToAllRatingPlan) {
            return true;
        }
        String[] options = new String[]{"Yes", "Yes to All", "Stop"};
        int choice = this.myDialogFactory.showOptionDialog(GuiServiceCenter.getInstance().getMainWindow(), "Rating Plan Exists", "<html>The rating plan <i>" + ratingPlanName + "</i> already exists.<br><br>Would you like to merge the two rating plans?<br><br>", options);
        switch (choice) {
            case 0: {
                return true;
            }
            case 1: {
                this.yesToAllRatingPlan = true;
                return true;
            }
        }
        this.myContinueImport = false;
        return false;
    }

    private RatingPlanProxy importRatingPlan(ServiceProviderProxy serviceProviderProxy, Element ratingPlanElement) {
        String ratingPlanName = ratingPlanElement.getAttribute("Name");
        String serviceName = ratingPlanElement.getAttribute("Service");
        this.myProgress.setInfo("Importing rating plan: " + ratingPlanName);
        RatingPlanProxy ratingPlanProxy = serviceProviderProxy.getRatingPlanProxy(ratingPlanName);
        if (ratingPlanProxy != null) {
            if (this.shouldContinueImport(ratingPlanName, serviceName, serviceProviderProxy)) {
                return ratingPlanProxy;
            }
            return null;
        }
        try {
            ratingPlanProxy = serviceProviderProxy.createRatingPlan(ratingPlanElement);
            this.myProgress.setInfo("Successful");
            this.myProgress.progressIncrement(1);
        }
        catch (Exception e) {
            this.myProgress.showAdditionalInfo("! Failed to import rating plan '" + ratingPlanName + "'");
            this.myProgress.showAdditionalInfo("! ERE error message: " + e.getMessage());
        }
        this.myProgress.setInfo("");
        return ratingPlanProxy;
    }

    private RatingPeriodProxy importRatingPeriod(RatingPlanProxy ratingPlanProxy, Element ratingPeriodElement) {
        RatingPeriodProxy result;
        block9: {
            this.cancelEdit = false;
            this.skipImport = false;
            result = null;
            String ratingPeriodName = ratingPeriodElement.getAttribute("Name");
            if (ratingPlanProxy == null) {
                this.myImportFailure = true;
                this.myProgress.showAdditionalInfo("! Failed to create rating period '" + ratingPeriodName + "'");
                this.myProgress.showAdditionalInfo("! The selected node is not a valid import target for a rating period.");
                return null;
            }
            this.myProgress.setInfo("Importing rating period: " + ratingPeriodName);
            try {
                while (!this.checkDate(ratingPeriodElement, ratingPlanProxy)) {
                }
                if (!this.cancelEdit) {
                    if (!this.skipImport) {
                        Element structureRoot = XMLUtil.getNamedElement("TariffStructure", ratingPeriodElement.getChildNodes());
                        if (structureRoot != null && XMLUtil.getNamedElement("Version", structureRoot.getChildNodes()) == null) {
                            ImportUtil.addVersionElement(structureRoot);
                        }
                        try {
                            result = ratingPlanProxy.createRatingPeriod(ratingPeriodElement);
                        }
                        catch (BuildFailedException e) {
                            this.myProgress.setInfo("Invalid tree, opening editor to allow correction...");
                            result = ratingPlanProxy.createRatingPeriodViaEditor(ratingPeriodElement, "Please correct the faulty configuration before the import can continue.");
                        }
                        this.myProgress.setInfo("Successful");
                        break block9;
                    }
                    this.myProgress.setInfo("Import of rating period skipped.");
                    return null;
                }
                this.myProgress.setInfo("Import cancelled.");
            }
            catch (Exception e) {
                this.myProgress.showAdditionalInfo("! Failed to import rating period '" + ratingPeriodName + "'");
                this.myProgress.showAdditionalInfo("! ERE error message: " + e.getMessage());
                this.myImportFailure = true;
            }
        }
        this.myProgress.setInfo("");
        return result;
    }

    private boolean checkDate(final Element ratingPeriodElement, RatingPlanProxy ratingPlanProxy) {
        final String ratingPeriodName = ratingPeriodElement.getAttribute("Name");
        String startDate = ratingPeriodElement.getAttribute("StartDate");
        if (StringUtil.isEmptyString(startDate)) {
            startDate = ERETimeUtil.makeISOStringFromERETime(ERETimeFactory.now());
            ratingPeriodElement.setAttribute("StartDate", startDate);
        }
        boolean invalidStartDate = false;
        int result = ratingPlanProxy.validateDate(startDate);
        if (result == 1) {
            invalidStartDate = true;
        }
        if (invalidStartDate) {
            SettingsMap settings = new SettingsMap();
            settings.setParameter("Name", ratingPeriodName, 1, false);
            settings.setParameter("StartDate", startDate, 4, !invalidStartDate);
            VarTableModel oldSettings = VarTableOutput.writeToVarTableModel(settings);
            String message = "<html>A problem was encountered when importing rating plan \"" + ratingPlanProxy.getName() + "\":\n\n";
            String formatedDate = startDate;
            try {
                formatedDate = DataType.TIME.makeDisplayString(new Time(DateUtil.stringToCalendar(startDate)));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            message = message + "A rating period with start date \"" + formatedDate + "\" already exists.\n\n";
            message = message + "A dialog will be shown to allow you to change the start date of the rating period to import.";
            String[] options = new String[]{"Edit", "Skip", "Stop"};
            int choice = this.myDialogFactory.showOptionDialog(GuiServiceCenter.getInstance().getMainWindow(), "Rating Period Start Date Conflict", message, options);
            switch (choice) {
                case 0: {
                    break;
                }
                case 1: {
                    this.skipImport = true;
                    this.myContinueImport = true;
                    return true;
                }
                case -1: 
                case 2: {
                    this.cancelEdit = true;
                    this.myContinueImport = false;
                    return true;
                }
            }
            PropertiesEditor.showDialogEdit(oldSettings, "Edit StartDate for '" + ratingPeriodName + "'", new EditablePropertiesInterface(){

                @Override
                public void cancel() {
                    ProxiedNavigatorTreeImporter.this.cancelEdit = true;
                }

                @Override
                public String getTitle() {
                    return ratingPeriodName;
                }

                @Override
                public void update(VarTableModel model) throws PropertiesException {
                    SettingsMap newSettings = VarTableInput.readFromVarTableModel(model);
                    try {
                        ratingPeriodElement.setAttribute("Name", newSettings.getParameterAsString("Name"));
                        Element structureElement = XMLUtil.getNamedElement("TariffStructure", ratingPeriodElement.getChildNodes());
                        structureElement.setAttribute("Name", newSettings.getParameterAsString("Name"));
                        ratingPeriodElement.setAttribute("StartDate", newSettings.getParameterAsString("StartDate"));
                    }
                    catch (Exception e) {
                        ExceptionUtil.handleException(e, "navigator", 2, "Failed to set new properties for the rating period.", true);
                    }
                }

                @Override
                public boolean isSuccessful() {
                    return true;
                }
            });
            return this.checkDate(ratingPeriodElement, ratingPlanProxy);
        }
        return true;
    }
}

