/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.nodeimport;

import com.ericsson.ere.gui.navigator.nodeimport.states.ImportWizardFileState;
import com.ericsson.ere.gui.navigator.nodeimport.states.ImportWizardMigrateState;
import com.ericsson.ere.gui.navigator.nodeimport.states.ImportWizardNodesState;
import com.ericsson.ere.gui.navigator.nodeimport.states.ImportWizardProgressState;
import com.ericsson.ere.gui.navigator.nodes.AbstractNavigatorNode;
import com.ericsson.ere.gui.wizard.AbstractWizardModel;
import com.ericsson.ere.migration.MigrationContext;
import com.ericsson.ere.migration.MigrationException;
import com.ericsson.ere.migration.MigrationManager;
import com.ericsson.ere.migration.MigrationManagerFactory;
import ericsson.ere.xml.XMLUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ImportWizardModel
extends AbstractWizardModel {
    private boolean mySelectedFileNeedsMigration = false;
    private File mySelectedSourceFile = null;
    private File myMigratedSelectedSourceFile = null;
    private MigrationManager myMigrationManager = null;
    private Element myRootElement = null;
    private boolean myDefaultSelectAllTreeNodes = true;
    private Vector<DefaultMutableTreeNode> mySelectedNodes = new Vector();
    private AbstractNavigatorNode myTargetNavigatorTreeNode = null;

    public ImportWizardModel(AbstractNavigatorNode targetNode) {
        this(targetNode, null);
    }

    public ImportWizardModel(AbstractNavigatorNode targetNode, File importFile) {
        this.mySelectedSourceFile = importFile;
        this.myTargetNavigatorTreeNode = targetNode;
        this.myMigrationManager = MigrationManagerFactory.getImportManager(MigrationManagerFactory.MigrationManagerType.NAVIGATOR_TREE_MIGRATION_MANAGER);
        this.setUpButtonStates();
        this.setUpModelStates();
    }

    private final void setUpModelStates() {
        ImportWizardFileState fileState = new ImportWizardFileState(this);
        ImportWizardMigrateState migrateState = new ImportWizardMigrateState(this);
        ImportWizardNodesState nodesState = new ImportWizardNodesState(this);
        ImportWizardProgressState progressState = new ImportWizardProgressState(this);
        fileState.setAdjacentStates(null, migrateState);
        migrateState.setAdjacentStates(fileState, nodesState);
        nodesState.setAdjacentStates(migrateState, progressState);
        progressState.setAdjacentStates(nodesState, null);
        this.setCurrentState(fileState);
    }

    private final void setUpButtonStates() {
        this.setBackAndNextEnabled(false, false);
    }

    @Override
    public void cancelAllActions() {
        this.getCurrentState().cancelStateActions();
    }

    public File getSelectedSourceFile() {
        return this.mySelectedSourceFile;
    }

    public File getMigratedFile() {
        return this.myMigratedSelectedSourceFile;
    }

    public void resetMigration() {
        this.myMigratedSelectedSourceFile = null;
        this.myRootElement = null;
    }

    public void setSelectedSourceFile(File sourceFile) {
        this.mySelectedFileNeedsMigration = false;
        this.myRootElement = null;
        this.myMigratedSelectedSourceFile = null;
        this.mySelectedSourceFile = sourceFile;
    }

    public boolean isNeedingMigration() {
        return this.mySelectedFileNeedsMigration;
    }

    public void setNeedsMigration(boolean needsMigration) {
        this.mySelectedFileNeedsMigration = needsMigration;
    }

    public boolean isSelectedSourceFileValid() throws IOException {
        return this.mySelectedSourceFile == null ? false : this.myMigrationManager.isFileValid(this.mySelectedSourceFile);
    }

    public boolean isMigratedFileValid() throws IOException {
        return this.myMigratedSelectedSourceFile == null ? false : this.myMigrationManager.isFileValid(this.myMigratedSelectedSourceFile);
    }

    public void migrateSelectedSourceFile(MigrationContext context) throws MigrationException, IOException, ParserConfigurationException, SAXException {
        this.myMigratedSelectedSourceFile = this.myMigrationManager.migrateFile(this.mySelectedSourceFile, context);
        XMLUtil.buildDocumentFromFile(this.myMigratedSelectedSourceFile).getDocumentElement();
    }

    public Element getRootElement() {
        return this.myRootElement;
    }

    public void setRootElement(Element rootElement) {
        this.myRootElement = rootElement;
    }

    public AbstractNavigatorNode getTargetNode() {
        return this.myTargetNavigatorTreeNode;
    }

    public boolean isSelectAllTreeNodes() {
        return this.myDefaultSelectAllTreeNodes;
    }

    public void setSelectAllTreeNodes(boolean isSelected) {
        this.myDefaultSelectAllTreeNodes = isSelected;
    }

    public void clearSelectedNodes() {
        this.mySelectedNodes.clear();
    }

    public void addAllNodesToSelectedNodes(List<DefaultMutableTreeNode> nodeList) {
        this.mySelectedNodes.addAll(nodeList);
    }

    public Vector<DefaultMutableTreeNode> getNodesSelected() {
        return this.mySelectedNodes;
    }

    @Override
    public void wizardDataChanged() {
        if (this.getCurrentState() instanceof ImportWizardMigrateState) {
            this.setNextEnabled(((ImportWizardMigrateState)this.getCurrentState()).hasRequiredInformation());
        }
    }
}

