/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.nodeexport.states;

import com.ericsson.ere.exportmanager.ExportFailedException;
import com.ericsson.ere.exportmanager.NavigatorNodeExportContext;
import com.ericsson.ere.exportmanager.NavigatorNodeExportManager;
import com.ericsson.ere.gui.navigator.nodeexport.ExportWizardModel;
import com.ericsson.ere.gui.navigator.nodeexport.panels.ExportProgressPanel;
import com.ericsson.ere.gui.wizard.AbstractWizardState;
import com.ericsson.ere.gui.wizard.panels.WizardStateView;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.swing.EDT;
import java.util.Vector;
import javax.swing.SwingWorker;
import javax.swing.tree.DefaultMutableTreeNode;

public class ExportWizardProgressState
extends AbstractWizardState {
    private ExportProgressPanel myPanel;

    public ExportWizardProgressState(ExportWizardModel model) {
        super(model);
        this.createPanel();
    }

    private void createPanel() {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                ExportWizardProgressState.this.myPanel = new ExportProgressPanel();
            }
        });
    }

    @Override
    public void activate() {
        this.clearPanelsInfoText();
        this.myModel.setStandardStartNavigationButtonMode();
        SwingWorker<Void, Void> exportWorker = new SwingWorker<Void, Void>(){
            boolean success = false;

            @Override
            protected Void doInBackground() throws Exception {
                Vector<AbstractEreProxy> exportProxies = new Vector<AbstractEreProxy>();
                Vector<DefaultMutableTreeNode> selectedNodes = ((ExportWizardModel)ExportWizardProgressState.this.myModel).getNodesSelected();
                boolean isServiceNeeded = ((ExportWizardModel)ExportWizardProgressState.this.myModel).isExportRequiringService();
                exportProxies.addAll(NavigatorNodeExportManager.extractProxyVector(selectedNodes, isServiceNeeded));
                try {
                    ((ExportWizardModel)ExportWizardProgressState.this.myModel).doExport(new NavigatorNodeExportContext(exportProxies, ((ExportWizardModel)ExportWizardProgressState.this.myModel).getSelectedTargetFile(), ExportWizardProgressState.this.myPanel));
                    this.success = true;
                }
                catch (ExportFailedException eFE) {
                    ExportWizardProgressState.this.myPanel.handleExportFailure(eFE.getMessage());
                }
                return null;
            }

            @Override
            protected void done() {
                if (this.success) {
                    ExportWizardProgressState.this.myModel.setFinishedNavigationButtonMode();
                } else {
                    ExportWizardProgressState.this.setBackEnabled(true);
                }
            }
        };
        exportWorker.execute();
    }

    private void clearPanelsInfoText() {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                ExportWizardProgressState.this.myPanel.clearInfoText();
            }
        });
    }

    @Override
    public WizardStateView getPanel() {
        return this.myPanel;
    }
}

