/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.distribute;

import com.ericsson.ere.gui.navigator.distribute.AbstractEREDistributeTask;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.EreProxy;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import ericsson.ere.progress.ProgressIndicator;
import javax.swing.JPanel;
import org.w3c.dom.Element;

public class DistributedDeleteRatingPeriodTask
extends AbstractEREDistributeTask {
    private JPanel myAnalyzePanel;
    private JPanel myPerformPanel;

    public DistributedDeleteRatingPeriodTask(EreProxy ere, AbstractEreProxy source, Element sourceStructure) {
        super(ere, source, sourceStructure);
    }

    @Override
    public void analyze(ProgressIndicator progress) {
        RatingPeriodProxy sourceProxy = (RatingPeriodProxy)this.mySource;
        try {
            if (!this.isDistributionAllowed()) {
                this.myAnalyzePanel = DistributedDeleteRatingPeriodTask.getInformationPanel(this.myTargetEREProxy + " does not allow distribution", "");
                this.myAnalyzeStatus = AbstractEREDistributeTask.DistributionTaskStatus.IMPOSSIBLE;
                return;
            }
            RatingPeriodProxy targetProxy = this.getPeriod(this.myTargetEREProxy, sourceProxy.getServiceProviderName(), sourceProxy.getRatingPlanName(), sourceProxy.getName(), sourceProxy.getRatingPeriodStartTime());
            this.myAnalyzePanel = DistributedDeleteRatingPeriodTask.getInformationPanel(null, "'" + sourceProxy.getName() + "' was found on " + this.myTargetEREProxy + " and will be deleted.");
            this.myAnalyzeStatus = AbstractEREDistributeTask.DistributionTaskStatus.READY;
        }
        catch (Exception e) {
            this.myAnalyzePanel = DistributedDeleteRatingPeriodTask.getInformationPanel("'" + sourceProxy.getName() + "' cannot be deleted at " + this.myTargetEREProxy + ", ", "since " + e.getMessage());
            this.myAnalyzeStatus = AbstractEREDistributeTask.DistributionTaskStatus.IMPOSSIBLE;
        }
    }

    @Override
    public void perform(ProgressIndicator progress) {
        RatingPeriodProxy sourceProxy = (RatingPeriodProxy)this.mySource;
        try {
            RatingPeriodProxy targetProxy = this.getPeriod(this.myTargetEREProxy, sourceProxy.getServiceProviderName(), sourceProxy.getRatingPlanName(), sourceProxy.getName(), sourceProxy.getRatingPeriodStartTime());
            targetProxy.getParentRatingPlanProxy().deleteRatingPeriod(targetProxy);
            this.myPerformPanel = DistributedDeleteRatingPeriodTask.getInformationPanel(null, "'" + sourceProxy.getName() + "' has been succesfully deleted from " + this.myTargetEREProxy + ".");
            this.myPerformStatus = AbstractEREDistributeTask.DistributionTaskStatus.SUCCESS;
        }
        catch (Exception e) {
            this.myPerformPanel = DistributedDeleteRatingPeriodTask.getInformationPanel("'" + sourceProxy.getName() + "' cannot be deleted from " + this.myTargetEREProxy + ",", "since " + e.getMessage());
            this.myPerformStatus = AbstractEREDistributeTask.DistributionTaskStatus.FAILURE;
        }
    }

    @Override
    public JPanel getAnalyzePanel() {
        return this.myAnalyzePanel;
    }

    @Override
    public JPanel getPerformPanel() {
        return this.myPerformPanel;
    }

    public static String getDescription() {
        return "delete";
    }
}

