/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.actions;

import com.ericsson.ere.gui.navigator.NavigatorTree;
import com.ericsson.ere.gui.navigator.nodes.AbstractNavigatorNode;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.RatingManagerProxy;
import com.ericsson.ere.proxy.RatingPlanProxy;
import com.ericsson.ere.proxy.ServiceListProxy;
import com.ericsson.ere.proxy.ServiceProxy;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.propertieseditor.EditablePropertiesInterface;
import ericsson.ere.gui.propertieseditor.PropertiesEditor;
import ericsson.ere.gui.propertieseditor.PropertiesException;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.ere.integration.settingsmap.propertyio.VarTableInput;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.Variable;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.tree.DefaultMutableTreeNode;

public class NewServiceAction
extends AbstractAction {
    private AbstractEreProxy abstractProxy = null;
    private NavigatorTree myTreeOwner = null;

    public NewServiceAction(NavigatorTree owner) {
        super("New Service");
        this.myTreeOwner = owner;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DefaultMutableTreeNode tNode = this.myTreeOwner.getSelectedNode();
        this.abstractProxy = ((AbstractNavigatorNode)tNode).getProxy();
        RatingManagerProxy ratingManagerProxy = this.abstractProxy.getRatingManagerProxy();
        ServiceListProxy serviceListProxy = ratingManagerProxy.getServiceListProxy();
        if (this.abstractProxy instanceof ServiceListProxy || this.abstractProxy instanceof ServiceProxy) {
            VarTableModel newSettings = new VarTableModel();
            newSettings.addRow(new StringVariable("Name", ""));
            PropertiesEditor.showDialogEdit(newSettings, "New Service", new EditablePropertiesInterface(){
                private boolean successfulEdit = true;

                @Override
                public void cancel() {
                }

                @Override
                public String getTitle() {
                    return "New Service";
                }

                @Override
                public void update(VarTableModel model) throws PropertiesException {
                    this.successfulEdit = true;
                    SettingsMap newSettings = VarTableInput.readFromVarTableModel(model);
                    if (!RatingPlanProxy.validateName(newSettings.getParameterAsString("Name"))) {
                        throw new PropertiesException("The service name contains invalid characters.\nCharacters \\ / : * ? ; \" are not valid.");
                    }
                    Variable var = (Variable)model.getValueAt(0, 1);
                    if (var.getValueString() == null) {
                        this.showErrorDialog(var);
                    } else if (var.getValueString().trim().isEmpty()) {
                        this.showErrorDialog(var);
                    }
                    if (this.successfulEdit) {
                        ServiceListProxy serviceListProxy = NewServiceAction.this.abstractProxy.getRatingManagerProxy().getServiceListProxy();
                        try {
                            if (NewServiceAction.this.abstractProxy instanceof ServiceListProxy || NewServiceAction.this.abstractProxy instanceof ServiceProxy) {
                                serviceListProxy.createNewService(newSettings);
                            }
                        }
                        catch (Exception e) {
                            ExceptionUtil.handleException(e, "navigator", 1, "Could not create the new Service.", false);
                            String infoMessage = "Could not create new service";
                            infoMessage = e.getMessage() != null ? infoMessage + ":\n" + e.getMessage() : infoMessage + ".";
                            DialogFactory.getInformationDialog(GuiServiceCenter.getInstance().getMainWindow(), "Invalid input", infoMessage);
                            this.successfulEdit = false;
                        }
                    }
                }

                @Override
                public boolean isSuccessful() {
                    return this.successfulEdit;
                }

                private void showErrorDialog(Variable var) {
                    DialogFactory.getErrorDialog(GuiServiceCenter.getInstance().getMainWindow(), "Input missing", var.getLabel() + " not entered.");
                    this.successfulEdit = false;
                }
            });
        }
    }
}

