/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator;

import com.ericsson.ere.gui.navigator.NavigatorTreeNodeProperties;
import com.ericsson.ere.gui.navigator.nodes.NavigatorNodeInterface;
import com.ericsson.ere.util.HTMLUtil;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.util.StringUtil;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class NavigatorTreeRenderer
extends DefaultTreeCellRenderer {
    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
        ImageIcon myCurrentIcon;
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, focus);
        if (!(value instanceof NavigatorNodeInterface)) {
            return this;
        }
        String interruptedString = "";
        String interruptedToolTip = "";
        NavigatorNodeInterface node = (NavigatorNodeInterface)value;
        NavigatorTreeNodeProperties navTreeNodeProperties = new NavigatorTreeNodeProperties(node);
        if (navTreeNodeProperties.isRefreshAborted()) {
            interruptedString = " <b>interrupted</b>";
            interruptedToolTip = "<p>The refresh of this ERE was interrupted and the structure is therefore in an <b>unreliable</b> state.  <p>Please <b>refresh</b> it again before you make any changes to the structure.<p>";
        }
        if ((myCurrentIcon = node.getNodeIcon(expanded)) != null) {
            this.setIcon(myCurrentIcon);
        }
        String toolTipText = StringUtil.multilineTooltipWrapper(interruptedToolTip + node.getNodeToolTip());
        this.setToolTipText(toolTipText);
        String text = HTMLUtil.escape(node.toString()).replace("/", "&#x2F;");
        text = text + interruptedString;
        if (this.isDraggingOverRow(tree, row)) {
            text = "<u>" + text + "</u>";
        }
        if (RmaDefs.getInstance().getHighlightCurrentRatingPeriodSetting() && navTreeNodeProperties.isRatingPeriodCurrentlyExecuting()) {
            text = "<b>" + text + "</b>";
        }
        this.setText("<html>" + text);
        return this;
    }

    private boolean isDraggingOverRow(JTree tree, int row) {
        JTree.DropLocation dropLocation = tree.getDropLocation();
        return dropLocation != null && dropLocation.getChildIndex() == -1 && tree.getRowForPath(dropLocation.getPath()) == row;
    }

    @Deprecated
    public void setHoverOverRow(int rowForLocation) {
    }
}

