/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.multiupdate;

import com.ericsson.ere.gui.multiupdate.Status;
import com.ericsson.ere.gui.multiupdate.presenter.MultiDataUpdateFindPresenter;
import java.util.Observable;

public class MultiDataUpdateState
extends Observable {
    private static final Status RESULT_STATUS = new Status("Multi Data Update", "Use the resulting tables to view or update the selection tree configuration.", Status.SEVERITY.INFO);
    private static final Status INITIAL_STATUS = new Status("Multi Data Update", "Build search criteria to view or update the selection tree configuration.", Status.SEVERITY.TEXT);

    public void setStatus(Status status) {
        this.setChanged();
        this.notifyObservers(status);
    }

    public void setResultStatus() {
        this.setStatus(RESULT_STATUS);
    }

    public void setDefaultStatus() {
        this.setStatus(INITIAL_STATUS);
    }

    public void updateStateWithTipsOnNoHits(MultiDataUpdateFindPresenter.MDUFindFilterType type) {
        StringBuilder infoText = new StringBuilder("Possible reason: ");
        if (type == MultiDataUpdateFindPresenter.MDUFindFilterType.ALL_BASED_ON_PATH || type == MultiDataUpdateFindPresenter.MDUFindFilterType.ALL_BASED_ON_TAG) {
            infoText.append("the selection tree does not contain elements that may be updated with Multi Data Update.");
        } else if (type == MultiDataUpdateFindPresenter.MDUFindFilterType.SPECIFIC_PATHS) {
            infoText.append("faulty path format, or no matching elements were found.");
        } else if (type == MultiDataUpdateFindPresenter.MDUFindFilterType.SPECIFIC_TAGS) {
            infoText.append("faulty tag format, or no matching elements were found.");
        } else if (type == MultiDataUpdateFindPresenter.MDUFindFilterType.BASED_ON_FILE) {
            infoText.append("selected file has element data that does not match the elements in the selection tree.");
        } else {
            infoText.append("unknown.");
        }
        infoText.append(" Press F1 to access RMA User Guide and see further information regarding filters.");
        this.setStatus(new Status("Found no selection tree elements applicable for update", infoText.toString(), Status.SEVERITY.WARNING));
    }
}

