/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.multiupdate;

import com.ericsson.charging.common.StatusInterface;
import com.ericsson.ere.gui.multiupdate.MultiDataUpdateTableModel;
import com.ericsson.ere.gui.multiupdate.ObjectHolderVariable;
import com.ericsson.ere.gui.util.ExceptionUtil;
import ericsson.ere.datatype.DataType;
import ericsson.ere.gui.util.VariableFactory;
import ericsson.vareditor.variable.Variable;
import java.awt.Color;
import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class MultiDataUpdateCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    public static final Color SELECTION_BLUE = new Color(184, 207, 229);
    private static final Border EDIT_BORDER = BorderFactory.createLineBorder(Color.blue.darker(), 1);
    private Variable myEditorContainer;
    private StatusInterface myStatusHandler;

    public MultiDataUpdateCellEditor(StatusInterface statusHandler) {
        this.myStatusHandler = statusHandler;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        assert (column % 2 == 0) : "This editor should only be used for even-numbered columns.";
        TableModel model = table.getModel();
        assert (model instanceof MultiDataUpdateTableModel);
        MultiDataUpdateTableModel tm = (MultiDataUpdateTableModel)model;
        this.myEditorContainer = MultiDataUpdateCellEditor.getVariableForColumn(tm, row, column, value);
        Component ed = this.myEditorContainer.getEditor();
        if (ed instanceof JComponent) {
            ((JComponent)ed).setBorder(EDIT_BORDER);
        }
        return ed;
    }

    static Variable getVariableForColumn(MultiDataUpdateTableModel model, int row, int column, Object value) {
        Variable var;
        block6: {
            var = null;
            try {
                var = model.createVariableForCell(row, column, value);
            }
            catch (Exception e1) {
                ExceptionUtil.handleException(e1, "multidataupdate", 1, "Failed to create a variable for column " + column, false);
                DataType dt = DataType.fromClass(model.getColumnClass(column));
                if (dt == null) break block6;
                try {
                    var = VariableFactory.getVariableOfDataType(dt.getTypeName(), "", null, null, null, value);
                    if (var != null && !value.equals(var.getValueObject())) {
                        var = null;
                    }
                }
                catch (Exception e2) {
                    ExceptionUtil.handleException(e2, "multidataupdate", 1, "Failed to create a variable for data type " + dt, false);
                }
            }
        }
        if (var == null) {
            var = new ObjectHolderVariable(value);
        }
        return var;
    }

    @Override
    public Object getCellEditorValue() {
        return this.myEditorContainer.getValueObject();
    }

    @Override
    public boolean stopCellEditing() {
        boolean stop;
        boolean bl = stop = this.myEditorContainer.isValueValid() && this.getCellEditorValue() != null;
        if (this.myStatusHandler != null) {
            if (stop) {
                this.myStatusHandler.printMessage("");
            } else {
                this.myStatusHandler.beep();
                this.myStatusHandler.printMessage("The value is invalid and cannot be used.");
            }
        }
        if (stop) {
            this.myEditorContainer.editFinished();
            return super.stopCellEditing();
        }
        return false;
    }
}

