/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes;

import com.ericsson.ere.util.Transformer;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.EreClassLoader;
import ericsson.vareditor.variable.ArrayModel;
import ericsson.vareditor.variable.ArrayVariable;
import ericsson.vareditor.variable.Variable;
import java.util.List;

final class FieldNodeHelper {
    private FieldNodeHelper() {
    }

    static boolean updateArrayVariableValues(ArrayVariable variable, Transformer<Object, Object> valueTransformer) {
        boolean changed = false;
        ArrayModel model = variable.getModel();
        for (int i = model.getRowCount() - 1; i >= 0; --i) {
            Object value = model.getValueAt(i, 1);
            Object replacement = valueTransformer.transform(value);
            if (replacement == null) {
                model.removeRow(i);
                changed = true;
                continue;
            }
            if (replacement.equals(value)) continue;
            model.setValueAt(replacement, i, 1);
            changed = true;
        }
        return changed;
    }

    static boolean classIsValid(String className, boolean requireDefaultConstructor, Class<?> ... superClasses) {
        boolean valid = false;
        if (className.length() != 0) {
            try {
                Class<?> clazz = EreClassLoader.getClass(className);
                valid = requireDefaultConstructor ? FieldNodeHelper.hasDefaultConstructor(clazz) : true;
                for (Class<?> superClass : superClasses) {
                    valid &= superClass.isAssignableFrom(clazz);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return valid;
    }

    private static boolean hasDefaultConstructor(Class<?> clazz) {
        boolean hasConstructor = true;
        try {
            clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            hasConstructor = false;
        }
        return hasConstructor;
    }

    static boolean removeVariablesAfterLabel(List<Variable> varList, String label) {
        int targetSize = -1;
        for (int i = 0; i < varList.size(); ++i) {
            if (!varList.get(i).getLabel().equals(label)) continue;
            targetSize = i + 1;
            break;
        }
        boolean removed = false;
        while (targetSize >= 0 && varList.size() > targetSize) {
            varList.remove(targetSize);
            removed = true;
        }
        return removed;
    }

    static Object[] createEmptyTypedTwoDimensionalArray(DataType dt) {
        Object[] valueArray = new Object[]{new String[0], dt != null ? dt.createArray() : new Object[]{}};
        return valueArray;
    }
}

