/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes;

import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.AbstractTreeNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.FieldNode;
import com.ericsson.ere.util.CollectionUtils;
import com.ericsson.ere.util.Predicate;
import com.ericsson.ere.variable.CheckBoxListVariable;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.util.DefaultDialogFactory;
import ericsson.ere.gui.util.DialogFactoryInterface;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.TypedDropDownVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class FieldGroupNode
extends AbstractTreeNode
implements PropertyChangeListener {
    private static final String LABEL_TYPE = "Type";
    private static final String LABEL_KEY_FIELD = "Key fields";
    public static final String TAG_GROUP = "Group";
    static final String ATTR_NAME = "Name";
    public static final String ATTR_TYPE = "Type";
    public static final String ATTR_KEY_FIELD = "keyField";
    private DefaultTreeModel myModel;
    private DialogFactoryInterface myDialogFactory = new DefaultDialogFactory();
    @Deprecated
    public static final String TYPE_ARRAY_GROUP = GroupType.ARRAY_GROUP.toString();
    @Deprecated
    public static final String TYPE_MAP_GROUP = GroupType.MAP_GROUP.toString();
    private ImageIcon myClosedIcon = RmaDefs.getImageIcon("navigator_closed_folder.png");
    private ImageIcon myExpandedIcon = RmaDefs.getImageIcon("navigator_open_folder.png");
    private ImageIcon myClosedComplexTypeIcon = RmaDefs.getImageIcon("navigator_closed_complex_folder.png");
    private ImageIcon myExpandedComplexTypeIcon = RmaDefs.getImageIcon("navigator_complex_folder.png");
    private GroupType myCurrentGroupType;
    private List<String> myKeyFieldNames = new ArrayList<String>();

    public FieldGroupNode() {
        this.init("[Unnamed]", GroupType.GROUP, new String[0]);
    }

    public FieldGroupNode(NamedNodeMap attributes) {
        String name = XMLUtil.getAttributeValue(attributes, ATTR_NAME, "[Unnamed]");
        String strType = XMLUtil.getAttributeValue(attributes, "Type", GroupType.GROUP.name());
        GroupType groupType = GroupType.lookup(strType);
        String strKeyFields = XMLUtil.getAttributeValue(attributes, ATTR_KEY_FIELD, "");
        String[] keyFields = StringUtil.splitSemiColonSeparatedString(strKeyFields);
        this.init(name, groupType, keyFields);
    }

    private void init(String name, GroupType groupType, String[] keyFieldNames) {
        StringVariable nameVar = new StringVariable(ATTR_NAME, name);
        TypedDropDownVariable<GroupType> typeVar = new TypedDropDownVariable<GroupType>("Type", GroupType.values(), groupType);
        this.myKeyFieldNames = new ArrayList<String>(Arrays.asList(keyFieldNames));
        this.myCurrentGroupType = groupType;
        this.myVarList.add(nameVar);
        this.myVarList.add(typeVar);
        this.updateKeyFieldVariable();
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        if (this.getGroupType() == GroupType.MAP_GROUP) {
            AbstractTreeNode node = (AbstractTreeNode)newChild;
            node.addPropertyChangeListener(this);
        }
        super.insert(newChild, childIndex);
        this.updateKeyFieldVariable();
    }

    @Override
    public void remove(int childIndex) {
        if (this.getGroupType() == GroupType.MAP_GROUP) {
            AbstractTreeNode node = (AbstractTreeNode)this.getChildAt(childIndex);
            node.removePropertyChangeListener(this);
        }
        super.remove(childIndex);
        this.updateKeyFieldVariable();
    }

    @Override
    public void setDataItem(Object changingVariableKey, Object changingVariable) {
        super.setDataItem(changingVariableKey, changingVariable);
        if (changingVariableKey.equals("Type")) {
            GroupType newSelection = (GroupType)((Object)((Variable)changingVariable).getValueObject());
            if (newSelection != this.myCurrentGroupType) {
                if (this.getChildCount() > 0) {
                    if (this.myDialogFactory.getQuestionDialogCustomButtons(null, "Change group type", "This group contains at least one field that will be deleted if the group type is changed.\n\nDo you want to continue changing the group type?", "Yes", "No")) {
                        this.removeChildren();
                    } else {
                        ((Variable)changingVariable).setValue((Object)this.myCurrentGroupType);
                        newSelection = this.myCurrentGroupType;
                    }
                }
                if (this.myCurrentGroupType != newSelection) {
                    this.myCurrentGroupType = newSelection;
                    this.myKeyFieldNames.clear();
                    this.updateKeyFieldVariable();
                }
            }
        } else if (changingVariableKey.equals(LABEL_KEY_FIELD)) {
            this.updateKeyFieldNames();
        }
    }

    private void updateKeyFieldNames() {
        Variable var = VarListUtil.getVariableForName(this.myVarList, LABEL_KEY_FIELD);
        List fields = (List)var.getValueObject();
        this.myKeyFieldNames.clear();
        for (AbstractTreeNode field : fields) {
            this.myKeyFieldNames.add(field.getName());
        }
    }

    private void removeChildren() {
        if (this.myModel != null) {
            while (this.getChildCount() > 0) {
                this.myModel.removeNodeFromParent((MutableTreeNode)this.getChildAt(0));
            }
        }
    }

    private void updateKeyFieldVariable(Collection<AbstractTreeNode> keyFieldCandidates) {
        VarListUtil.removeVariablesByLabel((List<Variable>)this.myVarList, LABEL_KEY_FIELD);
        if (this.getGroupType() == GroupType.MAP_GROUP) {
            Variable keyFieldVar = this.createKeyFieldsVariable(keyFieldCandidates);
            this.myVarList.add(keyFieldVar);
        }
    }

    private Variable createKeyFieldsVariable(Collection<AbstractTreeNode> keyFieldCandidates) {
        AbstractTreeNode[] selected;
        AbstractTreeNode[] items;
        if (keyFieldCandidates.isEmpty()) {
            items = new AbstractTreeNode[]{};
            selected = null;
        } else {
            ArrayList<AbstractTreeNode> selectedKeyFields = new ArrayList<AbstractTreeNode>(CollectionUtils.filter(keyFieldCandidates, new IsKeyFieldPredicate()));
            selected = selectedKeyFields.toArray(new AbstractTreeNode[selectedKeyFields.size()]);
            items = keyFieldCandidates.toArray(new AbstractTreeNode[keyFieldCandidates.size()]);
        }
        CheckBoxListVariable<AbstractTreeNode> keyFieldVar = new CheckBoxListVariable<AbstractTreeNode>(LABEL_KEY_FIELD, items, selected, new NodeNameLabeler(), true, true);
        return keyFieldVar;
    }

    @Override
    protected Element createConfigurationElement(Document doc) {
        String keyFields = StringUtil.join(this.myKeyFieldNames.toArray(), ";");
        Element e = doc.createElement(TAG_GROUP);
        e.setAttribute(ATTR_NAME, this.getName());
        e.setAttribute("Type", this.getGroupType().toString());
        if (!StringUtil.isEmptyString(keyFields)) {
            e.setAttribute(ATTR_KEY_FIELD, keyFields);
        }
        return e;
    }

    @Override
    public boolean isNodeValid() {
        boolean valid = super.isNodeValid();
        if (valid && this.isComplexGroup() && this.getChildCount() == 0) {
            valid = false;
        }
        return valid;
    }

    @Override
    public void setTreeModel(DefaultTreeModel theModel) {
        super.setTreeModel(theModel);
        this.myModel = theModel;
    }

    @Override
    public ImageIcon getNodeIcon(boolean expanded) {
        if (this.isComplexGroup()) {
            return expanded ? this.myExpandedComplexTypeIcon : this.myClosedComplexTypeIcon;
        }
        return expanded ? this.myExpandedIcon : this.myClosedIcon;
    }

    @Override
    public String getName() {
        return VarListUtil.getValueStringForName(this.myVarList, ATTR_NAME);
    }

    @Deprecated
    public boolean isArrayGroup() {
        return this.getGroupType() == GroupType.ARRAY_GROUP;
    }

    public boolean isComplexGroup() {
        return this.getGroupType().isComplex();
    }

    public GroupType getGroupType() {
        return this.myCurrentGroupType;
    }

    @Override
    public String getInvalidReason() {
        String reason = super.getInvalidReason();
        if (this.isComplexGroup() && this.getChildCount() == 0) {
            if (!reason.isEmpty()) {
                reason = "<html>" + reason + "<br/>";
            }
            reason = reason + "This group is complex but does not have any fields.";
        }
        return reason;
    }

    private void updateKeyFieldVariable() {
        Vector children = this.children != null ? this.children : Collections.emptyList();
        Collection<AbstractTreeNode> keyFieldCandidates = CollectionUtils.filter(children, new IsValidKeyPredicate());
        this.updateKeyFieldVariable(keyFieldCandidates);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.myKeyFieldNames.remove(evt.getOldValue())) {
            this.myKeyFieldNames.add((String)evt.getNewValue());
        }
        this.updateKeyFieldVariable();
        this.updateKeyFieldNames();
    }

    @Override
    public String toString() {
        String keyFields = null;
        String keyFieldsString = VarListUtil.getValueStringForName(this.myVarList, LABEL_KEY_FIELD);
        if (keyFieldsString != null) {
            Object[] names = StringUtil.splitSemiColonSeparatedString(keyFieldsString);
            keyFields = names.length == 0 || names.length == 1 && "".equals(names[0]) ? "no key fields" : "key fields: " + StringUtil.join(names, ", ");
        }
        String ret = super.toString();
        if (keyFields != null) {
            ret = ret + " (" + keyFields + ")";
        }
        return ret;
    }

    public List<AbstractTreeNode> getKeyFieldChildren() {
        Variable keyFieldsVariable = VarListUtil.getVariableForName(this.myVarList, LABEL_KEY_FIELD);
        return keyFieldsVariable != null ? (List)keyFieldsVariable.getValueObject() : Collections.emptyList();
    }

    public void setDialogFactory(DialogFactoryInterface factory) {
        this.myDialogFactory = factory;
    }

    static class NodeNameLabeler
    implements TypedDropDownVariable.ItemLabeler<AbstractTreeNode> {
        NodeNameLabeler() {
        }

        @Override
        public String getDisplayStringFor(AbstractTreeNode object, int index) {
            return object.getName();
        }
    }

    private static class IsValidKeyPredicate
    implements Predicate<AbstractTreeNode> {
        private static List<String> VALID_PARAM_TYPES = Arrays.asList("IN", "OUT", "VARIABLE", "VIRTUAL");

        private IsValidKeyPredicate() {
        }

        @Override
        public boolean test(AbstractTreeNode treeNode) {
            boolean validNode = false;
            if (treeNode instanceof FieldNode) {
                String pt = ((FieldNode)treeNode).getParameterType();
                validNode = VALID_PARAM_TYPES.contains(pt);
            }
            return validNode;
        }
    }

    private class IsKeyFieldPredicate
    implements Predicate<AbstractTreeNode> {
        private IsKeyFieldPredicate() {
        }

        @Override
        public boolean test(AbstractTreeNode node) {
            return FieldGroupNode.this.myKeyFieldNames.contains(node.getName());
        }
    }

    public static enum GroupType {
        GROUP("Group"),
        ARRAY_GROUP("Array group"),
        MAP_GROUP("Map group");

        private String myTypeName;

        private GroupType(String typeName) {
            this.myTypeName = typeName;
        }

        public static GroupType lookup(String name) {
            for (GroupType gt : GroupType.values()) {
                if (!gt.myTypeName.equalsIgnoreCase(name)) continue;
                return gt;
            }
            return null;
        }

        public boolean isComplex() {
            return this != GROUP;
        }

        public String toString() {
            return this.myTypeName;
        }
    }
}

