/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts;

import com.ericsson.ere.gui.editors.serviceeditor.NameRepositories;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.ContextDefinitionTreeModel;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.FieldsDefinitionTreeModel;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.AbstractTreeNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.CommonFieldsGroupNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.ContextFieldsGroupNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.ContextTopNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.FieldGroupNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.FieldTopNode;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.PluginsTreeModel;
import com.ericsson.ere.proxy.ServiceProxy;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import java.util.List;
import javax.swing.tree.TreePath;
import org.w3c.dom.Element;

public class FieldsAndContextDefinitionTreeBuilder {
    private Element myDefinition;
    private ServiceProxy myServiceProxy;

    public FieldsAndContextDefinitionTreeBuilder(Element definition, ServiceProxy serviceProxy) {
        this.myServiceProxy = serviceProxy;
        this.myDefinition = definition;
    }

    public FieldsDefinitionTreeModel buildFieldsModel(NameRepositories repositories, PluginsTreeModel pluginsModel) {
        Element contextFieldsNode;
        Element contextDefNode;
        AbstractTreeNode top = this.createFieldsTopNode();
        FieldsDefinitionTreeModel model = new FieldsDefinitionTreeModel(top, repositories, pluginsModel);
        model.setAddChildOrderEnabled(false);
        Element fieldsNode = XMLUtil.getNamedElement("Fields", this.myDefinition.getChildNodes());
        CommonFieldsGroupNode commonFieldsTop = model.addNewCommonFieldsGroupNode();
        ContextFieldsGroupNode contextFieldsTop = model.addNewContextFieldsGroupNode();
        if (fieldsNode != null) {
            this.addFieldNodes(model, new TreePath(commonFieldsTop.getPath()), XMLUtil.getElementChildList(fieldsNode), FieldGroupNode.GroupType.GROUP);
        }
        if ((contextDefNode = XMLUtil.getNamedElement("ContextDefinition", this.myDefinition.getChildNodes())) != null && (contextFieldsNode = XMLUtil.getNamedElement("Fields", contextDefNode.getChildNodes())) != null) {
            this.addFieldNodes(model, new TreePath(contextFieldsTop.getPath()), XMLUtil.getElementChildList(contextFieldsNode), FieldGroupNode.GroupType.GROUP);
        }
        model.setAddChildOrderEnabled(true);
        return model;
    }

    private AbstractTreeNode createFieldsTopNode() {
        return new FieldTopNode(this.myServiceProxy, this.myDefinition);
    }

    public ContextDefinitionTreeModel buildContextModel(NameRepositories repositories, FieldsDefinitionTreeModel fieldsModel) {
        Element topNodeElement = XMLUtil.getNamedElement("ContextDefinition", this.myDefinition.getChildNodes());
        ContextTopNode top = topNodeElement != null ? new ContextTopNode(topNodeElement.getAttributes()) : new ContextTopNode();
        ContextDefinitionTreeModel model = new ContextDefinitionTreeModel(top, repositories, fieldsModel);
        model.setAddChildOrderEnabled(false);
        if (topNodeElement != null) {
            this.addContextNodes(model, new TreePath(top), XMLUtil.getElementNodesNamed("Context", topNodeElement.getChildNodes()));
        }
        model.setAddChildOrderEnabled(true);
        return model;
    }

    private void addFieldNodes(FieldsDefinitionTreeModel model, TreePath parentPath, List<Element> elementList, FieldGroupNode.GroupType parentGroupType) {
        for (Element treeNodeElement : elementList) {
            String tagName = treeNodeElement.getTagName();
            FieldGroupNode.GroupType newParentGroupType = parentGroupType;
            AbstractTreeNode newNode = null;
            if ("Group".equals(tagName)) {
                newNode = model.addNewFieldGroupNode(parentPath, treeNodeElement);
                newParentGroupType = newNode.getGroupType();
            } else if ("Condition".equals(tagName)) {
                newNode = model.addNewFieldConditionNode(parentPath, treeNodeElement);
            } else if ("Field".equals(tagName)) {
                newNode = model.addNewFieldNode(parentGroupType, parentPath, treeNodeElement);
            } else if ("FieldStructure".equals(tagName)) {
                newNode = model.addNewHierarchicalFieldNode(parentPath, treeNodeElement);
            }
            if (newNode == null) continue;
            this.addFieldNodes(model, parentPath.pathByAddingChild(newNode), XMLUtil.getElementChildList(treeNodeElement), newParentGroupType);
        }
    }

    private void addContextNodes(ContextDefinitionTreeModel model, TreePath parentPath, List<Element> aList) {
        for (Element currentElement : aList) {
            String tagName = currentElement.getTagName();
            AbstractTreeNode newNode = null;
            if ("Context".equals(tagName)) {
                newNode = model.addNewContextNode(parentPath, currentElement);
            } else if ("Group".equals(tagName)) {
                String type = currentElement.getAttribute("Type");
                if (StringUtil.isEmptyString(type)) {
                    newNode = model.addNewContextGroupNode(parentPath, currentElement);
                } else {
                    model.addNewFieldGroupLinkNode(parentPath, currentElement);
                }
            } else if ("Field".equals(tagName)) {
                newNode = model.addNewFieldLinkNode(parentPath, currentElement);
            } else if ("FieldStructure".equals(tagName)) {
                newNode = model.addNewHierarchicalFieldLinkNode(parentPath, currentElement);
            }
            if (newNode == null) continue;
            this.addContextNodes(model, parentPath.pathByAddingChild(newNode), XMLUtil.getElementChildList(currentElement));
        }
    }
}

