/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.datarepository;

import com.ericsson.ere.defs.DataRepositoryModel;
import com.ericsson.ere.gui.editors.serviceeditor.datarepository.DataRepositoryEditPanel;
import com.ericsson.ere.gui.editors.serviceeditor.datarepository.DataRepositoryEditPresenter;
import com.ericsson.ere.gui.editors.serviceeditor.datarepository.DataRepositoryListPanel;
import com.ericsson.ere.gui.editors.serviceeditor.datarepository.DataRepositoryListPresenter;
import com.ericsson.ere.gui.editors.serviceeditor.datarepository.DataRepositorySortedListModelImpl;
import ericsson.ere.defs.ClassRepository;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.w3c.dom.Element;

public class DataRepositoryEditor
extends JPanel {
    private ClassRepository myClassRepository;
    private DataRepositoryModel myDataRepositoryModel;
    private DataRepositoryEditPanel myEditView;

    public DataRepositoryEditor(ClassRepository classRepository, DataRepositoryModel dataModel) {
        this.myClassRepository = classRepository;
        this.myDataRepositoryModel = dataModel;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        DataRepositorySortedListModelImpl listModel = new DataRepositorySortedListModelImpl(this.myDataRepositoryModel);
        DataRepositoryListPanel listView = new DataRepositoryListPanel(listModel);
        this.myEditView = new DataRepositoryEditPanel();
        new DataRepositoryListPresenter(listView, this.myEditView, listModel);
        new DataRepositoryEditPresenter(this.myEditView, listView, listModel, this.myClassRepository);
        JSplitPane splitPane = new JSplitPane(1, listView, this.myEditView);
        splitPane.setDividerSize(8);
        splitPane.setDividerLocation(200);
        this.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 0.5, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setVisible(true);
    }

    public boolean isModified() {
        return this.myDataRepositoryModel.isModified() || !this.myEditView.isCommitted();
    }

    public boolean isCommitted() {
        return this.myEditView.isCommitted();
    }

    public void resetModified() {
        this.myDataRepositoryModel.resetModified();
    }

    public Element getRepositoryElement() {
        return this.myDataRepositoryModel.getRepositoryElement();
    }
}

