/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.constraint.gui;

import com.ericsson.ere.constraint.ConstraintService;
import com.ericsson.ere.constraint.entity.Constraint;
import com.ericsson.ere.constraint.entity.ConstraintTarget;
import com.ericsson.ere.gui.editors.serviceeditor.constraint.gui.FieldConstraintDialogDataSource;
import com.ericsson.ere.gui.editors.serviceeditor.constraint.gui.FieldConstraintTableModel;
import com.ericsson.ere.gui.editors.serviceeditor.constraint.gui.PluginConstraintGUIBuilder;
import com.ericsson.ere.gui.editors.serviceeditor.constraint.gui.actions.ConstraintActionHandler;
import com.ericsson.ere.gui.editors.serviceeditor.constraint.gui.actions.ConstraintActionHandlerImpl;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.management.Service;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;

public class FieldConstraintGUIBuilder
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ConstraintActionHandler myActionHandler;
    private JTable myFieldConstraintTable;
    private JTable myConstraintDetailsTable;
    private FieldConstraintTableModel myFieldConstraintTableModel;
    private DefaultTableModel myConstraintDetailsTableModel;
    private DeleteAction myDeleteAction = null;
    private AddAction myAddAction = null;
    private EditAction myEditAction = null;
    private Service myService;

    public FieldConstraintGUIBuilder(FieldConstraintTableModel model, Service service) {
        this.myFieldConstraintTableModel = model;
        this.myService = service;
        this.myActionHandler = new ConstraintActionHandlerImpl(model.getConstraintModel(), service);
        this.buildComponents();
    }

    private void buildComponents() {
        this.setLayout(new GridBagLayout());
        this.buildFieldConstraintTable();
        this.buildConstraintDetailsTable();
        this.setVisible(true);
    }

    private void buildFieldConstraintTable() {
        JPanel fieldConstraintPanel = new JPanel();
        fieldConstraintPanel.setLayout(new GridBagLayout());
        this.myFieldConstraintTable = new JTable(this.myFieldConstraintTableModel){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int x, int y) {
                return false;
            }
        };
        this.myFieldConstraintTable.setSelectionMode(0);
        this.myFieldConstraintTable.getColumnModel().getColumn(0).setHeaderValue("Field Constraints");
        this.myFieldConstraintTable.getTableHeader().setReorderingAllowed(false);
        this.myFieldConstraintTable.getSelectionModel().addListSelectionListener(new ConstraintValueChangedListener());
        this.myFieldConstraintTable.setRowSorter(new TableRowSorter<FieldConstraintTableModel>(this.myFieldConstraintTableModel));
        this.myFieldConstraintTable.setName("FieldConstraintTable");
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel renderer = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                renderer.setToolTipText(null);
                Constraint con = (Constraint)value;
                if (con.getTarget().isAll()) {
                    renderer.setText("All fields");
                    renderer.setIcon(null);
                } else if (!ConstraintService.doesFieldConstraintExistInService(con, FieldConstraintGUIBuilder.this.myService)) {
                    renderer.setIcon(RmaDefs.getImageIcon("warning16.png"));
                    renderer.setToolTipText("The field '" + con.getTarget().getTargetValue() + "' does not exist in the service");
                    renderer.setText(((Constraint)value).getTarget().getTargetValue());
                } else {
                    renderer.setIcon(null);
                    renderer.setText(((Constraint)value).getTarget().getTargetValue());
                }
                return renderer;
            }
        };
        this.myFieldConstraintTable.getColumnModel().getColumn(0).setCellRenderer(renderer);
        this.myFieldConstraintTable.setGridColor(Color.WHITE);
        this.myFieldConstraintTable.setFillsViewportHeight(true);
        JScrollPane fieldConstraintScrollPane = new JScrollPane(this.myFieldConstraintTable);
        fieldConstraintPanel.add((Component)fieldConstraintScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 10), 0, 0));
        this.add((Component)fieldConstraintPanel, new GridBagConstraints(0, 0, 1, 1, 0.3, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void buildConstraintDetailsTable() {
        JToolBar buttonToolbar = new JToolBar();
        buttonToolbar.setFloatable(false);
        this.setUpAddAction(buttonToolbar);
        this.setUpEditAction(buttonToolbar);
        this.setUpDeleteAction(buttonToolbar);
        this.add((Component)buttonToolbar, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 10), 0, 0));
        JPanel editConstraintPanel = new JPanel();
        editConstraintPanel.setLayout(new GridBagLayout());
        this.myConstraintDetailsTableModel = new DefaultTableModel(0, 1);
        this.setUpConstraintDetailsTable();
        JScrollPane settingsScroll = new JScrollPane(this.myConstraintDetailsTable);
        editConstraintPanel.add((Component)settingsScroll, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 10, 5, 5), 1, 1));
        this.add((Component)editConstraintPanel, new GridBagConstraints(1, 0, 1, 2, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void setUpConstraintDetailsTable() {
        this.myConstraintDetailsTable = new JTable(this.myConstraintDetailsTableModel){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int x, int y) {
                return false;
            }
        };
        this.myConstraintDetailsTable.getSelectionModel().addListSelectionListener(new ConstraintDetailValueChangedListener());
        this.myConstraintDetailsTable.setSelectionMode(2);
        this.myConstraintDetailsTable.getColumnModel().getColumn(0).setHeaderValue("Constraints");
        this.myConstraintDetailsTable.setGridColor(Color.WHITE);
        this.myConstraintDetailsTable.getTableHeader().setReorderingAllowed(false);
        this.myConstraintDetailsTable.setName("FieldConstraintDetailsTable");
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel renderer = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                renderer.setToolTipText(value.toString());
                Constraint constraint = (Constraint)value;
                if (constraint.getTarget().isAll()) {
                    Font oldFont = renderer.getFont();
                    Font italic = new Font(oldFont.getName(), 2, oldFont.getSize());
                    renderer.setFont(italic);
                }
                return renderer;
            }
        };
        this.myConstraintDetailsTable.getColumnModel().getColumn(0).setCellRenderer(renderer);
    }

    private void setUpEditAction(JToolBar panel) {
        JButton editButton = new JButton();
        editButton.setName("FieldConstraintEditButton");
        this.myEditAction = new EditAction(RmaDefs.getImageIcon("new_edit.gif"), "Edit settings for constraint");
        this.myEditAction.setEnabled(false);
        editButton.setAction(this.myEditAction);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 128), "enter");
        this.getActionMap().put("enter", this.myEditAction);
        panel.add(editButton);
    }

    private void setUpDeleteAction(JToolBar panel) {
        JButton deleteButton = new JButton();
        deleteButton.setName("FieldConstraintDeleteButton");
        this.myDeleteAction = new DeleteAction(RmaDefs.getImageIcon("new_delete.gif"), "Deletes the selected constraint(s)");
        this.myDeleteAction.setEnabled(false);
        deleteButton.setAction(this.myDeleteAction);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.getActionMap().put("delete", this.myDeleteAction);
        panel.add(deleteButton);
    }

    private void setUpAddAction(JToolBar panel) {
        JButton addButton = new JButton();
        addButton.setName("FieldConstraintAddButton");
        this.myAddAction = new AddAction(RmaDefs.getImageIcon("new_add.gif"), "Add a new constraint");
        addButton.setAction(this.myAddAction);
        panel.add(addButton);
    }

    private void clearConstraintTableValues() {
        this.myConstraintDetailsTableModel.getDataVector().clear();
        this.myConstraintDetailsTableModel.fireTableDataChanged();
        this.myConstraintDetailsTable.getColumnModel().getColumn(0).setHeaderValue("Constraints");
        this.myConstraintDetailsTable.getTableHeader().repaint();
    }

    protected void setFirstRowSelected() {
        if (this.myFieldConstraintTable.getRowCount() > 0) {
            this.myFieldConstraintTable.setRowSelectionInterval(0, 0);
        } else {
            this.clearConstraintTableValues();
        }
        if (this.myConstraintDetailsTable.getRowCount() > 0) {
            this.myConstraintDetailsTable.setRowSelectionInterval(0, 0);
        }
    }

    private int findRowForTargetInTable(Object object) {
        int row = -1;
        for (int i = 0; i < this.myFieldConstraintTable.getRowCount() && row < 0; ++i) {
            Constraint con = (Constraint)this.myFieldConstraintTable.getValueAt(i, 0);
            if (!con.getTarget().getTargetValue().equals(object)) continue;
            row = i;
        }
        return row;
    }

    private class ConstraintValueChangedListener
    implements ListSelectionListener {
        private ConstraintValueChangedListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int selectedRow = FieldConstraintGUIBuilder.this.myFieldConstraintTable.getSelectedRow();
            if (FieldConstraintGUIBuilder.this.myFieldConstraintTable.getRowCount() > 0 && selectedRow != -1) {
                Constraint selectedConstraint = (Constraint)FieldConstraintGUIBuilder.this.myFieldConstraintTable.getValueAt(selectedRow, 0);
                FieldConstraintGUIBuilder.this.clearConstraintTableValues();
                List<Constraint> fieldConstraints = FieldConstraintGUIBuilder.this.myFieldConstraintTableModel.getConstraintModel().getFieldConstraintsFromName(selectedConstraint.getTarget().getTargetValue());
                for (Constraint con : fieldConstraints) {
                    FieldConstraintGUIBuilder.this.myConstraintDetailsTableModel.addRow(new Vector<Constraint>(Arrays.asList(con)));
                }
                if (FieldConstraintGUIBuilder.this.myConstraintDetailsTable.getRowCount() > 0) {
                    FieldConstraintGUIBuilder.this.myConstraintDetailsTable.setRowSelectionInterval(0, 0);
                    ConstraintTarget targetField = selectedConstraint.getTarget();
                    String fieldName = targetField.isAll() ? "Constraints for 'All fields'" : "Constraints for field '" + targetField.getTargetValue() + "'";
                    FieldConstraintGUIBuilder.this.myConstraintDetailsTable.getColumnModel().getColumn(0).setHeaderValue(fieldName);
                    FieldConstraintGUIBuilder.this.myConstraintDetailsTable.getTableHeader().repaint();
                }
            }
        }
    }

    private class ConstraintDetailValueChangedListener
    implements ListSelectionListener {
        private ConstraintDetailValueChangedListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int numberOfSelectedConstraints = FieldConstraintGUIBuilder.this.myConstraintDetailsTable.getSelectedRows().length;
            if (numberOfSelectedConstraints > 1) {
                FieldConstraintGUIBuilder.this.myEditAction.setEnabled(false);
            } else if (numberOfSelectedConstraints == 0) {
                FieldConstraintGUIBuilder.this.myEditAction.setEnabled(false);
                FieldConstraintGUIBuilder.this.myDeleteAction.setEnabled(false);
            } else {
                FieldConstraintGUIBuilder.this.myEditAction.setEnabled(true);
                FieldConstraintGUIBuilder.this.myDeleteAction.setEnabled(true);
            }
            int selectedRow = FieldConstraintGUIBuilder.this.myConstraintDetailsTable.getSelectedRow();
            Constraint selectedConstraint = null;
            if (selectedRow != -1) {
                selectedConstraint = (Constraint)FieldConstraintGUIBuilder.this.myConstraintDetailsTable.getValueAt(selectedRow, 0);
            }
            if (selectedConstraint != null) {
                if (selectedConstraint.getTarget().isAll()) {
                    Constraint selectedFieldConstraint = (Constraint)FieldConstraintGUIBuilder.this.myFieldConstraintTable.getValueAt(FieldConstraintGUIBuilder.this.myFieldConstraintTable.getSelectedRow(), 0);
                    if (numberOfSelectedConstraints == 1 && !selectedFieldConstraint.getTarget().isAll()) {
                        FieldConstraintGUIBuilder.this.myDeleteAction.setEnabled(false);
                    }
                } else {
                    FieldConstraintGUIBuilder.this.myDeleteAction.setEnabled(true);
                }
            }
        }
    }

    class EditAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public EditAction(ImageIcon icon, String desc) {
            super("", icon);
            this.putValue("ShortDescription", desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedConstraintRow = FieldConstraintGUIBuilder.this.myFieldConstraintTable.getSelectedRow();
            int selectedDetailsRow = FieldConstraintGUIBuilder.this.myConstraintDetailsTable.getSelectedRow();
            if (selectedDetailsRow > -1) {
                Constraint selectedConstraint = (Constraint)FieldConstraintGUIBuilder.this.myConstraintDetailsTable.getValueAt(FieldConstraintGUIBuilder.this.myConstraintDetailsTable.getSelectedRow(), 0);
                Constraint resultingConstraint = FieldConstraintGUIBuilder.this.myActionHandler.showConstraintSettingDialog(selectedConstraint, new FieldConstraintDialogDataSource());
                if (resultingConstraint != null) {
                    int row = PluginConstraintGUIBuilder.findRowInTableModel(FieldConstraintGUIBuilder.this.myConstraintDetailsTableModel, resultingConstraint, 0);
                    selectedDetailsRow = row >= 0 ? row : 0;
                    row = FieldConstraintGUIBuilder.this.findRowForTargetInTable(resultingConstraint);
                    selectedConstraintRow = row >= 0 ? row : 0;
                }
                if (FieldConstraintGUIBuilder.this.myFieldConstraintTable.getRowCount() > 0) {
                    FieldConstraintGUIBuilder.this.myFieldConstraintTable.setRowSelectionInterval(selectedConstraintRow, selectedConstraintRow);
                    FieldConstraintGUIBuilder.this.myConstraintDetailsTable.setRowSelectionInterval(selectedDetailsRow, selectedDetailsRow);
                } else {
                    FieldConstraintGUIBuilder.this.clearConstraintTableValues();
                }
            }
        }
    }

    class AddAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AddAction(ImageIcon icon, String desc) {
            super("", icon);
            this.putValue("ShortDescription", desc);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Constraint resultingConstraint = FieldConstraintGUIBuilder.this.myActionHandler.showAddConstraintDialog(new FieldConstraintDialogDataSource());
            int constraintTargetFieldRowToSelect = FieldConstraintGUIBuilder.this.myFieldConstraintTable.getSelectedRow();
            int constraintRowToSelect = 0;
            if (constraintTargetFieldRowToSelect == -1) {
                constraintTargetFieldRowToSelect = 0;
            }
            int row = -1;
            if (resultingConstraint != null) {
                String selectedFieldTarget = resultingConstraint.getTarget().getTargetValue();
                row = FieldConstraintGUIBuilder.this.findRowForTargetInTable(selectedFieldTarget);
                if (row >= 0) {
                    constraintTargetFieldRowToSelect = row;
                }
                if (FieldConstraintGUIBuilder.this.myFieldConstraintTable.getRowCount() > 0) {
                    FieldConstraintGUIBuilder.this.myFieldConstraintTable.setRowSelectionInterval(constraintTargetFieldRowToSelect, constraintTargetFieldRowToSelect);
                    row = PluginConstraintGUIBuilder.findRowInTableModel(FieldConstraintGUIBuilder.this.myConstraintDetailsTableModel, resultingConstraint, 0);
                    if (row >= 0) {
                        constraintRowToSelect = row;
                    }
                    FieldConstraintGUIBuilder.this.myConstraintDetailsTable.setRowSelectionInterval(constraintRowToSelect, constraintRowToSelect);
                }
            }
        }
    }

    class DeleteAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public DeleteAction(ImageIcon icon, String desc) {
            super("", icon);
            this.putValue("ShortDescription", desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedConstraintRow = FieldConstraintGUIBuilder.this.myFieldConstraintTable.getSelectedRow();
            int selectedDetailConstraintRow = FieldConstraintGUIBuilder.this.myConstraintDetailsTable.getSelectedRow();
            int[] rows = FieldConstraintGUIBuilder.this.myConstraintDetailsTable.getSelectedRows();
            Constraint con = null;
            boolean delete = DialogFactory.getQuestionDialog(GuiServiceCenter.getInstance().getMainWindow(), "Remove Constraint", "Are you sure you want to delete the selected constraint(s)?");
            Constraint fieldSelectionConstraint = null;
            if (delete) {
                fieldSelectionConstraint = (Constraint)FieldConstraintGUIBuilder.this.myFieldConstraintTable.getValueAt(FieldConstraintGUIBuilder.this.myFieldConstraintTable.getSelectedRow(), 0);
                int constraintsDeleted = 0;
                int selectedConstraints = rows.length;
                for (int i = 0; i < selectedConstraints; ++i) {
                    con = (Constraint)FieldConstraintGUIBuilder.this.myConstraintDetailsTable.getValueAt(rows[i], 0);
                    if (fieldSelectionConstraint.getTarget().isAll()) {
                        FieldConstraintGUIBuilder.this.myActionHandler.deleteConstraint(con);
                        continue;
                    }
                    if (con.getTarget().isAll()) continue;
                    FieldConstraintGUIBuilder.this.myActionHandler.deleteConstraint(con);
                    ++constraintsDeleted;
                }
                if (constraintsDeleted != selectedConstraints && !fieldSelectionConstraint.getTarget().isAll()) {
                    DialogFactory.getInformationDialog(GuiServiceCenter.getInstance().getMainWindow(), "Constraints deleted", "Did not delete general constraints");
                }
                int rowCount = FieldConstraintGUIBuilder.this.myFieldConstraintTable.getRowCount();
                int detailRowCount = FieldConstraintGUIBuilder.this.myConstraintDetailsTable.getRowCount();
                if (rowCount > 0 && detailRowCount > 1) {
                    if (selectedConstraintRow < rowCount) {
                        FieldConstraintGUIBuilder.this.myFieldConstraintTable.setRowSelectionInterval(selectedConstraintRow, selectedConstraintRow);
                    } else if (selectedConstraintRow == rowCount) {
                        FieldConstraintGUIBuilder.this.myFieldConstraintTable.setRowSelectionInterval(selectedConstraintRow - 1, selectedConstraintRow - 1);
                    } else {
                        FieldConstraintGUIBuilder.this.myFieldConstraintTable.setRowSelectionInterval(0, 0);
                    }
                    if (selectedDetailConstraintRow == detailRowCount - 1) {
                        FieldConstraintGUIBuilder.this.myConstraintDetailsTable.setRowSelectionInterval(selectedDetailConstraintRow - 1, selectedDetailConstraintRow - 1);
                    } else {
                        FieldConstraintGUIBuilder.this.myConstraintDetailsTable.setRowSelectionInterval(0, 0);
                    }
                } else {
                    FieldConstraintGUIBuilder.this.clearConstraintTableValues();
                    if (FieldConstraintGUIBuilder.this.myFieldConstraintTable.getRowCount() > 0) {
                        if (selectedConstraintRow == FieldConstraintGUIBuilder.this.myFieldConstraintTable.getRowCount()) {
                            FieldConstraintGUIBuilder.this.myFieldConstraintTable.setRowSelectionInterval(selectedConstraintRow - 1, selectedConstraintRow - 1);
                        } else {
                            FieldConstraintGUIBuilder.this.myFieldConstraintTable.setRowSelectionInterval(selectedConstraintRow, selectedConstraintRow);
                        }
                    }
                }
            }
        }
    }
}

