/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor;

import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.AbstractTreeNode;
import com.ericsson.ere.swing.TreeModelAdapter;
import com.ericsson.ere.util.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class ServiceEditorTreeModel
extends DefaultTreeModel {
    public ServiceEditorTreeModel(TreeNode root) {
        super(root);
    }

    @Override
    public void removeNodeFromParent(MutableTreeNode node) {
        this.removeNodeFromParent((AbstractTreeNode)node, false);
    }

    private void removeNodeFromParent(AbstractTreeNode node, boolean removeLinkTargetsAndTheirReferers) {
        List<AbstractTreeNode> linkTargets = this.findLinkTargets(node);
        this.removeNodeFromParent(node, linkTargets, removeLinkTargetsAndTheirReferers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNodeFromParent(AbstractTreeNode node, Collection<AbstractTreeNode> linkTargets, boolean removeLinkTargetsAndTheirReferers) {
        if (linkTargets.size() > 0) {
            if (removeLinkTargetsAndTheirReferers) {
                Collection<AbstractTreeNode> allReferers = this.getAllReferers(linkTargets);
                for (AbstractTreeNode ref : allReferers) {
                    DefaultTreeModel model = ref.getTreeModel();
                    model.removeNodeFromParent(ref);
                }
            } else {
                throw new RemovalOfLinkTargetsNotPermittedException("There are link targets in the sub tree to remove.", node, linkTargets);
            }
        }
        NodeChangedDuringNodeRemovalListener listener = new NodeChangedDuringNodeRemovalListener(node.getParent());
        try {
            super.removeNodeFromParent(node);
        }
        finally {
            listener.remove();
        }
    }

    private Collection<AbstractTreeNode> getAllReferers(Collection<AbstractTreeNode> linkTargets) {
        ArrayList<AbstractTreeNode> refs = new ArrayList<AbstractTreeNode>();
        for (AbstractTreeNode target : linkTargets) {
            refs.addAll(target.getReferrers());
        }
        return refs;
    }

    private List<AbstractTreeNode> findLinkTargets(TreeNode node) {
        return this.findNodes((AbstractTreeNode)node, new HasReferersPredicate());
    }

    public List<AbstractTreeNode> findNodes(Predicate<AbstractTreeNode> matcher) {
        AbstractTreeNode root = (AbstractTreeNode)this.getRoot();
        return this.findNodes(root, matcher);
    }

    private List<AbstractTreeNode> findNodes(AbstractTreeNode root, Predicate<AbstractTreeNode> matcher) {
        ArrayList<AbstractTreeNode> list = new ArrayList<AbstractTreeNode>();
        this.findNodes(root, matcher, list);
        return list;
    }

    public <T extends AbstractTreeNode> List<T> findNodesOfType(final Class<T> type) {
        AbstractTreeNode root = (AbstractTreeNode)this.getRoot();
        ArrayList list = new ArrayList();
        this.findNodes(root, new Predicate<T>(){

            @Override
            public boolean test(T node) {
                return node.getClass() == type;
            }
        }, list);
        return list;
    }

    private <T extends AbstractTreeNode> void findNodes(T node, Predicate<T> matcher, List<T> list) {
        if (matcher.test(node)) {
            list.add(node);
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            AbstractTreeNode child = (AbstractTreeNode)node.getChildAt(i);
            this.findNodes(child, matcher, list);
        }
    }

    private <T extends TreeNode> void findNodes(T node, Predicate<T> matcher, List<T> list) {
        if (matcher.test(node)) {
            list.add(node);
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeNode child = node.getChildAt(i);
            this.findNodes(child, matcher, list);
        }
    }

    public class RemovalOfLinkTargetsNotPermittedException
    extends RuntimeException {
        private Collection<AbstractTreeNode> myLinkTargets;
        private AbstractTreeNode myNodeToRemove;

        private RemovalOfLinkTargetsNotPermittedException(String message, AbstractTreeNode nodeToRemove, Collection<AbstractTreeNode> linkTargets) {
            super(message);
            this.myNodeToRemove = nodeToRemove;
            this.myLinkTargets = linkTargets;
        }

        public Collection<AbstractTreeNode> getLinkTargets() {
            return Collections.unmodifiableCollection(this.myLinkTargets);
        }

        public void forceRemoval() {
            ServiceEditorTreeModel.this.removeNodeFromParent(this.myNodeToRemove, this.myLinkTargets, true);
        }
    }

    private static class HasReferersPredicate
    implements Predicate<AbstractTreeNode> {
        private HasReferersPredicate() {
        }

        @Override
        public boolean test(AbstractTreeNode object) {
            return object.getReferrers().size() > 0;
        }
    }

    private class NodeChangedDuringNodeRemovalListener
    extends TreeModelAdapter {
        private TreeNode myParent;
        private boolean myNodesChanged;

        NodeChangedDuringNodeRemovalListener(TreeNode parent) {
            this.myParent = parent;
            ServiceEditorTreeModel.this.addTreeModelListener(this);
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            Object changedParent = e.getTreePath().getLastPathComponent();
            if (changedParent == this.myParent && e.getChildIndices() != null) {
                this.myNodesChanged = true;
            }
        }

        void remove() {
            ServiceEditorTreeModel.this.removeTreeModelListener(this);
            if (this.myNodesChanged) {
                ServiceEditorTreeModel.this.reload(this.myParent);
            }
        }
    }
}

