/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.propertyeditor;

import com.ericsson.ere.gui.editors.propertyeditor.DefaultEreProxySettingsEditor;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.EreProxy;
import ericsson.ere.gui.propertieseditor.PropertiesException;
import ericsson.ere.integration.settingsmap.SettingsMap;
import java.util.Set;

public class InternalEREProxySettingsEditor
extends DefaultEreProxySettingsEditor {
    private SettingsMap myOriginalValues;
    private EreProxy myEreProxy;

    @Override
    public void performEdit(AbstractEreProxy abstractProxy) {
        if (abstractProxy instanceof EreProxy) {
            this.myEreProxy = (EreProxy)abstractProxy;
            this.myOriginalValues = (SettingsMap)this.myEreProxy.getSettingsMap().clone();
        }
        super.performEdit(abstractProxy);
    }

    @Override
    protected void validateSettings(SettingsMap settings) throws PropertiesException {
        int port = Integer.parseInt(settings.getParameterAsString("Port"));
        if (port <= 0 || port > 65535) {
            throw new PropertiesException("Invalid port number.");
        }
        if (settings.getParameterAsString("Username").isEmpty() || settings.getParameterAsString("Password").isEmpty()) {
            throw new PropertiesException("Username and Password must be specified.");
        }
    }

    private static boolean compare(SettingsMap originalValues, SettingsMap newValues) {
        Set<String> propertiesKeySet = originalValues.getParametersKeySet();
        if (propertiesKeySet.size() != newValues.getParametersKeySet().size()) {
            return false;
        }
        for (String key : propertiesKeySet) {
            if (!newValues.parameterExists(key)) {
                return false;
            }
            if (originalValues.getParameterAsString(key).equals(newValues.getParameterAsString(key))) continue;
            return false;
        }
        return true;
    }

    public boolean needRestart() {
        return !InternalEREProxySettingsEditor.compare(this.myOriginalValues, this.myEreProxy.getSettingsMap());
    }
}

