/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.diff;

import com.ericsson.ere.gui.diff.DiffPoint;
import com.ericsson.ere.gui.diff.DiffProgressDialog;
import com.ericsson.ere.gui.diff.DiffToolMerger;
import com.ericsson.ere.gui.diff.DiffToolPanel;
import com.ericsson.ere.gui.util.ExceptionUtil;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.gui.util.GuiUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.SwingWorker;
import javax.swing.tree.TreePath;

class MergeOptionsPanel
extends JPanel
implements ActionListener {
    public DiffPoint myDiffPoint;
    public JTextArea mySelectedDiffLabel;
    public JToggleButton mySelectedDiffButtonLocal;
    public JToggleButton mySelectedDiffButtonRemote;
    private DiffToolPanel myDiffPanel;

    void tearDown() {
        this.myDiffPoint = null;
        this.mySelectedDiffButtonLocal.removeActionListener(this);
        this.mySelectedDiffButtonRemote.removeActionListener(this);
        this.mySelectedDiffButtonLocal = null;
        this.mySelectedDiffButtonRemote = null;
        this.myDiffPanel = null;
        this.removeAll();
    }

    public MergeOptionsPanel(DiffToolPanel diffToolPanel, DiffPoint diff) {
        this.myDiffPanel = diffToolPanel;
        this.setLayout(new GridBagLayout());
        this.myDiffPoint = diff;
        this.mySelectedDiffLabel = new JTextArea(7, 30);
        String selectedDiffLabelText = diff.getDiffDescription(this.myDiffPanel.useLocalAndRemoteTerms);
        if (this.myDiffPanel.myAction == 2) {
            selectedDiffLabelText = selectedDiffLabelText + diff.getDiffActionDescription(this.myDiffPanel.useLocalAndRemoteTerms);
        }
        this.mySelectedDiffLabel.setText(selectedDiffLabelText);
        this.mySelectedDiffLabel.setLineWrap(true);
        this.mySelectedDiffLabel.setWrapStyleWord(true);
        this.mySelectedDiffLabel.setBackground(this.getBackground());
        this.mySelectedDiffLabel.setBorder(BorderFactory.createEmptyBorder());
        this.mySelectedDiffLabel.setEnabled(false);
        this.mySelectedDiffLabel.setDisabledTextColor(Color.BLACK);
        this.mySelectedDiffLabel.setCaretPosition(0);
        JScrollPane selectedDiffLabelScroll = new JScrollPane(this.mySelectedDiffLabel);
        selectedDiffLabelScroll.setPreferredSize(this.mySelectedDiffLabel.getPreferredScrollableViewportSize());
        selectedDiffLabelScroll.setBorder(BorderFactory.createEmptyBorder());
        this.mySelectedDiffButtonLocal = new JToggleButton(diff.getLocalActionDescription(this.myDiffPanel.useLocalAndRemoteTerms));
        this.mySelectedDiffButtonLocal.setName("DiffToolPanel.JToogleButton.UseLocal");
        this.mySelectedDiffButtonLocal.setIconTextGap(10);
        if (this.myDiffPanel.useLocalAndRemoteTerms) {
            this.mySelectedDiffButtonLocal.setIcon(RmaDefs.getImageIcon("component_blue16.png"));
        } else {
            this.mySelectedDiffButtonLocal.setIcon(RmaDefs.getImageIcon("component_blue16.png"));
        }
        this.mySelectedDiffButtonLocal.addActionListener(this);
        this.mySelectedDiffButtonRemote = new JToggleButton(diff.getRemoteActionDescription(this.myDiffPanel.useLocalAndRemoteTerms));
        this.mySelectedDiffButtonRemote.setName("DiffToolPanel.JToogleButton.UseRemote");
        this.mySelectedDiffButtonRemote.setIconTextGap(10);
        if (this.myDiffPanel.useLocalAndRemoteTerms) {
            this.mySelectedDiffButtonRemote.setIcon(RmaDefs.getImageIcon("component_green16.png"));
        } else {
            this.mySelectedDiffButtonRemote.setIcon(RmaDefs.getImageIcon("component_green16.png"));
        }
        this.mySelectedDiffButtonRemote.addActionListener(this);
        this.mySelectedDiffButtonLocal.setSelected(diff.getAction() == 1 || diff.getAction() == 3);
        this.mySelectedDiffButtonRemote.setSelected(diff.getAction() == 2 || diff.getAction() == 3);
        this.add((Component)selectedDiffLabelScroll, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 18, 1, new Insets(20, 20, 20, 20), 0, 0));
        if (this.myDiffPanel.myAction == 2) {
            this.add((Component)this.mySelectedDiffButtonLocal, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(10, 20, 10, 0), 0, 0));
            this.add((Component)this.mySelectedDiffButtonRemote, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(10, 10, 10, 20), 0, 0));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mySelectedDiffButtonLocal) {
            if (this.mySelectedDiffButtonLocal.isSelected() && this.mySelectedDiffButtonRemote.isSelected()) {
                if (!this.myDiffPoint.isBothActionsAllowed()) {
                    this.mySelectedDiffButtonRemote.setSelected(false);
                }
            } else if (!this.myDiffPoint.isNoActionsAllowed() && !this.mySelectedDiffButtonRemote.isSelected()) {
                this.mySelectedDiffButtonLocal.setSelected(true);
                return;
            }
        } else if (e.getSource() == this.mySelectedDiffButtonRemote) {
            if (this.mySelectedDiffButtonRemote.isSelected()) {
                if (!this.myDiffPoint.isBothActionsAllowed() && this.mySelectedDiffButtonLocal.isSelected()) {
                    this.mySelectedDiffButtonLocal.setSelected(false);
                }
            } else if (!this.myDiffPoint.isNoActionsAllowed() && !this.mySelectedDiffButtonLocal.isSelected()) {
                this.mySelectedDiffButtonRemote.setSelected(true);
                return;
            }
        }
        boolean previousStateLocal = !this.mySelectedDiffButtonLocal.isSelected();
        boolean previousStateRemote = !this.mySelectedDiffButtonRemote.isSelected();
        int previousAction = this.myDiffPoint.getAction();
        int action = this.mySelectedDiffButtonLocal.isSelected() ? (this.mySelectedDiffButtonRemote.isSelected() ? 3 : 1) : (this.mySelectedDiffButtonRemote.isSelected() ? 2 : 0);
        this.myDiffPoint.setAction(action);
        TreePath resultPath = null;
        try {
            Window owner = GuiUtil.getClosestWindowParent(this);
            final DiffProgressDialog progressDialog = DiffProgressDialog.showDialog(owner, "Merging...");
            SwingWorker<TreePath, Void> worker = new SwingWorker<TreePath, Void>(){

                @Override
                protected TreePath doInBackground() throws Exception {
                    return ((MergeOptionsPanel)MergeOptionsPanel.this).myDiffPanel.myMerger.doMerge(MergeOptionsPanel.this.myDiffPoint);
                }

                @Override
                public void done() {
                    progressDialog.setVisible(false);
                }
            };
            worker.execute();
            progressDialog.setVisible(true);
            resultPath = (TreePath)worker.get();
        }
        catch (Exception ex) {
            this.mySelectedDiffButtonLocal.setSelected(previousStateLocal);
            this.mySelectedDiffButtonRemote.setSelected(previousStateRemote);
            this.myDiffPoint.setAction(previousAction);
            if (ex.getCause() instanceof DiffToolMerger.MergeException) {
                DialogFactory.getInformationDialog(GuiServiceCenter.getInstance().getMainWindow(), "RMA", ex.getCause().getMessage());
                return;
            }
            ExceptionUtil.handleException(ex, "diffTool", 1, "There was an error trying to merge the local and the remote tree structure!", true);
        }
        if (resultPath != null) {
            this.myDiffPanel.updateResultTree(resultPath);
        }
    }
}

