/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.diff;

import com.ericsson.ere.gui.diff.DiffPoint;
import ericsson.ere.gui.ratingrules.nodes.TSTariffStructure;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.MultiplierSelectEditorVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.VariableUtil;
import java.awt.Color;
import java.util.List;
import javax.swing.tree.TreePath;

public class DiffPointVariables
extends DiffPoint {
    public static final Color MY_COLOR = new Color(58, 145, 231);
    private List<Variable> myLocalVariables;
    private List<Variable> myRemoteVariables;

    public DiffPointVariables(TreePath localPath, TreePath remotePath, List<Variable> localVariables, List<Variable> remoteVariables) {
        super(localPath, remotePath);
        this.myLocalVariables = localVariables;
        this.myRemoteVariables = remoteVariables;
    }

    @Override
    public String getDiffDescription(boolean useLocalAndRemoteNames) {
        String firstName = useLocalAndRemoteNames ? "local" : "first";
        String secondName = useLocalAndRemoteNames ? "remote" : "second";
        TariffDAGNode n1 = (TariffDAGNode)this.myLocalPath.getLastPathComponent();
        TariffDAGNode n2 = (TariffDAGNode)this.myRemotePath.getLastPathComponent();
        String description = String.format("There is a difference between the %s %s \"%s\" and the %s %s \"%s\"\n\n", firstName, DiffPointVariables.getNodeTypeString(n1), n1.getNodeName(), secondName, DiffPointVariables.getNodeTypeString(n2), n2.getNodeName());
        StringBuilder sb = new StringBuilder(description);
        sb.append("The following settings differ:\n");
        for (int i = 0; i < this.myLocalVariables.size(); ++i) {
            Variable var1 = this.myLocalVariables.get(i);
            if (n1 instanceof TSTariffStructure && var1.getLabel().equals("Version")) continue;
            Variable var2 = VarListUtil.getVariableForName(this.myRemoteVariables, var1.getLabel());
            if (var2 != null) {
                String var2ValueString;
                if (VariableUtil.areVariablesEqual(var1, var2)) continue;
                String var1ValueString = var1.getValueString() != null ? var1.getValueString() : "";
                String string = var2ValueString = var2.getValueString() != null ? var2.getValueString() : "";
                if (var1 instanceof MultiplierSelectEditorVariable && var2 instanceof MultiplierSelectEditorVariable) {
                    var1ValueString = var1.getMultipleSelectValueString() != null ? var1.getMultipleSelectValueString() : "";
                    var2ValueString = var2.getMultipleSelectValueString() != null ? var2.getMultipleSelectValueString() : "";
                } else if (var1 instanceof DropDownVariable && var2 instanceof DropDownVariable) {
                    var1ValueString = var1.toString() != null ? var1.toString() : "";
                    var2ValueString = var2.toString() != null ? var2.toString() : "";
                }
                sb.append("\n- ");
                sb.append(var1.getLabel());
                sb.append("\n    * ");
                sb.append(firstName);
                sb.append(": ");
                sb.append(var1ValueString);
                sb.append("\n    * ");
                sb.append(secondName);
                sb.append(": ");
                sb.append(var2ValueString);
                continue;
            }
            if (var1.getLabel().equals("Tag") && var1.getKey().equals("__PROD_TAG")) {
                sb.append("\n- ");
                sb.append(var1.getLabel());
                sb.append("\n    * ");
                sb.append(firstName);
                sb.append(": ");
                sb.append(var1.getValueString());
                sb.append("\n    * ");
                sb.append(secondName);
                sb.append(": ");
                continue;
            }
            sb.append("\n- ");
            sb.append(var1.getLabel());
            sb.append(" is not present in ");
            sb.append(secondName);
            sb.append(" tree, exiting for this ");
            sb.append(DiffPointVariables.getNodeTypeString(n1));
            sb.append(".");
            break;
        }
        return sb.toString();
    }

    @Override
    public String getDiffActionDescription(boolean useLocalAndRemoteNames) {
        return "\n\nWhich " + DiffPointVariables.getNodeTypeString((TariffDAGNode)this.myLocalPath.getLastPathComponent()) + " shall be used in the Result Tree?";
    }

    @Override
    public String getLocalActionDescription(boolean useLocalAndRemoteNames) {
        String firstName = useLocalAndRemoteNames ? "local" : "first";
        return "The " + firstName;
    }

    @Override
    public String getRemoteActionDescription(boolean useLocalAndRemoteNames) {
        String secondName = useLocalAndRemoteNames ? "remote" : "second";
        return "The " + secondName;
    }

    @Override
    public boolean isBothActionsAllowed() {
        return false;
    }

    @Override
    public boolean isNoActionsAllowed() {
        return false;
    }

    @Override
    public int getDiffPriority() {
        return 1;
    }

    @Override
    public Color getDiffColor() {
        return MY_COLOR;
    }
}

