/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.functioncontrol;

import com.ericsson.ere.functioncontrol.FunctionContext;
import com.ericsson.ere.functioncontrol.FunctionController;
import com.ericsson.ere.functioncontrol.FunctionState;
import com.ericsson.ere.functioncontrol.FunctionToken;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.ActiveSavedRatingPeriodProxy;
import com.ericsson.ere.proxy.RatingManagerProxy;

public class LegacyFunctionController
implements FunctionController {
    LegacyFunctionController() {
    }

    @Override
    public FunctionState getStateForFunction(FunctionToken token, FunctionContext ctx) {
        return this.getBackwardsCompatibilityState(token, ctx);
    }

    private FunctionState getBackwardsCompatibilityState(FunctionToken token, FunctionContext ctx) {
        FunctionState state = null;
        if (this.isActivePeriodSaveAttempt(token, ctx)) {
            state = FunctionState.createFunctionStateWithDescription(FunctionState.State.OFF, "Saving is not allowed for active trees.");
        } else {
            Boolean propState = this.getStateForTokenFromExistingProperties(token, ctx);
            if (propState != null) {
                boolean bstate = propState;
                String text = this.getCompatibilityText(token, ctx, bstate);
                state = text == null ? FunctionState.createFunctionState(bstate ? FunctionState.State.ON : FunctionState.State.OFF) : FunctionState.createFunctionStateWithDescription(bstate ? FunctionState.State.ON : FunctionState.State.OFF, text);
            }
        }
        return state;
    }

    private boolean isActivePeriodSaveAttempt(FunctionToken token, FunctionContext ctx) {
        AbstractEreProxy proxy = ctx.getProxy();
        return token == FunctionToken.SAVE_SELECTION_TREE && proxy instanceof ActiveSavedRatingPeriodProxy && ((ActiveSavedRatingPeriodProxy)proxy).isSelectedActive();
    }

    private Boolean getStateForTokenFromExistingProperties(FunctionToken token, FunctionContext ctx) {
        String value = null;
        switch (token) {
            case DEBUG: 
            case SHOW_SERVICE_LIST: 
            case ALLOW_SERVICEPROVIDERLIST_MENU: 
            case TEST_GENERATION_TOOL: {
                RatingManagerProxy rmProxy = ctx.getProxy().getRatingManagerProxy();
                if (rmProxy == null) break;
                value = rmProxy.getProperty(token.getName());
                break;
            }
            default: {
                value = null;
            }
        }
        return value != null ? Boolean.valueOf(value) : null;
    }

    protected String getCompatibilityText(FunctionToken token, FunctionContext ctx, boolean state) {
        String text = null;
        if (state && this.isAIRDebugModeRequest(token, ctx)) {
            text = "Jumps to saved trees are allowed in debug mode. You are not simulating a live traffic case.";
        }
        return text;
    }

    private boolean isAIRDebugModeRequest(FunctionToken token, FunctionContext ctx) {
        String ereType = ctx.getProxy().getEreProxy().getType();
        boolean isRefillConnector = ereType.startsWith("AIR ");
        return token == FunctionToken.DEBUG && isRefillConnector;
    }
}

