/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.expression.EvaluationContext;
import com.ericsson.ere.expression.Operand;
import com.ericsson.ere.expression.Unit;
import com.ericsson.ere.expression.UnitValue;
import com.ericsson.ere.expression.Units;

@Immutable
public final class UnitOperand
implements Operand {
    private final Operand myInnerOperand;
    private final Unit myUnit;

    private UnitOperand(Operand inner, Unit unit) {
        this.myInnerOperand = inner;
        this.myUnit = unit;
    }

    @Override
    public Object getValue(EvaluationContext context) {
        Object value = this.myInnerOperand.getValue(context);
        return UnitValue.create(value, this.myUnit);
    }

    public Operand getOperand() {
        return this.myInnerOperand;
    }

    public Unit getUnit() {
        return this.myUnit;
    }

    public static UnitOperand create(Operand inner, Unit unit) {
        if (inner == null || unit == null) {
            throw new IllegalArgumentException("Requires non-null arguments.");
        }
        return new UnitOperand(inner, unit);
    }

    public static UnitOperand create(Operand inner, String unitName) {
        if (inner == null || unitName == null) {
            throw new IllegalArgumentException("Requires non-null arguments.");
        }
        Unit unit = Units.getUnitByName(unitName);
        if (unit == null) {
            throw new IllegalArgumentException("Unknown unit: " + unitName);
        }
        return new UnitOperand(inner, unit);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myInnerOperand == null ? 0 : this.myInnerOperand.hashCode());
        result = 31 * result + (this.myUnit == null ? 0 : this.myUnit.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnitOperand other = (UnitOperand)obj;
        if (this.myInnerOperand == null ? other.myInnerOperand != null : !this.myInnerOperand.equals(other.myInnerOperand)) {
            return false;
        }
        return !(this.myUnit == null ? other.myUnit != null : !this.myUnit.equals(other.myUnit));
    }

    public String toString() {
        return this.myInnerOperand.toString() + " " + this.myUnit.toString();
    }
}

