/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression;

import com.ericsson.ere.expression.Expression;
import com.ericsson.ere.expression.ExpressionConverter;
import com.ericsson.ere.expression.ExpressionException;
import com.ericsson.ere.expression.ExpressionToken;
import com.ericsson.ere.expression.Function;
import com.ericsson.ere.expression.FunctionArgBOF;
import com.ericsson.ere.expression.InfixOperatorRules;
import com.ericsson.ere.expression.Operand;
import com.ericsson.ere.expression.Operator;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Stack;

public class ShuntingYardConverter
implements ExpressionConverter {
    private static final ExpressionToken FUNCTION_OPEN_PAREN = new ExpressionToken(){};
    private final InfixOperatorRules myRules;

    public ShuntingYardConverter(InfixOperatorRules rules) {
        this.myRules = rules;
    }

    @Override
    public Expression convert(Expression expr) {
        if (expr.getNotation() != Expression.ExpressionNotation.INFIX) {
            throw new IllegalArgumentException("This converter can only handle infix expressions.");
        }
        List<ExpressionToken> inputs = expr.getExpressionTokens();
        ExpressionToken[] input = inputs.toArray(new ExpressionToken[inputs.size()]);
        ArrayList<ExpressionToken> output = new ArrayList<ExpressionToken>();
        Stack<ExpressionToken> stack = new Stack<ExpressionToken>();
        boolean nextLeftParenIsFunctionOpening = false;
        for (int idx = 0; idx < input.length; ++idx) {
            ExpressionToken token = input[idx];
            if (this.isOperand(token)) {
                if (this.isExpression(token)) {
                    token = this.convert((Expression)token);
                }
                output.add(token);
                continue;
            }
            if (this.isFunction(token)) {
                stack.push(token);
                output.add(FunctionArgBOF.INSTANCE);
                nextLeftParenIsFunctionOpening = true;
                continue;
            }
            if (this.isFunctionArgumentSeparator(token)) {
                this.popOffStackOntoOutput(stack, output, true, true, "Mismatched parentheses or misplaced function argument separator.", idx, new ExpressionToken[]{token});
                continue;
            }
            if (this.isOperator(token)) {
                ExpressionToken o2;
                while (!stack.isEmpty() && this.isOperator(o2 = (ExpressionToken)stack.peek()) && this.secondIsHeavier((Operator)token, (Operator)o2)) {
                    stack.pop();
                    output.add(o2);
                }
                stack.push(token);
                continue;
            }
            if (this.isLeftParenthesis(token)) {
                stack.push(nextLeftParenIsFunctionOpening ? FUNCTION_OPEN_PAREN : token);
                nextLeftParenIsFunctionOpening = false;
                continue;
            }
            if (this.isRightParenthesis(token)) {
                this.popOffStackOntoOutput(stack, output, false, false, "Mismatched parentheses.", idx, new ExpressionToken[]{token});
                if (stack.isEmpty() || !this.isFunction(stack.peek())) continue;
                output.add(stack.pop());
                continue;
            }
            throw new ExpressionException("Unknown expression token.", idx, input);
        }
        while (!stack.isEmpty()) {
            ExpressionToken t = (ExpressionToken)stack.pop();
            if (this.isLeftParenthesis(t) || this.isRightParenthesis(t)) {
                throw new ExpressionException("Mismatched parentheses.", t);
            }
            output.add(t);
        }
        return new Expression(output, Expression.ExpressionNotation.POSTFIX);
    }

    private void popOffStackOntoOutput(Stack<ExpressionToken> stack, List<ExpressionToken> output, boolean requireFunctionOpening, boolean leaveToken, String errorMsg, int idx, ExpressionToken[] input) {
        try {
            ExpressionToken stackToken;
            while (!this.isLeftParenthesisOrFunctionStart(stackToken = stack.peek())) {
                output.add(stack.pop());
            }
            if (requireFunctionOpening && stackToken != FUNCTION_OPEN_PAREN) {
                throw new ExpressionException(errorMsg, idx, input);
            }
            if (!leaveToken) {
                ExpressionToken t = stack.pop();
                assert (this.isLeftParenthesisOrFunctionStart(t));
            }
        }
        catch (EmptyStackException e) {
            throw new ExpressionException(errorMsg, idx, input);
        }
    }

    private boolean isLeftParenthesisOrFunctionStart(ExpressionToken tok) {
        return tok == FUNCTION_OPEN_PAREN || this.isLeftParenthesis(tok);
    }

    private boolean isRightParenthesis(ExpressionToken token) {
        return token.equals(ExpressionToken.RIGHT_PAREN);
    }

    private boolean isLeftParenthesis(ExpressionToken token) {
        return token.equals(ExpressionToken.LEFT_PAREN);
    }

    private boolean isFunctionArgumentSeparator(ExpressionToken token) {
        return token.equals(ExpressionToken.FUNCTION_ARG_SEPARATOR);
    }

    private boolean isOperand(ExpressionToken token) {
        return token instanceof Operand;
    }

    private boolean isExpression(ExpressionToken token) {
        return token instanceof Expression;
    }

    private boolean isFunction(ExpressionToken token) {
        return token instanceof Function;
    }

    private boolean secondIsHeavier(Operator o1, Operator o2) {
        if (!this.myRules.isRightAssociative(o1)) {
            return this.myRules.precedenceOf(o1) <= this.myRules.precedenceOf(o2);
        }
        return this.myRules.precedenceOf(o1) < this.myRules.precedenceOf(o2);
    }

    private boolean isOperator(ExpressionToken t) {
        return t instanceof Operator && !this.isFunction(t);
    }
}

