/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression;

import com.ericsson.ere.annotations.IdentityBasedEquality;
import com.ericsson.ere.expression.Function;
import com.ericsson.ere.expression.FunctionArgumentTypeException;
import com.ericsson.ere.expression.FunctionArgumentValueException;
import com.ericsson.ere.expression.FunctionParameterInfo;
import com.ericsson.ere.math.RatingDecimal;
import ericsson.ere.datatype.Amount;
import ericsson.ere.datatype.DataType;

@IdentityBasedEquality
public class BalanceOfFunction
extends Function {
    private static final String FUNC_DESC = "Extracts the balance from an amount.";
    private static final FunctionParameterInfo[] PARAMS = new FunctionParameterInfo[]{FunctionParameterInfo.mandatoryParameter("amount", "amount to extract the balance from", DataType.AMOUNT, false), FunctionParameterInfo.optionalParameter("currency", "currency to convert the amount to before extracting the balance (optional)", DataType.STRING, null, false)};
    public static final BalanceOfFunction INSTANCE = new BalanceOfFunction();

    protected BalanceOfFunction() {
    }

    @Override
    protected Object perform(Object[] args) {
        Amount amount = this.getAmount(args);
        String destCurrency = this.getDestinationCurrency(args);
        if (destCurrency != null && !amount.getCurrency().equals(destCurrency)) {
            amount = this.convertAmount(amount, destCurrency);
        }
        RatingDecimal balance = amount.getBalance();
        return balance;
    }

    private Amount convertAmount(Amount amount, String destCurrency) {
        try {
            return amount.getAmountFactory().convert(amount, destCurrency);
        }
        catch (RuntimeException ex) {
            throw new FunctionArgumentValueException(this, 1, destCurrency, "Failed to convert amount using the specified currency.");
        }
    }

    private Amount getAmount(Object[] args) {
        Object arg = args[0];
        if (!(arg instanceof Amount)) {
            throw new FunctionArgumentTypeException(this, 0, "must be an amount");
        }
        return (Amount)arg;
    }

    private String getDestinationCurrency(Object[] args) {
        if (args.length < 2) {
            return null;
        }
        Object arg = args[1];
        if (!(arg instanceof String)) {
            throw new FunctionArgumentTypeException(this, 1, "must be a currency string");
        }
        return (String)arg;
    }

    @Override
    public String getFunctionDescription() {
        return FUNC_DESC;
    }

    @Override
    public String getFunctionName() {
        return "balanceOf";
    }

    @Override
    public FunctionParameterInfo[] getParameters() {
        return PARAMS;
    }

    @Override
    public DataType getReturnType() {
        return DataType.RATINGDECIMAL;
    }
}

