/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.exportmanager;

import com.ericsson.ere.exportmanager.ExportContext;
import com.ericsson.ere.exportmanager.ExportFailedException;
import com.ericsson.ere.exportmanager.ExportManager;
import com.ericsson.ere.exportmanager.NavigatorNodeExportContext;
import com.ericsson.ere.gui.navigator.nodes.AbstractNavigatorNode;
import com.ericsson.ere.gui.navigator.nodes.NavigatorNodeInterface;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.ProxyHelper;
import com.ericsson.ere.proxy.RatingManagerProxy;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import com.ericsson.ere.proxy.RatingPlanProxy;
import com.ericsson.ere.proxy.ServiceListProxy;
import com.ericsson.ere.proxy.ServiceProviderListProxy;
import com.ericsson.ere.proxy.ServiceProviderProxy;
import com.ericsson.ere.proxy.ServiceProxy;
import ericsson.ere.integration.connector.EreCommunicationException;
import ericsson.ere.management.DateUtil;
import ericsson.ere.progress.ProgressIndicator;
import ericsson.ere.progress.ProgressVisualizer;
import ericsson.ere.progress.SynchronizedEDTProgressVisualizer;
import ericsson.ere.xml.DomWriter;
import ericsson.ere.xml.XMLUtil;
import java.io.File;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Element;

public class NavigatorNodeExportManager
implements ExportManager {
    private PrintWriter myPrintWriter = null;
    private ProgressVisualizer myVisualizer = null;
    private ProgressIndicator myProgressIndicator = null;
    private boolean hasCompleted = false;
    private boolean exportSuccessful = true;
    private Vector<AbstractEreProxy> myExportProxyList = new Vector();
    private File myExportFile;
    SimpleDateFormat myDateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public void doExport(ExportContext context) throws ExportFailedException {
        NavigatorNodeExportContext theContext = (NavigatorNodeExportContext)context;
        Vector<AbstractEreProxy> temporaryProxyVector = this.extractRecognizedProxies(theContext.getProxiesToExport());
        this.myExportFile = theContext.getExportFile();
        this.myExportProxyList.clear();
        this.myExportProxyList.addAll(NavigatorNodeExportManager.extractSortedProxyVector(temporaryProxyVector));
        this.myVisualizer = theContext.getVisualizer();
        try {
            this.myPrintWriter = new PrintWriter(this.myExportFile, "UTF-8");
        }
        catch (Exception e) {
            throw new ExportFailedException("Failed to create PrintWriter.", e);
        }
        this.exportSuccessful = true;
        this.processProxyList();
    }

    private static Vector<AbstractEreProxy> extractSortedProxyVector(Vector<AbstractEreProxy> temporaryProxyVector) {
        ServiceListProxy serviceListProxy = temporaryProxyVector.get(0).getRatingManagerProxy().getServiceListProxy();
        int serviceListIndex = temporaryProxyVector.indexOf(serviceListProxy);
        if (serviceListIndex > 0) {
            Vector<AbstractEreProxy> sortedVector = new Vector<AbstractEreProxy>(temporaryProxyVector.size());
            sortedVector.addAll(temporaryProxyVector.subList(serviceListIndex, temporaryProxyVector.size() - 1));
            sortedVector.addAll(temporaryProxyVector.subList(0, serviceListIndex - 1));
            return sortedVector;
        }
        return temporaryProxyVector;
    }

    private Vector<AbstractEreProxy> extractRecognizedProxies(Vector<AbstractEreProxy> proxyVector) {
        Vector<AbstractEreProxy> recognizedProxies = new Vector<AbstractEreProxy>();
        for (AbstractEreProxy currentProxy : proxyVector) {
            if (!(currentProxy instanceof ServiceListProxy) && !(currentProxy instanceof ServiceProxy) && !(currentProxy instanceof ServiceProviderListProxy) && !(currentProxy instanceof ServiceProviderProxy) && !(currentProxy instanceof RatingPlanProxy) && !(currentProxy instanceof RatingPeriodProxy)) continue;
            recognizedProxies.add(currentProxy);
        }
        return recognizedProxies;
    }

    private void processProxyList() {
        if (this.myPrintWriter == null) {
            return;
        }
        this.myProgressIndicator = this.createProgressIndicator();
        if (this.myProgressIndicator != null) {
            this.myProgressIndicator.setInfo("Export Start");
        }
        boolean containsServices = false;
        boolean containsSelectionTrees = false;
        for (AbstractEreProxy proxy : this.myExportProxyList) {
            if (proxy instanceof ServiceListProxy) {
                containsServices = true;
            } else if (proxy instanceof ServiceProviderListProxy) {
                containsSelectionTrees = true;
            }
            if (!containsServices || !containsSelectionTrees) continue;
            break;
        }
        this.myPrintWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        String now = DateUtil.formatISODateTime(Calendar.getInstance(), false);
        if (containsServices && containsSelectionTrees) {
            this.myPrintWriter.println("<EreExport Type=\"RatingManager\" exportDate=\"" + now + "\">");
        } else if (containsServices) {
            this.myPrintWriter.println("<EreExport Type=\"ServiceList\" exportDate=\"" + now + "\">");
        } else {
            this.myPrintWriter.println("<EreExport Type=\"ServiceProviderList\" exportDate=\"" + now + "\">");
        }
        this.myPrintWriter.flush();
        while (this.exportSuccessful && this.myExportProxyList.size() > 0) {
            try {
                this.recProcessProxy();
            }
            catch (ExportFailedException ex) {
                ExceptionUtil.handleException(ex, "distribution", 2, "Export failed: " + ex.getCause() == null ? ex.getMessage() : ex.getCause().getMessage(), this.myProgressIndicator == null);
                this.exportSuccessful = false;
            }
        }
        this.myPrintWriter.println("</EreExport>");
        this.myPrintWriter.flush();
        this.myPrintWriter.close();
        if (this.myProgressIndicator != null) {
            this.myProgressIndicator.setInfo("");
            if (this.exportSuccessful) {
                this.myProgressIndicator.setInfo("Export End");
            } else {
                this.myProgressIndicator.showAdditionalInfo("Export Failed");
            }
            this.myProgressIndicator.progressFinished();
        }
        if (!this.exportSuccessful) {
            this.myExportFile.delete();
        }
        this.hasCompleted = true;
    }

    private ProgressIndicator createProgressIndicator() {
        ProgressIndicator pi = this.myVisualizer == null ? null : SynchronizedEDTProgressVisualizer.createThreadSafeProgressIndicator(this.myVisualizer, this.myExportProxyList.size());
        return pi;
    }

    private void recProcessProxy() throws ExportFailedException {
        AbstractEreProxy currentProxy = null;
        if (this.myExportProxyList.isEmpty()) {
            return;
        }
        currentProxy = this.myExportProxyList.remove(0);
        if (this.myProgressIndicator != null) {
            this.myProgressIndicator.progressIncrement();
            this.myProgressIndicator.setInfo("");
        }
        if (currentProxy instanceof ServiceProxy) {
            ServiceProxy serviceProxy = (ServiceProxy)currentProxy;
            Element serviceElement = null;
            try {
                serviceElement = serviceProxy.getServiceXML();
            }
            catch (EreCommunicationException e) {
                if (this.myProgressIndicator != null) {
                    this.myProgressIndicator.showAdditionalInfo("Failed to export service: " + serviceProxy.getName() + ":\r\n" + e.getMessage() + "\r\nCheck the log for more info.");
                }
                throw new ExportFailedException("Failed to fetch service XML.", e);
            }
            if (this.myProgressIndicator != null) {
                this.myProgressIndicator.setInfo("Exporting service: " + serviceProxy.getName());
            }
            DomWriter.elementToStream(serviceElement, this.myPrintWriter);
        } else if (currentProxy instanceof ServiceListProxy) {
            if (this.myProgressIndicator != null) {
                this.myProgressIndicator.setInfo("Exporting services...");
            }
            this.myPrintWriter.println("<ServiceList>");
            while (!this.myExportProxyList.isEmpty() && this.myExportProxyList.elementAt(0) instanceof ServiceProxy) {
                this.recProcessProxy();
            }
            this.myPrintWriter.println("</ServiceList>");
        } else if (currentProxy instanceof RatingPeriodProxy) {
            RatingPeriodProxy ratingPeriodProxy = (RatingPeriodProxy)currentProxy;
            Element ratingPeriodElement = null;
            try {
                ratingPeriodElement = ratingPeriodProxy.getRatingPeriodRuleTree();
            }
            catch (EreCommunicationException e) {
                if (this.myProgressIndicator != null) {
                    this.myProgressIndicator.showAdditionalInfo("Failed to export rating period: " + ratingPeriodProxy.getName() + ":\r\n" + e.getMessage() + "\r\nCheck the log for more info.");
                }
                throw new ExportFailedException("Failed to fetch rating period XML.", e);
            }
            if (this.myProgressIndicator != null) {
                this.myProgressIndicator.setInfo("Exporting rating period: " + ratingPeriodProxy.getName());
            }
            DomWriter.elementToStream(ratingPeriodElement, this.myPrintWriter);
        } else if (currentProxy instanceof RatingPlanProxy) {
            RatingPlanProxy ratingPlanProxy = (RatingPlanProxy)currentProxy;
            if (this.myProgressIndicator != null) {
                this.myProgressIndicator.setInfo("Exporting rating plan: " + ratingPlanProxy.getName());
            }
            this.myPrintWriter.println("<RatingPlan" + XMLUtil.wrapInAttribute("Name", ratingPlanProxy.getName()) + XMLUtil.wrapInAttribute("Service", ratingPlanProxy.getServiceName()) + ">");
            while (!this.myExportProxyList.isEmpty() && this.myExportProxyList.elementAt(0) instanceof RatingPeriodProxy) {
                this.recProcessProxy();
            }
            this.myPrintWriter.println("</RatingPlan>");
        } else if (currentProxy instanceof ServiceProviderProxy) {
            ServiceProviderProxy serviceProviderProxy = (ServiceProviderProxy)currentProxy;
            if (this.myProgressIndicator != null) {
                this.myProgressIndicator.setInfo("Exporting service provider: " + serviceProviderProxy.getName());
            }
            this.myPrintWriter.println("<ServiceProvider" + XMLUtil.wrapInAttribute("Name", serviceProviderProxy.getName()) + ">");
            while (!this.myExportProxyList.isEmpty() && this.myExportProxyList.elementAt(0) instanceof RatingPlanProxy) {
                this.recProcessProxy();
            }
            this.myPrintWriter.println("</ServiceProvider>");
        } else if (currentProxy instanceof ServiceProviderListProxy) {
            if (this.myProgressIndicator != null) {
                this.myProgressIndicator.setInfo("Exporting service providers...");
            }
            this.myPrintWriter.println("<ServiceProviderList>");
            while (!this.myExportProxyList.isEmpty() && this.myExportProxyList.elementAt(0) instanceof ServiceProviderProxy) {
                this.recProcessProxy();
            }
            this.myPrintWriter.println("</ServiceProviderList>");
        }
        this.myPrintWriter.flush();
    }

    public static Vector<AbstractEreProxy> extractProxyVector(Vector<DefaultMutableTreeNode> nodesVector, boolean exportRequiredServices) {
        Vector<AbstractEreProxy> proxyVector = new Vector<AbstractEreProxy>();
        for (DefaultMutableTreeNode node : nodesVector) {
            proxyVector.add(((NavigatorNodeInterface)((Object)node)).getProxy());
        }
        AbstractEreProxy currentProxy = ((NavigatorNodeInterface)((Object)nodesVector.get(0))).getProxy();
        if (currentProxy instanceof RatingManagerProxy) {
            proxyVector.remove(0);
        } else {
            currentProxy = ProxyHelper.getParentProxyOf(currentProxy);
            while (currentProxy != null && !(currentProxy instanceof RatingManagerProxy)) {
                proxyVector.add(0, currentProxy);
                currentProxy = ProxyHelper.getParentProxyOf(currentProxy);
            }
        }
        if (exportRequiredServices) {
            NavigatorNodeExportManager.addRequiredServiceProxies(proxyVector);
        }
        return proxyVector;
    }

    private static void addRequiredServiceProxies(Vector<AbstractEreProxy> exportProxyVector) {
        Vector<ServiceProxy> serviceProxies = new Vector<ServiceProxy>();
        ServiceListProxy serviceListProxy = exportProxyVector.get(0).getRatingManagerProxy().getServiceListProxy();
        for (AbstractEreProxy abstractEreProxy : exportProxyVector) {
            RatingPeriodProxy ratingPeriodProxy;
            RatingPlanProxy ratingPlanProxy;
            ServiceProxy serviceProxy;
            if (abstractEreProxy instanceof RatingPlanProxy && !serviceProxies.contains(serviceProxy = serviceListProxy.getServiceProxy((ratingPlanProxy = (RatingPlanProxy)abstractEreProxy).getServiceName()))) {
                serviceProxies.add(serviceProxy);
            }
            if (!(abstractEreProxy instanceof RatingPeriodProxy) || serviceProxies.contains(serviceProxy = serviceListProxy.getServiceProxy((ratingPeriodProxy = (RatingPeriodProxy)abstractEreProxy).getServiceName()))) continue;
            serviceProxies.add(serviceProxy);
        }
        if (!serviceProxies.isEmpty()) {
            if (!(exportProxyVector.get(0) instanceof ServiceListProxy)) {
                exportProxyVector.add(0, serviceListProxy);
            }
            for (AbstractEreProxy abstractEreProxy : serviceProxies) {
                if (exportProxyVector.contains(abstractEreProxy)) continue;
                exportProxyVector.add(1, abstractEreProxy);
            }
        }
    }

    public static Vector<AbstractEreProxy> createProxyVector(Vector<DefaultMutableTreeNode> nodes) {
        Vector<AbstractEreProxy> proxies = new Vector<AbstractEreProxy>();
        for (DefaultMutableTreeNode tNode : nodes) {
            proxies.add(((AbstractNavigatorNode)tNode).getProxy());
        }
        return proxies;
    }
}

