/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.datatype;

import com.ericsson.calendar.CalendarDate;
import com.ericsson.ere.datatype.EREDateConstants;
import java.util.Calendar;
import java.util.Date;

public interface EREDate {
    public static final EREDate BEGINNING_OF_TIME = EREDateConstants.createBeginningOfTime();
    public static final EREDate END_OF_TIME = EREDateConstants.createEndOfTime();

    public int getDaysSince19700101();

    public WeekDay getDayOfWeek();

    public int daysUntil(EREDate var1);

    public Date asDate();

    public Calendar asCalendar();

    public EREDate plusDays(int var1);

    public EREDate plusMonths(int var1);

    public EREDate plusYears(int var1);

    public int compareTo(EREDate var1);

    public int compareTo(Calendar var1);

    public int compareTo(Date var1);

    public boolean isAfter(EREDate var1);

    public boolean isBefore(EREDate var1);

    public int getFullYear();

    public int getMonthOfYear();

    public int getDayOfMonth();

    public static enum WeekDay {
        Sunday,
        Monday,
        Tuesday,
        Wednesday,
        Thursday,
        Friday,
        Saturday;


        public static WeekDay getFrom(Calendar cal) {
            return WeekDay.values()[cal.get(7) - 1];
        }

        public static WeekDay getFrom(Date date) {
            return WeekDay.values()[date.getDay()];
        }

        public static WeekDay getFrom(CalendarDate cd) {
            return WeekDay.values()[cd.getDayOfWeek()];
        }
    }
}

