/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.dataset.task;

import com.ericsson.ere.dataset.task.AbstractTimeBasedTreeTask;
import com.ericsson.ere.selectiontree.TreeExecutionException;
import java.util.ListIterator;

public class ContinuousTimeTask
extends AbstractTimeBasedTreeTask {
    public ContinuousTimeTask(long duration) {
        super(duration);
    }

    @Override
    public void saveState() {
        this.myStates.push(new AbstractTimeBasedTreeTask.State(this.myAllocatedDuration, this.myDurationToTimeSwitch, false));
    }

    @Override
    public void restoreState() {
        if (this.myStates.isEmpty()) {
            throw new TreeExecutionException("Failed to restore tree task state since no previous state exists.");
        }
        AbstractTimeBasedTreeTask.State state = (AbstractTimeBasedTreeTask.State)this.myStates.pop();
        this.myDurationToTimeSwitch = -1L;
        this.setDurationToNextTimeSwitch(state.myDurationToTimeSwitchState);
    }

    @Override
    public void setDurationToNextTimeSwitch(long duration) {
        super.setDurationToNextTimeSwitch(duration);
        long timeLeft = this.myTotalDuration - this.myAllocatedDuration;
        if (timeLeft < 0L) {
            timeLeft = 0L;
        }
        if (this.myDurationToTimeSwitch == TIME_SWITCH_RESET) {
            this.resetDurationToTimeSwitchFromPreviousState();
        }
        this.myRemainingDuration = this.myDurationToTimeSwitch < 0L ? timeLeft : Math.min(timeLeft, this.myDurationToTimeSwitch);
    }

    @Override
    public long getDurationToNextTimeSwitch() {
        return this.myDurationToTimeSwitch;
    }

    @Override
    public long allocateTime(long duration) {
        long allocatedDuration = 0L;
        if (duration > 0L) {
            this.allocateTimeFromDataSet(duration);
            this.myRemainingDuration -= duration;
            this.myAllocatedDuration += duration;
            if (this.myRemainingDuration < 0L) {
                this.myRemainingDuration = 0L;
            }
            this.moveAllDurationsToTimeSwitch(duration);
            allocatedDuration = duration;
        }
        return allocatedDuration;
    }

    protected void allocateTimeFromDataSet(long duration) {
        this.myDataSet.allocateTime((int)duration);
    }

    private void moveAllDurationsToTimeSwitch(long duration) {
        this.myDurationToTimeSwitch -= duration;
        if (this.myDurationToTimeSwitch < 0L) {
            this.myDurationToTimeSwitch = 0L;
        }
        for (AbstractTimeBasedTreeTask.State state : this.myStates) {
            if (state.myDurationToTimeSwitchState == -1L) continue;
            state.myDurationToTimeSwitchState -= duration;
            if (state.myDurationToTimeSwitchState >= 0L) continue;
            state.myDurationToTimeSwitchState = 0L;
        }
    }

    private void resetDurationToTimeSwitchFromPreviousState() {
        long resetTimeSwitch = -1L;
        ListIterator iterator = this.myStates.listIterator(this.myStates.size());
        while (iterator.hasPrevious()) {
            AbstractTimeBasedTreeTask.State current = (AbstractTimeBasedTreeTask.State)iterator.previous();
            if (current.myIsModificationCheckState) continue;
            resetTimeSwitch = current.myDurationToTimeSwitchState;
            break;
        }
        this.myDurationToTimeSwitch = resetTimeSwitch;
    }
}

