/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.dataset;

import com.ericsson.ere.annotations.jcip.Immutable;

@Immutable
public final class SelectionTreeQualifier {
    private final long myQualifier;

    private SelectionTreeQualifier(long qualifier) {
        if (qualifier < 0L) {
            throw new IllegalArgumentException("Selection Tree Qualifier cannot be negative.");
        }
        this.myQualifier = qualifier;
    }

    public static SelectionTreeQualifier valueOf(String str) {
        if (str == null) {
            throw new IllegalArgumentException("Cannot create a Selection Tree Qualifier from a null string.");
        }
        long q = Long.parseLong(str);
        return new SelectionTreeQualifier(q);
    }

    public static SelectionTreeQualifier valueOf(long q) {
        return new SelectionTreeQualifier(q);
    }

    public long value() {
        return this.myQualifier;
    }

    public String toString() {
        return Long.toString(this.myQualifier);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.myQualifier ^ this.myQualifier >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SelectionTreeQualifier other = (SelectionTreeQualifier)obj;
        return this.myQualifier == other.myQualifier;
    }
}

