/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.dataset;

import com.ericsson.ere.dataset.AbstractDataSet;
import com.ericsson.ere.dataset.DefaultDataSet;
import com.ericsson.ere.dataset.ValueContainer;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.FieldHierarchyNode;

public class DefaultValueContainer
implements ValueContainer {
    private AbstractDataSet myDataSet;

    public DefaultValueContainer() {
        this.myDataSet = new ValuesEqualsAndHashCodeDataSet();
    }

    public DefaultValueContainer(AbstractDataSet dataSet) {
        this.myDataSet = dataSet;
    }

    public AbstractDataSet getDataSet() {
        return this.myDataSet;
    }

    @Override
    public void setData(FieldHierarchyNode field, Object value, DataType type) {
        int tag = field.getTagNumber();
        boolean useTag = tag > -1;
        String name = field.getFieldName();
        if (useTag) {
            this.myDataSet.setDataAsObject(tag, value);
        } else {
            this.myDataSet.setDataAsObject(name, value);
        }
    }

    @Override
    public Object getData(FieldHierarchyNode field, DataType type) {
        return this.getValueBasedOnDataType(field, type);
    }

    @Override
    public boolean hasData(FieldHierarchyNode field) {
        int tag = field.getTagNumber();
        boolean useTag = tag > -1;
        return useTag ? this.myDataSet.hasData(tag) : this.myDataSet.hasData(field.getFieldName());
    }

    private Object getValueBasedOnDataType(FieldHierarchyNode node, DataType type) {
        Object ret;
        int tag = node.getTagNumber();
        boolean useTag = tag > -1;
        String name = node.getFieldName();
        if (node.isLeaf() && node.getComplexType() == FieldHierarchyNode.ComplexType.NONE) {
            DataType usedType = type;
            if (type == null) {
                usedType = ((FieldDefinition)node).getTypedDataType();
            }
            switch (usedType) {
                case AMOUNT: {
                    ret = useTag ? this.myDataSet.getDataAsAmount(tag) : this.myDataSet.getDataAsAmount(name);
                    break;
                }
                case BCDSTRING: {
                    ret = useTag ? this.myDataSet.getDataAsBcdString(tag) : this.myDataSet.getDataAsBcdString(name);
                    break;
                }
                case BOOLEAN: {
                    ret = useTag ? this.myDataSet.getDataAsBoolean(tag) : this.myDataSet.getDataAsBoolean(name);
                    break;
                }
                case DATE: {
                    ret = useTag ? this.myDataSet.getDataAsEREDate(tag) : this.myDataSet.getDataAsEREDate(name);
                    break;
                }
                case DECIMAL: {
                    ret = useTag ? this.myDataSet.getDataAsDecimal(tag) : this.myDataSet.getDataAsDecimal(name);
                    break;
                }
                case DOUBLE: {
                    ret = useTag ? this.myDataSet.getDataAsDouble(tag) : this.myDataSet.getDataAsDouble(name);
                    break;
                }
                case INTEGER: 
                case UNSIGNEDINT: {
                    ret = useTag ? this.myDataSet.getDataAsInt(tag) : this.myDataSet.getDataAsInt(name);
                    break;
                }
                case LONG: 
                case UNSIGNEDLONG: {
                    ret = useTag ? this.myDataSet.getDataAsLong(tag) : this.myDataSet.getDataAsLong(name);
                    break;
                }
                case MONETARYUNITS: {
                    ret = useTag ? this.myDataSet.getDataAsMonetaryUnits(tag) : this.myDataSet.getDataAsMonetaryUnits(name);
                    break;
                }
                case OCTETSTRING: {
                    ret = useTag ? this.myDataSet.getDataAsOctetString(tag) : this.myDataSet.getDataAsOctetString(name);
                    break;
                }
                case RATINGDECIMAL: {
                    ret = useTag ? this.myDataSet.getDataAsRatingDecimal(tag) : this.myDataSet.getDataAsRatingDecimal(name);
                    break;
                }
                case SHORT: 
                case UNSIGNEDSHORT: {
                    ret = useTag ? this.myDataSet.getDataAsShort(tag) : this.myDataSet.getDataAsShort(name);
                    break;
                }
                case STRING: {
                    ret = useTag ? this.myDataSet.getDataAsString(tag) : this.myDataSet.getDataAsString(name);
                    break;
                }
                case TIME: {
                    ret = useTag ? this.myDataSet.getDataAsERETime(tag) : this.myDataSet.getDataAsERETime(name);
                    break;
                }
                case UNSIGNEDINT16: {
                    ret = useTag ? this.myDataSet.getDataAsUnsignedInt16(tag) : this.myDataSet.getDataAsUnsignedInt16(name);
                    break;
                }
                case UNSIGNEDINT32: {
                    ret = useTag ? this.myDataSet.getDataAsUnsignedInt32(tag) : this.myDataSet.getDataAsUnsignedInt32(name);
                    break;
                }
                case UNSIGNEDINT8: {
                    ret = useTag ? this.myDataSet.getDataAsUnsignedInt8(tag) : this.myDataSet.getDataAsUnsignedInt8(name);
                    break;
                }
                default: {
                    ret = useTag ? this.myDataSet.getDataAsObject(tag) : this.myDataSet.getDataAsObject(name);
                    break;
                }
            }
        } else {
            ret = useTag ? this.myDataSet.getDataAsObject(tag) : this.myDataSet.getDataAsObject(name);
        }
        return ret;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myDataSet == null ? 0 : this.myDataSet.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultValueContainer other = (DefaultValueContainer)obj;
        return !(this.myDataSet == null ? other.myDataSet != null : !this.myDataSet.equals(other.myDataSet));
    }

    @Override
    public Object removeData(FieldHierarchyNode field, DataType type) {
        int tag = field.getTagNumber();
        boolean useTag = tag > -1;
        Object retVal = null;
        if (this.hasData(field)) {
            retVal = this.getData(field, type);
            if (useTag) {
                this.myDataSet.clearData(tag);
            } else {
                this.myDataSet.clearData(field.getFieldName());
            }
        }
        return retVal;
    }

    private static class ValuesEqualsAndHashCodeDataSet
    extends DefaultDataSet {
        private ValuesEqualsAndHashCodeDataSet() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myValues == null ? 0 : this.myValues.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ValuesEqualsAndHashCodeDataSet other = (ValuesEqualsAndHashCodeDataSet)obj;
            return !(this.myValues == null ? other.myValues != null : !this.myValues.equals(other.myValues));
        }
    }
}

