/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.dataset;

import com.ericsson.ere.dag.DAGVisit;
import com.ericsson.ere.dataset.AbstractDataSet;
import com.ericsson.ere.dataset.ComplexKey;
import com.ericsson.ere.dataset.DataDescriber;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetAccessor;
import com.ericsson.ere.dataset.DataSetArrayHelper;
import com.ericsson.ere.dataset.DataSetDiffPrinter;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.dataset.DataSetInfoPrinter;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.dataset.DefaultDataDescriber;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.dataset.ValueContainer;
import com.ericsson.ere.defs.ServiceFieldStructure;
import com.ericsson.ere.defs.ServiceFieldStructureVisitor;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.ClassRepositoryUtil;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldRepository;
import ericsson.ere.defs.FieldStructure;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.management.FieldContext;
import ericsson.ere.management.Service;
import ericsson.ere.util.StringUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class DefaultDataSetPrinter
implements DataSetInfoPrinter<AbstractDataSet>,
DataSetDiffPrinter<DataSet, DataSet> {
    private static final SimpleDateFormat DT_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String NO_VALUE = "NO VALUE";

    @Override
    public String getDataSetDiff(DataSet current, DataSet other) {
        String diff;
        if (current == other) {
            diff = "";
        } else {
            StringBuilder buf = new StringBuilder();
            FieldContext currentFieldContext = ClassRepositoryUtil.getCurrentFieldContext(current);
            DefaultDataDescriber describer = new DefaultDataDescriber(current.getService().getClassRepository(currentFieldContext));
            FieldRepository frep = current.getService().getClassRepository(currentFieldContext).getFieldRepository();
            List<String> names = frep.getAllFieldNames();
            Collections.sort(names);
            for (String name : names) {
                FieldHierarchyNode field = frep.getFieldByName(name);
                if (field.getParent() == null && field.isLeaf()) {
                    this.diffDataField(describer, (FieldDefinition)field, current, other, buf);
                    continue;
                }
                this.diffHierarchicalField(describer, field, current, other, buf);
            }
            diff = buf.toString();
        }
        return diff;
    }

    private int getDepth(FieldHierarchyNode field) {
        int depth = 0;
        FieldHierarchyNode temp = field;
        while ((temp = temp.getParent()) != null) {
            ++depth;
        }
        return depth;
    }

    private String getIndent(FieldHierarchyNode field) {
        StringBuilder builder = new StringBuilder();
        StringUtil.repeat("    ", this.getDepth(field), builder);
        return builder.toString();
    }

    private void diffHierarchicalField(DataDescriber describer, FieldHierarchyNode field, DataSet current, DataSet newSet, StringBuilder buf) {
        Object newVal;
        Object currentVal;
        DataSetAccessor currentAcc = current.getAccessor();
        DataSetAccessor newAcc = newSet.getAccessor();
        FieldStructure parent = field.getParent();
        if (parent == null && ((currentVal = currentAcc.hasValue(field, null) ? (Object)currentAcc.getValue(field, null, null) : null) == null != ((newVal = newAcc.hasValue(field, null) ? newAcc.getValue(field, null, null) : null) == null) || currentVal != null && !currentVal.equals(newVal))) {
            this.printHierarchicalValue(describer, field, buf, newSet);
        }
    }

    @Override
    public String getInfoString(AbstractDataSet dataset) {
        Service service;
        StringBuilder builder = new StringBuilder();
        builder.append("-- Full DataSet output --");
        Calendar startTime = dataset.getStartTime();
        if (startTime != null) {
            builder.append("\nStart time:   ").append(DT_FORMAT.format(startTime.getTime()));
            builder.append("\nCurrent time: ").append(DT_FORMAT.format(dataset.getCurrentTime().getTime()));
        }
        if ((service = dataset.getService()) != null) {
            DefaultDataDescriber describer = new DefaultDataDescriber(service.getClassRepository(ClassRepositoryUtil.getCurrentFieldContext(dataset)));
            builder.append("\nService: ").append(service.getId());
            this.valuesToString(describer, dataset, builder);
            this.contextValuesToString(describer, dataset, builder);
        }
        builder.append("\n-- Output done --");
        return builder.toString();
    }

    void valuesToString(DataDescriber describer, DataSet dataset, StringBuilder stringBuilder) {
        stringBuilder.append("\nValues:\n");
        ServiceFieldStructure fieldStructure = dataset.getService().getClassRepository(ClassRepositoryUtil.getCurrentFieldContext(dataset)).getFieldStructure();
        ServiceFieldStructure.StructureElement commonFields = ServiceFieldStructure.findElement(fieldStructure.getRoot(), "Common fields");
        if (commonFields != null) {
            this.printGroup(describer, commonFields, stringBuilder, dataset);
        }
        this.printHierarchicalValues(describer, dataset, stringBuilder);
        FieldContext currentFieldContext = ClassRepositoryUtil.getCurrentFieldContext(dataset);
        if (currentFieldContext != null) {
            ServiceFieldStructure.StructureElement ratingPlanFields;
            ServiceFieldStructure.StructureElement serviceProviderFields = ServiceFieldStructure.findElement(fieldStructure.getRoot(), currentFieldContext.getServiceProviderStringKey());
            if (serviceProviderFields != null) {
                this.printGroup(describer, serviceProviderFields, stringBuilder, dataset);
            }
            if ((ratingPlanFields = ServiceFieldStructure.findElement(fieldStructure.getRoot(), currentFieldContext.getRatingPlanStringKey())) != null) {
                this.printGroup(describer, ratingPlanFields, stringBuilder, dataset);
            }
        }
    }

    private void printHierarchicalValues(DataDescriber describer, DataSet dataset, StringBuilder stringBuilder) {
        FieldRepository frep = dataset.getService().getClassRepository(ClassRepositoryUtil.getCurrentFieldContext(dataset)).getFieldRepository();
        List<FieldHierarchyNode> fields = frep.getTopLevelFields();
        Collections.sort(fields, new Comparator<FieldHierarchyNode>(){

            @Override
            public int compare(FieldHierarchyNode o1, FieldHierarchyNode o2) {
                return o1.getCanonicalName().compareTo(o2.getCanonicalName());
            }
        });
        DataSetAccessor acc = dataset.getAccessor();
        for (FieldHierarchyNode field : fields) {
            if (field.isLeaf() || !acc.hasValue(field, null)) continue;
            this.printHierarchicalValue(describer, field, stringBuilder, dataset);
        }
    }

    private void printHierarchicalValue(DataDescriber describer, FieldHierarchyNode field, StringBuilder stringBuilder, DataSet dataset) {
        if (field.isLeaf()) {
            this.printHierarchicalLeaf(describer, field, stringBuilder, dataset);
        } else if (field.getComplexType() != FieldHierarchyNode.ComplexType.NONE) {
            this.printHierarchicalCollection(describer, field, stringBuilder, dataset);
        } else {
            this.printHierarchicalPlainStruct(describer, field, stringBuilder, dataset);
        }
    }

    private void printHierarchicalLeaf(DataDescriber describer, FieldHierarchyNode field, StringBuilder stringBuilder, DataSet dataset) {
        DataSetAccessor acc = dataset.getAccessor();
        stringBuilder.append(this.getIndent(field)).append(field.getFieldName()).append(" = ");
        if (acc.hasValue(field, null)) {
            Object value = acc.getValue(field, null, null);
            stringBuilder.append(describer.describeObject(value, (FieldDefinition)field));
        } else {
            stringBuilder.append(NO_VALUE);
        }
        stringBuilder.append("\r\n");
    }

    private void printHierarchicalPlainStruct(DataDescriber describer, FieldHierarchyNode field, StringBuilder stringBuilder, DataSet dataset) {
        stringBuilder.append(this.getIndent(field)).append(field.getFieldName()).append(" = ");
        DataSetAccessor acc = dataset.getAccessor();
        if (acc.hasValue(field, null)) {
            stringBuilder.append("{\r\n");
            List<FieldHierarchyNode> children = field.getChildren();
            for (FieldHierarchyNode child : children) {
                this.printHierarchicalValue(describer, child, stringBuilder, dataset);
            }
            stringBuilder.append(this.getIndent(field)).append("}\r\n");
        } else {
            stringBuilder.append(NO_VALUE).append("\r\n");
        }
    }

    private void printHierarchicalCollection(DataDescriber describer, FieldHierarchyNode field, StringBuilder stringBuilder, DataSet dataset) {
        DataSetAccessor acc = dataset.getAccessor();
        if (acc.hasValue(field, null)) {
            switch (field.getComplexType()) {
                case SET: {
                    this.printHierarchicalSet(describer, field, stringBuilder, dataset);
                    break;
                }
                case ARRAY: 
                case MAP: {
                    this.printHierarchicalMap(describer, field, stringBuilder, dataset);
                    break;
                }
            }
        } else {
            stringBuilder.append(this.getIndent(field)).append(field.getFieldName()).append(" = ").append(NO_VALUE).append("\r\n");
        }
    }

    private void printHierarchicalMap(DataDescriber describer, FieldHierarchyNode field, StringBuilder stringBuilder, DataSet dataset) {
        stringBuilder.append(this.getIndent(field)).append(field.getFieldName()).append(" = {\r\n");
        DataSetAccessor acc = dataset.getAccessor();
        Map map = (Map)acc.getValue(field, null, null);
        ArrayList<Key> sortedKeys = new ArrayList<Key>(Arrays.asList(map.keySet().toArray(new Key[0])));
        Collections.sort(sortedKeys);
        List<FieldHierarchyNode> children = field.getChildren();
        String indent = this.getIndent(children.get(0));
        for (Key key : sortedKeys) {
            stringBuilder.append(indent).append(field.getFieldName()).append("[");
            if (field.getComplexType() == FieldHierarchyNode.ComplexType.ARRAY) {
                stringBuilder.append(key.getIndex());
            } else {
                this.printKey(key, field, describer, stringBuilder);
            }
            stringBuilder.append("] = ");
            this.printContainer(describer, field, (ValueContainer)acc.getValue(field, Arrays.asList(key), null), stringBuilder);
            if (sortedKeys.indexOf(key) < sortedKeys.size() - 1) {
                stringBuilder.append(",");
            }
            stringBuilder.append("\r\n");
        }
        stringBuilder.append(this.getIndent(field)).append("}\r\n");
    }

    private void printContainer(DataDescriber describer, FieldHierarchyNode field, ValueContainer cont, StringBuilder stringBuilder) {
        List<FieldDefinition> children = this.getNonKeysFor(field);
        stringBuilder.append("{");
        for (FieldDefinition child : children) {
            stringBuilder.append(child.getFieldName()).append(" = ");
            if (cont.hasData(child)) {
                Object value = cont.getData(child, null);
                stringBuilder.append(describer.describeObject(value, child));
            } else {
                stringBuilder.append(NO_VALUE);
            }
            if (children.indexOf(child) >= children.size() - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("}");
    }

    List<FieldDefinition> getKeysFor(FieldHierarchyNode field) {
        ArrayList<FieldDefinition> keyFields = new ArrayList<FieldDefinition>();
        for (FieldHierarchyNode child : field.getChildren()) {
            if (!child.isKey()) continue;
            keyFields.add((FieldDefinition)child);
        }
        return keyFields;
    }

    List<FieldDefinition> getNonKeysFor(FieldHierarchyNode field) {
        ArrayList<FieldDefinition> keyFields = new ArrayList<FieldDefinition>();
        for (FieldHierarchyNode child : field.getChildren()) {
            if (child.isKey()) continue;
            keyFields.add((FieldDefinition)child);
        }
        return keyFields;
    }

    private void printKey(Key key, FieldHierarchyNode field, DataDescriber describer, StringBuilder stringBuilder) {
        Object keyVal = key.getKey();
        List<FieldDefinition> keys = this.getKeysFor(field);
        if (keyVal instanceof ComplexKey) {
            ComplexKey complexKey = (ComplexKey)keyVal;
            for (int i = 0; i < complexKey.getKeyLength(); ++i) {
                Object complexKeyPart = complexKey.getKeyObjectForIndex(i);
                stringBuilder.append(describer.describeObject(complexKeyPart, keys.get(i)));
                if (i >= complexKey.getKeyLength() - 1) continue;
                stringBuilder.append(", ");
            }
        } else {
            stringBuilder.append(describer.describeObject(keyVal, keys.get(0)));
        }
    }

    private void printHierarchicalSet(DataDescriber describer, FieldHierarchyNode field, StringBuilder stringBuilder, DataSet dataset) {
        stringBuilder.append(this.getIndent(field)).append(field.getFieldName()).append(" = {\r\n");
        DataSetAccessor acc = dataset.getAccessor();
        Set set = (Set)acc.getValue(field, null, null);
        List<FieldHierarchyNode> children = field.getChildren();
        String indent = this.getIndent(children.get(0));
        for (ValueContainer cont : set) {
            stringBuilder.append(indent).append("[");
            for (FieldHierarchyNode child : children) {
                Object value = cont.getData(child, null);
                stringBuilder.append(child.getFieldName()).append(" = ");
                stringBuilder.append(describer.describeObject(value, (FieldDefinition)child));
                if (children.indexOf(child) >= children.size() - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.getIndent(field)).append("],\r\n");
        }
        stringBuilder.append(this.getIndent(field)).append("}\r\n");
    }

    void contextValuesToString(DataDescriber describer, DataSet dataset, StringBuilder stringBuilder) {
        ClassRepository repository = dataset.getService().getClassRepository(ClassRepositoryUtil.getCurrentFieldContext(dataset));
        FieldDefinition ctxField = this.getContextField(repository);
        if (ctxField != null) {
            try {
                String currentContext = String.valueOf(DefaultDataSetPrinter.getFieldData(ctxField, dataset));
                ServiceFieldStructure fieldStructure = repository.getFieldStructure();
                ServiceFieldStructure.StructureElement contextFieldRoot = ServiceFieldStructure.findElement(fieldStructure.getRoot(), currentContext);
                if (contextFieldRoot != null) {
                    stringBuilder.append("\nContext values:\n");
                    stringBuilder.append("  ").append("Current context = ").append(currentContext).append("\n");
                    this.printGroup(describer, contextFieldRoot, stringBuilder, dataset);
                }
            }
            catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
                // empty catch block
            }
        }
    }

    private FieldDefinition getContextField(ClassRepository cr) {
        String id = cr.getContextFieldIdentifier();
        return cr.getFieldDefinitionByName(id);
    }

    private void printGroup(DataDescriber describer, ServiceFieldStructure.StructureElement fieldsRoot, StringBuilder stringBuilder, DataSet data) {
        PrintingVisitor visitor = new PrintingVisitor(describer, data);
        DAGVisit.visitPreOrder(fieldsRoot, visitor);
        visitor.appendTo(stringBuilder);
    }

    private static FieldDefinition getFieldDefinition(DataSet data, String fieldName) {
        ClassRepository rep = data.getService().getClassRepository(ClassRepositoryUtil.getCurrentFieldContext(data));
        return rep.getFieldDefinitionByName(fieldName);
    }

    private static void printField(DataDescriber describer, FieldDefinition fd, StringBuilder buf, String indent, DataSet data) {
        Object value = null;
        try {
            value = DefaultDataSetPrinter.getFieldData(fd, data);
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        if (value != null) {
            DefaultDataSetPrinter.printField(describer, fd, value, buf, indent);
        }
    }

    private static Object getFieldData(FieldDefinition fd, DataSet data) {
        Object value = null;
        value = fd.usesTagNumber() ? data.getDataAsObject(fd.getTagNumber()) : data.getDataAsObject(fd.getFieldName());
        return value;
    }

    private static Map<?, ?> attemptToCreateSortedMap(Map<?, ?> map) {
        if (map == null) {
            return null;
        }
        Map<?, ?> newMap = null;
        try {
            if (!(map instanceof SortedMap)) {
                newMap = new TreeMap(new AbstractDataSet.ValueComparator());
                newMap.putAll(map);
            }
        }
        catch (ClassCastException e) {
            newMap = null;
        }
        return newMap != null ? newMap : map;
    }

    static void printField(DataDescriber describer, FieldDefinition fd, Object value, StringBuilder buf, String indent) {
        if (value != null) {
            String fieldName = fd.getFieldName();
            buf.append(indent).append(fieldName).append(" = ");
            Map<?, ?> useValue = value;
            if (value instanceof Map) {
                useValue = DefaultDataSetPrinter.attemptToCreateSortedMap(value);
            }
            DataDescriber desc = describer != null ? describer : new DefaultDataDescriber();
            String str = desc.describeObject(useValue, fd);
            buf.append(str).append('\n');
        }
    }

    private void diffDataField(DataDescriber describer, FieldDefinition fd, DataSet ownSet, DataSet newSet, StringBuilder buf) {
        Object ownValueObject = this.getFieldValueOrNull(fd, ownSet);
        Object newValueObject = this.getFieldValueOrNull(fd, newSet);
        if (ownValueObject == null) {
            if (newValueObject != null) {
                DefaultDataSetPrinter.printField(describer, fd, newValueObject, buf, "");
            }
        } else if (newValueObject == null) {
            buf.append(fd.getFieldName());
            if (fd.isArray()) {
                buf.append(" = [NO VALUE]");
            } else if (fd.isMap()) {
                buf.append(" = {NO VALUE}");
            } else {
                buf.append(" = NO VALUE");
            }
        } else if (fd.isComplexType()) {
            Map<? extends Object, ? extends Object> ownValueMap = this.convertToMap(ownValueObject);
            Map<? extends Object, ? extends Object> newValueMap = this.convertToMap(newValueObject);
            this.diffMap(describer, fd, ownValueMap, newValueMap, buf);
        } else if (!ownValueObject.equals(newValueObject)) {
            DefaultDataSetPrinter.printField(describer, fd, newValueObject, buf, "");
        }
    }

    private Map<? extends Object, ? extends Object> convertToMap(Object valueObject) {
        SortedMap<Object, Object> map = null;
        map = valueObject instanceof Map ? (SortedMap<Integer, Object>)valueObject : (DataSetArrayHelper.isOneDimensionalArray(valueObject) ? DataSetArrayHelper.convertArrayToMap(valueObject) : new TreeMap<Object, Object>(new AbstractDataSet.ValueComparator()));
        return DefaultDataSetPrinter.attemptToCreateSortedMap(map);
    }

    private Object getFieldValueOrNull(FieldDefinition fd, DataSet dataset) {
        DataSetField dsf = new DataSetField(fd, null);
        Object ret = null;
        try {
            ret = dsf.getValueFromDataSet(dataset);
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return ret;
    }

    private void diffMap(DataDescriber describer, FieldDefinition field, Map<? extends Object, ? extends Object> ownValueMap, Map<? extends Object, ? extends Object> newValueMap, StringBuilder buf) {
        boolean changed = false;
        TreeMap<Object, Object> resultingMap = new TreeMap<Object, Object>(new AbstractDataSet.ValueComparator());
        DataType dt = field.getTypedDataType();
        for (Map.Entry<? extends Object, ? extends Object> entry : ownValueMap.entrySet()) {
            Object newValueObject = newValueMap.get(entry.getKey());
            if (newValueObject != null) {
                if (this.valuesOrStringsAreEqual(entry.getValue(), newValueObject, dt)) {
                    resultingMap.put(entry.getKey(), "---");
                    continue;
                }
                changed = true;
                resultingMap.put(entry.getKey(), newValueObject);
                continue;
            }
            changed = true;
            resultingMap.put(entry.getKey(), "No value");
        }
        for (Map.Entry<? extends Object, ? extends Object> entry : newValueMap.entrySet()) {
            if (ownValueMap.containsKey(entry.getKey())) continue;
            changed = true;
            resultingMap.put(entry.getKey(), entry.getValue());
        }
        if (changed) {
            DefaultDataSetPrinter.printField(describer, field, resultingMap, buf, "");
        }
    }

    private boolean valuesOrStringsAreEqual(Object value1, Object value2, DataType dt) {
        String str2;
        if (value1.equals(value2)) {
            return true;
        }
        String str1 = dt.makeDisplayString(value1);
        return str1.equals(str2 = dt.makeDisplayString(value2));
    }

    private static class PrintingVisitor
    extends ServiceFieldStructureVisitor {
        private final DataDescriber myDescriber;
        private final DataSet myDataset;
        private List<OutputPrinter> myOutputPrinters = new ArrayList<OutputPrinter>();

        private PrintingVisitor(DataDescriber describer, DataSet data) {
            this.myDescriber = describer;
            this.myDataset = data;
            this.myOutputPrinters.add(new OutputPrinter(""));
        }

        @Override
        public void visit(ServiceFieldStructure.RootElement element) {
        }

        @Override
        public void visit(ServiceFieldStructure.CommonFieldsElement element) {
        }

        @Override
        public void visit(ServiceFieldStructure.ContextElement element) {
        }

        @Override
        public void visit(ServiceFieldStructure.ServiceProviderContextElement element) {
        }

        @Override
        public void visit(ServiceFieldStructure.RatingPlanContextElement element) {
        }

        @Override
        public void visit(ServiceFieldStructure.FieldElement element) {
            OutputPrinter lastPrinter = this.myOutputPrinters.get(this.myOutputPrinters.size() - 1);
            DefaultDataSetPrinter.printField(this.myDescriber, DefaultDataSetPrinter.getFieldDefinition(this.myDataset, element.getName()), lastPrinter.myBuilder, this.getFieldIndent(element), this.myDataset);
        }

        @Override
        public void visit(ServiceFieldStructure.GroupElement element) {
            String header = this.getGroupTitle(element);
            this.myOutputPrinters.add(new OutputPrinter(header));
        }

        @Override
        public void visit(ServiceFieldStructure.ArrayGroupElement element) {
            this.handleComplexGroup(element);
        }

        @Override
        public void visit(ServiceFieldStructure.MapGroupElement element) {
            this.handleComplexGroup(element);
        }

        private void appendTo(StringBuilder builder) {
            for (OutputPrinter printer : this.myOutputPrinters) {
                printer.appendTo(builder);
            }
        }

        private void handleComplexGroup(ServiceFieldStructure.StructureElement element) {
            String header = this.getGroupTitle(element);
            this.myOutputPrinters.add(new ComplexGroupOutputPrinter(header));
        }

        private String getGroupIndent(ServiceFieldStructure.StructureElement element) {
            return StringUtil.repeat(" ", element.getDistanceFromRoot() - 2);
        }

        private String getFieldIndent(ServiceFieldStructure.StructureElement element) {
            return "  " + this.getGroupIndent(element);
        }

        private String getGroupTitle(ServiceFieldStructure.StructureElement element) {
            return this.getGroupIndent(element) + "- " + element.getName() + "\n";
        }

        private static class ComplexGroupOutputPrinter
        extends OutputPrinter {
            private ComplexGroupOutputPrinter(String title) {
                super(title);
            }

            @Override
            protected boolean shouldPrintContent() {
                return this.myBuilder.length() > 0;
            }
        }

        private static class OutputPrinter {
            protected final StringBuilder myBuilder = new StringBuilder();
            private final String myTitle;

            private OutputPrinter(String title) {
                this.myTitle = title;
            }

            protected boolean shouldPrintContent() {
                return true;
            }

            private void appendTo(StringBuilder builder) {
                if (this.shouldPrintContent()) {
                    builder.append(this.myTitle);
                    builder.append((CharSequence)this.myBuilder);
                }
            }
        }
    }
}

